/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import java.util.List;
import org.eclipse.elk.core.util.Pair;

public final class SynthesisOption {
    public static final float DEFAULT_STEP_SIZE_FLOAT = 0.1f;
    public static final float DEFAULT_STEP_SIZE_INTEGER = 1.0f;
    private final String id;
    private final String name;
    private final TransformationOptionType type;
    private final Object initialValue;
    private List<?> values;
    private Pair<? extends Number, ? extends Number> range;
    private Number stepSize;
    private Boolean animateUpdate = null;
    private String updateStrategy = null;
    private String updateAction = null;
    private SynthesisOption category = null;
    private String description = null;

    public static SynthesisOption createSeparator() {
        return new SynthesisOption("", TransformationOptionType.SEPARATOR, true);
    }

    public static SynthesisOption createCategory(String label, boolean initiallyExpanded) {
        return SynthesisOption.createCategory(SynthesisOption.createIdFromName(label, TransformationOptionType.CATEGORY), label, initiallyExpanded);
    }

    public static SynthesisOption createCategory(String id, String label, boolean initiallyExpanded) {
        return new SynthesisOption(id, label, TransformationOptionType.CATEGORY, initiallyExpanded);
    }

    public static SynthesisOption createCategory(Class<?> clazz, String label, boolean initiallyExpanded) {
        return new SynthesisOption(SynthesisOption.createId(clazz, label, TransformationOptionType.CATEGORY), label, TransformationOptionType.CATEGORY, initiallyExpanded);
    }

    public static SynthesisOption createCategory(String label) {
        return SynthesisOption.createCategory(SynthesisOption.createIdFromName(label, TransformationOptionType.CATEGORY), label);
    }

    public static SynthesisOption createCategory(String id, String label) {
        return new SynthesisOption(id, label, TransformationOptionType.CATEGORY, true);
    }

    public static SynthesisOption createCategory(Class<?> clazz, String label) {
        return new SynthesisOption(SynthesisOption.createId(clazz, label, TransformationOptionType.CATEGORY), label, TransformationOptionType.CATEGORY, true);
    }

    public static SynthesisOption createSeparator(String label) {
        return new SynthesisOption(label, TransformationOptionType.SEPARATOR, true);
    }

    public static SynthesisOption createCheckOption(String name, Boolean initiallyChecked) {
        return SynthesisOption.createCheckOption(SynthesisOption.createIdFromName(name, TransformationOptionType.CHECK), name, initiallyChecked);
    }

    public static SynthesisOption createCheckOption(String id, String name, Boolean initiallyChecked) {
        return new SynthesisOption(id, name, TransformationOptionType.CHECK, initiallyChecked);
    }

    public static SynthesisOption createCheckOption(Class<?> clazz, String name, Boolean initiallyChecked) {
        return new SynthesisOption(SynthesisOption.createId(clazz, name, TransformationOptionType.CHECK), name, TransformationOptionType.CHECK, initiallyChecked);
    }

    public static SynthesisOption createChoiceOption(String name) {
        return SynthesisOption.createChoiceOption(SynthesisOption.createIdFromName(name, TransformationOptionType.CHOICE), name);
    }

    public static SynthesisOption createChoiceOption(String id, String name) {
        return new SynthesisOption(id, name, TransformationOptionType.CHOICE, null);
    }

    public static SynthesisOption createChoiceOption(Class<?> clazz, String name) {
        return new SynthesisOption(SynthesisOption.createId(clazz, name, TransformationOptionType.CHOICE), name, TransformationOptionType.CHOICE, null);
    }

    public static SynthesisOption createChoiceOption(String name, List<?> values, Object initialValue) {
        return SynthesisOption.createChoiceOption(SynthesisOption.createIdFromName(name, TransformationOptionType.CHOICE), name, values, initialValue);
    }

    public static SynthesisOption createChoiceOption(String id, String name, List<?> values, Object initialValue) {
        SynthesisOption option = new SynthesisOption(id, name, TransformationOptionType.CHOICE, initialValue);
        option.setValues(values);
        return option;
    }

    public static SynthesisOption createChoiceOption(Class<?> clazz, String name, List<?> values, Object initialValue) {
        return SynthesisOption.createChoiceOption(SynthesisOption.createId(clazz, name, TransformationOptionType.CHOICE), name, values, initialValue);
    }

    public static <T extends Number> SynthesisOption createRangeOption(String name, T lowerBound, T upperBound, T initialValue) {
        return SynthesisOption.createRangeOption(SynthesisOption.createIdFromName(name, TransformationOptionType.RANGE), name, lowerBound, upperBound, initialValue);
    }

    public static <T extends Number> SynthesisOption createRangeOption(String id, String name, T lowerBound, T upperBound, T initialValue) {
        SynthesisOption option = new SynthesisOption(id, name, TransformationOptionType.RANGE, initialValue);
        option.setValues((Pair<? extends Number, ? extends Number>)Pair.of(lowerBound, upperBound));
        if (!(lowerBound.equals(lowerBound.intValue()) && upperBound.equals(upperBound.intValue()) && initialValue.equals(initialValue.intValue()))) {
            option.setStepSize(Float.valueOf(0.1f));
        } else {
            option.setStepSize(Float.valueOf(1.0f));
        }
        return option;
    }

    public static <T extends Number> SynthesisOption createRangeOption(Class<?> clazz, String name, T lowerBound, T upperBound, T initialValue) {
        return SynthesisOption.createRangeOption(SynthesisOption.createId(clazz, name, TransformationOptionType.RANGE), name, lowerBound, upperBound, initialValue);
    }

    public static <T extends Number> SynthesisOption createRangeOption(String name, T lowerBound, T upperBound, T stepSize, T initialValue) {
        return SynthesisOption.createRangeOption(SynthesisOption.createIdFromName(name, TransformationOptionType.RANGE), name, lowerBound, upperBound, stepSize, initialValue);
    }

    public static <T extends Number> SynthesisOption createRangeOption(String id, String name, T lowerBound, T upperBound, T stepSize, T initialValue) {
        SynthesisOption option = new SynthesisOption(id, name, TransformationOptionType.RANGE, initialValue);
        option.setValues((Pair<? extends Number, ? extends Number>)Pair.of(lowerBound, upperBound));
        if (!(lowerBound.equals(lowerBound.intValue()) && upperBound.equals(upperBound.intValue()) && stepSize.equals(stepSize.intValue()) && initialValue.equals(initialValue.intValue()))) {
            option.setStepSize(Float.valueOf(stepSize.floatValue()));
        } else {
            option.setStepSize(Math.round(stepSize.floatValue()));
        }
        return option;
    }

    public static <T extends Number> SynthesisOption createRangeOption(Class<?> clazz, String name, T lowerBound, T upperBound, T stepSize, T initialValue) {
        return SynthesisOption.createRangeOption(SynthesisOption.createId(clazz, name, TransformationOptionType.RANGE), name, lowerBound, upperBound, stepSize, initialValue);
    }

    public static SynthesisOption createTextOption(String name) {
        return SynthesisOption.createTextOptionWithId(SynthesisOption.createIdFromName(name, TransformationOptionType.TEXT), name);
    }

    public static SynthesisOption createTextOptionWithId(String id, String name) {
        return new SynthesisOption(id, name, TransformationOptionType.TEXT, "");
    }

    public static SynthesisOption createTextOptionWithId(Class<?> clazz, String name) {
        return new SynthesisOption(SynthesisOption.createId(clazz, name, TransformationOptionType.TEXT), name, TransformationOptionType.TEXT, "");
    }

    public static SynthesisOption createTextOption(String name, String initialValue) {
        return SynthesisOption.createTextOptionWithId(SynthesisOption.createIdFromName(name, TransformationOptionType.TEXT), name, initialValue);
    }

    public static SynthesisOption createTextOptionWithId(String id, String name, String initialValue) {
        return new SynthesisOption(id, name, TransformationOptionType.TEXT, initialValue);
    }

    public static SynthesisOption createTextOptionWithId(Class<?> clazz, String name, String initialValue) {
        return new SynthesisOption(SynthesisOption.createId(clazz, name, TransformationOptionType.TEXT), name, TransformationOptionType.TEXT, initialValue);
    }

    private SynthesisOption(String theName, TransformationOptionType theType, Object theInitialValue) {
        this.id = "";
        this.name = theName;
        this.type = theType;
        this.initialValue = theInitialValue;
    }

    private SynthesisOption(String id, String theName, TransformationOptionType theType, Object theInitialValue) {
        this.id = id;
        this.name = theName;
        this.type = theType;
        this.initialValue = theInitialValue;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCheckOption() {
        return this.type.equals((Object)TransformationOptionType.CHECK);
    }

    public boolean isChoiceOption() {
        return this.type.equals((Object)TransformationOptionType.CHOICE);
    }

    public boolean isRangeOption() {
        return this.type.equals((Object)TransformationOptionType.RANGE);
    }

    public boolean isTextOption() {
        return this.type.equals((Object)TransformationOptionType.TEXT);
    }

    public boolean isSeparator() {
        return this.type.equals((Object)TransformationOptionType.SEPARATOR);
    }

    public boolean isCategory() {
        return this.type.equals((Object)TransformationOptionType.CATEGORY);
    }

    public List<?> getValues() {
        if (this.isChoiceOption()) {
            return this.values;
        }
        return null;
    }

    public Pair<? extends Number, ? extends Number> getRange() {
        if (this.isRangeOption()) {
            return this.range;
        }
        return null;
    }

    public Number getStepSize() {
        if (this.isRangeOption()) {
            return this.stepSize;
        }
        return null;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public Boolean getAnimateUpdate() {
        return this.animateUpdate;
    }

    public SynthesisOption setAnimateUpdate(boolean animate) {
        this.animateUpdate = animate;
        return this;
    }

    public String getUpdateStrategy() {
        return this.updateStrategy;
    }

    public SynthesisOption setUpdateStrategy(String strategyId) {
        this.updateStrategy = strategyId;
        return this;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public SynthesisOption setUpdateAction(String actionId) {
        this.updateAction = actionId;
        return this;
    }

    private void setValues(List<?> values) {
        if (!this.isChoiceOption()) {
            throw new UnsupportedOperationException("KLighD transformation registry: Option values are only allowed for 'Choice' options.");
        }
        this.values = values;
    }

    private void setValues(Pair<? extends Number, ? extends Number> theRange) {
        if (!this.isChoiceOption() && !this.isRangeOption()) {
            throw new UnsupportedOperationException("KLighD transformation registry: Option values are only allowed for 'choice' and 'range' options.");
        }
        this.range = theRange;
    }

    private void setStepSize(Number theStepSize) {
        if (!this.isRangeOption()) {
            throw new UnsupportedOperationException("KLighD transformation registry: The step size is only allowed for 'range' options.");
        }
        this.stepSize = theStepSize;
    }

    public SynthesisOption getCategory() {
        return this.category;
    }

    public SynthesisOption setCategory(SynthesisOption newCategory) {
        if (newCategory != null && !newCategory.isCategory()) {
            throw new IllegalArgumentException("The given synthesis option is not a category");
        }
        this.category = newCategory;
        return this;
    }

    public String getDescription() {
        return this.description != null ? this.description : this.getName();
    }

    public SynthesisOption setDescription(String newDescription) {
        this.description = newDescription;
        return this;
    }

    private static String createId(Class<?> clazz, String name, TransformationOptionType type) {
        return String.valueOf(clazz.getName()) + "." + SynthesisOption.createIdFromName(name, type);
    }

    private static String createIdFromName(String name, TransformationOptionType type) {
        return String.valueOf(type.name()) + name.hashCode();
    }

    private static enum TransformationOptionType {
        CHECK,
        CHOICE,
        RANGE,
        TEXT,
        SEPARATOR,
        CATEGORY;

    }
}

