/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IOffscreenRenderer;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.KlighdPreferences;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.internal.ILayoutConfigProvider;
import de.cau.cs.kieler.klighd.internal.ILayoutRecorder;
import de.cau.cs.kieler.klighd.internal.macrolayout.KlighdLayoutSetup;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.util.KlighdSynthesisProperties;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.DiagramLayoutEngine;
import org.eclipse.elk.core.service.ElkServicePlugin;
import org.eclipse.elk.core.util.IElkCancelIndicator;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.core.util.NullElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.ui.IWorkbenchPart;

public final class LightDiagramServices {
    private static final List<IProperty<?>> GLOBALOPTIONS = Lists.newArrayList((Object[])new IProperty[]{CoreOptions.ANIMATE, CoreOptions.ANIM_TIME_FACTOR, CoreOptions.MIN_ANIM_TIME, CoreOptions.MAX_ANIM_TIME});

    private LightDiagramServices() {
    }

    public static boolean updateDiagram(LightDiagramLayoutConfig config) {
        ViewContext theViewContext;
        if (config == null) {
            return false;
        }
        if (config.viewContext() == null) {
            Pair<IDiagramWorkbenchPart, ViewContext> dwpandvc = LightDiagramServices.determineDWPandVC(config.workbenchPart(), config.viewContext());
            theViewContext = (ViewContext)((Object)dwpandvc.getSecond());
        } else {
            theViewContext = config.viewContext();
        }
        Object currentInputModel = theViewContext.getInputModel();
        if (config.model() == null && currentInputModel == null) {
            return false;
        }
        Object theModel = config.model() != null ? config.model() : currentInputModel;
        theViewContext.getLayoutRecorder().startRecording();
        boolean successful = theViewContext.update(theModel, config.properties());
        if (!successful) {
            return false;
        }
        IDiagramWorkbenchPart diagramWP = theViewContext.getDiagramWorkbenchPart();
        if (diagramWP != null) {
            diagramWP.getSite().getPage().bringToTop((IWorkbenchPart)diagramWP);
        }
        config.performLayout();
        return true;
    }

    public static void layoutDiagram(LightDiagramLayoutConfig config) {
        IViewer theViewer;
        if (config == null) {
            String msg = "KlighD LightDiagramServices: Could not perform layout since noconfiguration has been specified.";
            Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", "KlighD LightDiagramServices: Could not perform layout since noconfiguration has been specified."));
            return;
        }
        Pair<IDiagramWorkbenchPart, ViewContext> pair = LightDiagramServices.determineDWPandVC(config.workbenchPart(), config.viewContext());
        if (pair == null || pair.getSecond() == null) {
            String msg = "KLighD LightDiagramServices: Could not perform layout since no ViewContext could be determined for IDiagramWorkbenchPart " + config.workbenchPart() + ". " + "Is the diagram correctly and completely initialized?";
            Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
            return;
        }
        IDiagramWorkbenchPart thePart = (IDiagramWorkbenchPart)pair.getFirst();
        ViewContext theViewContext = (ViewContext)((Object)pair.getSecond());
        if (thePart != null && ((theViewer = thePart.getViewer()) == null || theViewer.getControl() != null && theViewer.getControl().isDisposed())) {
            return;
        }
        ILayoutRecorder recorder = theViewContext.getLayoutRecorder();
        KNode viewModel = theViewContext.getViewModel();
        if (viewModel != null) {
            IStatus status;
            theViewContext.setProperty(KlighdInternalProperties.NEXT_ZOOM_STYLE, (Object)config.zoomStyle());
            theViewContext.setProperty(KlighdInternalProperties.NEXT_FOCUS_ELEMENT, config.focusElement());
            theViewContext.setProperty(KlighdInternalProperties.PREVIOUS_POSITION, config.previousPosition());
            ElkServicePlugin.getInstance();
            DiagramLayoutEngine.Parameters layoutParameters = new DiagramLayoutEngine.Parameters();
            LayoutConfigurator extendedConfigurator = layoutParameters.addLayoutRun();
            boolean doAnimate = config.animate() != null ? config.animate() : KlighdPreferences.isAnimateLayout();
            layoutParameters.getGlobalSettings().setProperty(CoreOptions.ANIMATE, (Object)doAnimate);
            if (config.animationTimeFactor() != null) {
                layoutParameters.getGlobalSettings().setProperty(CoreOptions.ANIM_TIME_FACTOR, (Object)config.animationTimeFactor());
            }
            if (config.minAnimationTime() != null) {
                layoutParameters.getGlobalSettings().setProperty(CoreOptions.MIN_ANIM_TIME, (Object)config.minAnimationTime());
            }
            if (config.maxAnimationTime() != null) {
                layoutParameters.getGlobalSettings().setProperty(CoreOptions.MAX_ANIM_TIME, (Object)config.maxAnimationTime());
            }
            for (IProperty<?> property : GLOBALOPTIONS) {
                if (!viewModel.getProperties().containsKey(property)) continue;
                layoutParameters.getGlobalSettings().setProperty(property, viewModel.getProperty(property));
            }
            if (thePart instanceof ILayoutConfigProvider) {
                extendedConfigurator.overrideWith(((ILayoutConfigProvider)((Object)thePart)).getLayoutConfig());
            }
            if (config.options() != null) {
                for (LayoutConfigurator c : Collections2.filter(config.options(), (Predicate)Predicates.notNull())) {
                    extendedConfigurator.overrideWith(c);
                }
            }
            List<? extends IGraphElementVisitor> additionalConfigs = theViewContext.getAdditionalLayoutConfigs();
            Object diagramPart = recorder != null ? recorder : theViewContext;
            for (IGraphElementVisitor iGraphElementVisitor : additionalConfigs) {
                layoutParameters.addLayoutRun(iGraphElementVisitor);
            }
            DiagramLayoutEngine diagramLayoutEngine = new KlighdLayoutSetup().getDiagramLayoutEngine();
            if (Klighd.IS_PLATFORM_RUNNING) {
                DispositionAwareCancelationHandle cancelationIndicator = thePart != null ? new DispositionAwareCancelationHandle(thePart) : null;
                status = (IStatus)diagramLayoutEngine.layout((IWorkbenchPart)thePart, diagramPart, (IElkCancelIndicator)cancelationIndicator, layoutParameters).getProperty(DiagramLayoutEngine.MAPPING_STATUS);
            } else {
                NullElkProgressMonitor progressMonitor = new NullElkProgressMonitor();
                status = (IStatus)diagramLayoutEngine.layout((IWorkbenchPart)thePart, diagramPart, (IElkProgressMonitor)progressMonitor, layoutParameters).getProperty(DiagramLayoutEngine.MAPPING_STATUS);
            }
            if (status != null && !status.isOK()) {
                Klighd.log(status);
            }
        } else if (recorder != null) {
            recorder.stopRecording(config.zoomStyle(), null, 0);
        }
    }

    private static Pair<IDiagramWorkbenchPart, ViewContext> determineDWPandVC(IDiagramWorkbenchPart workbenchPart, ViewContext viewContext) {
        ViewContext theViewContext;
        IDiagramWorkbenchPart thePart;
        if (workbenchPart != null) {
            thePart = workbenchPart;
            IViewer theViewer = thePart.getViewer();
            theViewContext = theViewer != null ? theViewer.getViewContext() : null;
        } else if (viewContext != null) {
            theViewContext = viewContext;
            thePart = theViewContext.getDiagramWorkbenchPart();
        } else {
            return null;
        }
        return Pair.of((Object)thePart, (Object)((Object)theViewContext));
    }

    public static void zoomDiagram(ViewContext viewContext) {
        LightDiagramServices.zoomDiagram(null, viewContext, null);
    }

    public static void zoomDiagram(ViewContext viewContext, boolean animate) {
        LightDiagramServices.zoomDiagram(null, viewContext, animate);
    }

    public static void zoomDiagram(IDiagramWorkbenchPart viewPart) {
        LightDiagramServices.zoomDiagram(viewPart, null, null);
    }

    public static void zoomDiagram(IDiagramWorkbenchPart viewPart, boolean animate) {
        LightDiagramServices.zoomDiagram(viewPart, null, animate);
    }

    private static void zoomDiagram(IDiagramWorkbenchPart workbenchPart, ViewContext viewContext, Boolean animate) {
        boolean doAnimate;
        Pair<IDiagramWorkbenchPart, ViewContext> pair = LightDiagramServices.determineDWPandVC(workbenchPart, viewContext);
        if (pair == null || pair.getSecond() == null) {
            String msg = "KLighD LightDiagramServices: Could not perform zoom since no ViewContext could be determined for IDiagramWorkbenchPart " + workbenchPart + ". " + "Is the diagram correctly and completely initialized?";
            Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
            return;
        }
        ViewContext theViewContext = (ViewContext)((Object)pair.getSecond());
        boolean bl = doAnimate = animate != null ? animate.booleanValue() : KlighdPreferences.getPreferenceStore().getBoolean("de.cau.cs.kieler.klighd.preferences.animateLayout");
        if (theViewContext.getZoomStyle() != ZoomStyle.NONE) {
            theViewContext.getViewer().zoom(theViewContext.getZoomStyle(), doAnimate ? 500 : 0);
        }
    }

    public static KNode translateModel(Object model, ViewContext otherVC, IPropertyHolder ... propertyHolders) {
        return LightDiagramServices.translateModel2(model, otherVC, propertyHolders).getViewModel();
    }

    public static ViewContext translateModel2(Object model, ViewContext otherVC, IPropertyHolder ... propertyHolders) {
        ViewContext vc = new ViewContext(otherVC, model).configure((IPropertyHolder)KlighdSynthesisProperties.create(propertyHolders));
        vc.update(model);
        return vc;
    }

    public static IStatus renderOffScreen(Object model, String format, String targetFileName) {
        return LightDiagramServices.renderOffScreen(model, format, targetFileName, null);
    }

    public static IStatus renderOffScreen(Object model, String format, String targetFileName, IPropertyHolder properties) {
        FileOutputStream output;
        try {
            output = new FileOutputStream(targetFileName);
        }
        catch (Exception e) {
            String msg = "KLighD: Target image file " + targetFileName + " cannot be created or accessed." + Klighd.LINE_SEPARATOR + "Is the (absolute or relative) path correct? Are the permissions sufficient?";
            return new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e);
        }
        IStatus result = LightDiagramServices.renderOffScreen(model, format, output, properties);
        try {
            output.close();
        }
        catch (IOException e) {
            String msg = "KLighD: Error occurred while closing the output stream employed for writing file " + targetFileName + ".";
            return new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e);
        }
        return result;
    }

    public static IStatus renderOffScreen(Object model, String format, OutputStream output) {
        return LightDiagramServices.renderOffScreen(model, format, output, null);
    }

    public static IStatus renderOffScreen(Object model, String format, OutputStream output, IPropertyHolder properties) {
        ViewContext viewContext;
        if (model == null) {
            throw new NullPointerException("KLighD offscreen rendering: The provided model must not be 'null'!");
        }
        if (format == null) {
            throw new NullPointerException("KLighD offscreen rendering: The provided format must not be 'null'!");
        }
        if (format.isEmpty()) {
            throw new RuntimeException("KLighD offscreen rendering: The provided format must not be an empty string!");
        }
        KlighdDataManager.OffscreenRendererDescriptor rendererDescriptor = (KlighdDataManager.OffscreenRendererDescriptor)Iterables.getFirst(KlighdDataManager.getInstance().getOffscreenRenderersByFormat(format), null);
        if (rendererDescriptor == null) {
            return new Status(2, "de.cau.cs.kieler.klighd", "No suitable offscreen renderer found for output format " + format + ".");
        }
        try {
            viewContext = LightDiagramServices.translateModel2(model, null, properties);
            if (viewContext.getViewModel() == null || viewContext.getViewModel().getChildren().isEmpty()) {
                return new Status(2, "de.cau.cs.kieler.klighd", "Input model couldn't be translated, got an empty view model.");
            }
        }
        catch (Throwable t) {
            return new Status(4, "de.cau.cs.kieler.klighd", "Input model couldn't be translated, see attached trace.", t);
        }
        Object theProperties = properties != null ? properties : new MapPropertyHolder();
        theProperties.setProperty(IOffscreenRenderer.OUTPUT_FORMAT, (Object)format);
        IOffscreenRenderer renderer = rendererDescriptor.supplier.get();
        if (renderer == null) {
            return new Status(4, "de.cau.cs.kieler.klighd", "Instantiation of offscreen renderer '" + rendererDescriptor.id + "' failed, see log for more information.");
        }
        IStatus result = renderer.render(viewContext, output, (IPropertyHolder)theProperties);
        return result;
    }

    private static final class DispositionAwareCancelationHandle
    implements IElkCancelIndicator {
        private final IDiagramWorkbenchPart workbenchPart;

        private DispositionAwareCancelationHandle(IDiagramWorkbenchPart wb) {
            this.workbenchPart = wb;
        }

        public boolean isCanceled() {
            return this.workbenchPart.getViewer() == null;
        }
    }
}

