/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.klighd.IAction;
import de.cau.cs.kieler.klighd.IDiagramExporter;
import de.cau.cs.kieler.klighd.IExportBranding;
import de.cau.cs.kieler.klighd.IKlighdStartupHook;
import de.cau.cs.kieler.klighd.IOffscreenRenderer;
import de.cau.cs.kieler.klighd.IPreservedProperties;
import de.cau.cs.kieler.klighd.IStyleModifier;
import de.cau.cs.kieler.klighd.IUpdateStrategy;
import de.cau.cs.kieler.klighd.IViewerProvider;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.internal.ISynthesis;
import de.cau.cs.kieler.klighd.syntheses.AbstractDiagramSynthesis;
import de.cau.cs.kieler.klighd.syntheses.GuiceBasedSynthesisFactory;
import de.cau.cs.kieler.klighd.syntheses.ReinitializingDiagramSynthesisProxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.properties.IProperty;

public final class KlighdDataManager {
    public static final String EXTP_ID_EXTENSIONS = "de.cau.cs.kieler.klighd.extensions";
    private static final String EXTP_ID_DIAGRAM_SYNTHESES = "de.cau.cs.kieler.klighd.diagramSyntheses";
    private static final String ELEMENT_VIEWER = "viewer";
    private static final String ELEMENT_DIAGRAM_SYNTHESIS = "diagramSynthesis";
    private static final String ELEMENT_UPDATE_STRATEGY = "updateStrategy";
    private static final String ELEMENT_STYLE_MODIFIER = "styleModifier";
    private static final String ELEMENT_ACTION = "action";
    private static final String ELEMENT_EXPORTER = "exporter";
    private static final String ELEMENT_EXPORT_BRANDING = "exportBranding";
    private static final String ELEMENT_OFFSCREEN_RENDERER = "offscreenRenderer";
    private static final String PRESERVED_PROPERTIES = "preservedProperties";
    private static final String ELEMENT_STARTUP_HOOK = "startupHook";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_SUPPORTED_FORMATS = "supportedFormats";
    private static final String ELEMENT_WRAPPER = "wrapper";
    private static final String ATTRIBUTE_FIGURE_CLASS_ENTRY_NAME = "figureClass";
    private static final String ATTRIBUTE_WRAPPER_CLASS_ENTRY_NAME = "wrapperClass";
    private static final String NEW_LINE = Klighd.LINE_SEPARATOR;
    public static final String CORE_EXCEPTION_ERROR_MSG = "The class definition <<CLAZZ>> cannot be found. " + NEW_LINE + "Are there any typing mistakes in the registration? " + NEW_LINE + "Is the (maybe generated) code available? " + NEW_LINE + "If required, is the class name correctly prefixed with " + GuiceBasedSynthesisFactory.CLASS_NAME + "?";
    private static final String NO_CLASS_DEF_FOUND_ERROR_MSG = "The class definition <<CLAZZ>> cannot be found. " + NEW_LINE + "Are there any typing mistakes in the registration? " + NEW_LINE + "Is the (maybe generated) code available?";
    private static final String UNEXPECTED_FAILURE_MSG = "KLighD: An unexpected failure occured while loading class <<CLAZZ>>. See attached trace for details." + NEW_LINE;
    private static final String NO_VALID_CONSTRUCTOR_FAILURE_MSG = "KLighD: An unexpected failure occured while identifying the required no-arg constructor of class <<CLAZZ>>. See attached trace for details." + NEW_LINE;
    private static final String INSTANTIATION_FAILURE_MSG = "KLighD: An unexpected failure occured while instantiating class <<CLAZZ>>. See attached trace for details." + NEW_LINE;
    private static final String STARTUP_HOOK_ERROR_MSG = "KLighD: an unexpected failure occured while executing a startup hook. See attached trace for details.";
    private static KlighdDataManager instance = new KlighdDataManager();
    private final Map<String, ISynthesis> idSynthesisMapping = Maps.newLinkedHashMap();
    private final Multimap<Class<?>, ISynthesis> typeSynthesisMapping = ArrayListMultimap.create();
    private final Map<Class<?>, Iterable<ISynthesis>> concreteTypeSynthesisMapping = Maps.newHashMap();
    private Map<String, IViewerProvider> idViewerProviderMapping = Maps.newHashMap();
    private Map<String, IUpdateStrategy> idUpdateStrategyMapping = Maps.newHashMap();
    private TreeMap<Integer, IUpdateStrategy> priorityUpdateStrategyMapping = Maps.newTreeMap();
    private IUpdateStrategy highestPriorityUpdateStrategy = null;
    private final Map<String, IStyleModifier> idStyleModifierMapping = Maps.newHashMap();
    private final BiMap<String, IAction> idActionMapping = HashBiMap.create();
    private final Map<String, IConfigurationElement> exportersMap = Maps.newHashMap();
    private final List<ExporterDescriptor> descriptors = Lists.newArrayList();
    private final Map<String, ExportBrandingDescriptor> idExportBrandingMapping = Maps.newHashMap();
    private final Map<String, OffscreenRendererDescriptor> idOffscreenRendererMapping = Maps.newHashMap();
    private final List<CustomFigureWrapperDescriptor> customFigureWrapperMapping = Lists.newArrayList();
    private final List<IProperty<?>> preservedProperties = Lists.newArrayList();
    private final List<IProperty<?>> blacklistedProperties = Lists.newArrayList();
    private final List<IProperty<?>> whitelistedProperties = Lists.newArrayList();
    private static final Comparator<Class<?>> TYPE_SORTER;

    static {
        if (Klighd.IS_PLATFORM_RUNNING) {
            instance.loadKlighdExtensionsViaExtensionPoint();
            try {
                instance.loadDiagramSynthesesViaExtensionPoint(KlighdDataManager.instance.idSynthesisMapping, KlighdDataManager.instance.typeSynthesisMapping);
            }
            catch (Exception e) {
                KlighdDataManager.instance.idSynthesisMapping.clear();
                KlighdDataManager.instance.typeSynthesisMapping.clear();
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", "KLighD: Unexptected failure while loading registered diagram syntheses.", (Throwable)e));
            }
        } else {
            instance.loadDiagramSynthesesViaServiceLoader(KlighdDataManager.instance.idSynthesisMapping, KlighdDataManager.instance.typeSynthesisMapping);
            instance.loadKlighdExtensionsViaServiceLoader();
        }
        TYPE_SORTER = new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                if (o1.isAssignableFrom(o2)) {
                    return 1;
                }
                if (o2.isAssignableFrom(o1)) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static KlighdDataManager getInstance() {
        return instance;
    }

    private KlighdDataManager() {
    }

    private static void reportError(String extensionPoint, IConfigurationElement element, String attribute, String msgSuffix, Exception exception) {
        String message = "KLighD: Element '" + element.getName() + "' extending extension point '" + extensionPoint + "', contributed by '" + element.getContributor().getName() + "' contains invalid entry in attribute '" + attribute + "'" + msgSuffix != null ? ": " + msgSuffix : ".";
        Klighd.handle((IStatus)new Status(2, "de.cau.cs.kieler.klighd", 0, message, (Throwable)exception));
    }

    private void loadKlighdExtensionsViaExtensionPoint() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_EXTENSIONS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String msg;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementName = element.getName();
            String id = element.getAttribute(ATTRIBUTE_ID);
            if (ELEMENT_WRAPPER.equals(elementName)) {
                this.registerCustomFigureWrapper(element);
            } else if (PRESERVED_PROPERTIES.equals(elementName)) {
                this.doRegisterExtension(element, IPreservedProperties.class, preservedProperties -> {
                    KlighdDataManager klighdDataManager = this.registerPreservedProperties((Iterable<IProperty<?>>)preservedProperties);
                });
            } else if (ELEMENT_STARTUP_HOOK.equals(elementName)) {
                this.doRegisterExtension(element, IKlighdStartupHook.class, startupHook -> {
                    try {
                        startupHook.execute();
                    }
                    catch (Throwable t) {
                        Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", STARTUP_HOOK_ERROR_MSG, t));
                    }
                });
            } else if (Strings.isNullOrEmpty((String)id)) {
                msg = "KLighD: Found element of type '" + elementName + "' extending extension point '" + EXTP_ID_EXTENSIONS + "', contributed by '" + element.getContributor().getName() + "' with the mandatory 'id' attribute being empty.";
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
            } else if (ELEMENT_VIEWER.equals(elementName)) {
                this.doRegisterExtension(element, IViewerProvider.class, viewerProvider -> {
                    IViewerProvider iViewerProvider = this.idViewerProviderMapping.put(id, (IViewerProvider)viewerProvider);
                });
            } else if (ELEMENT_UPDATE_STRATEGY.equals(elementName)) {
                this.doRegisterExtension(element, IUpdateStrategy.class, updateStrategy -> {
                    IUpdateStrategy iUpdateStrategy = this.doRegisterUpdateStrategy(id, (IUpdateStrategy)updateStrategy);
                });
            } else if (ELEMENT_STYLE_MODIFIER.equals(elementName)) {
                this.doRegisterExtension(element, IStyleModifier.class, styleModifier -> {
                    IStyleModifier iStyleModifier = this.idStyleModifierMapping.put(id, (IStyleModifier)styleModifier);
                });
            } else if (ELEMENT_ACTION.equals(elementName)) {
                this.doRegisterExtension(element, IAction.class, action -> {
                    Object object = this.idActionMapping.put((Object)id, action);
                });
            } else if (ELEMENT_EXPORTER.equals(elementName)) {
                this.registerExporter(id, element);
            } else if (ELEMENT_EXPORT_BRANDING.equals(elementName)) {
                this.checkFormatsAndRegisterWithSupplier(element, IExportBranding.class, (supportedFormatsSplit, supplier) -> {
                    ExportBrandingDescriptor exportBrandingDescriptor = this.idExportBrandingMapping.put(id, new ExportBrandingDescriptor(id, (Collection<String>)supportedFormatsSplit, (Supplier<IExportBranding>)supplier));
                });
            } else if (ELEMENT_OFFSCREEN_RENDERER.equals(elementName)) {
                this.checkFormatsAndRegisterWithSupplier(element, IOffscreenRenderer.class, (supportedFormatsSplit, supplier) -> {
                    OffscreenRendererDescriptor offscreenRendererDescriptor = this.idOffscreenRendererMapping.put(id, new OffscreenRendererDescriptor(id, (Collection<String>)supportedFormatsSplit, (Supplier<IOffscreenRenderer>)supplier));
                });
            } else {
                msg = "KLighD: Found element with invalid name '" + elementName + "' extending extension point '" + EXTP_ID_EXTENSIONS + "', contributed by '" + element.getContributor().getName() + "'.";
                Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
            }
            ++n2;
        }
    }

    private void loadKlighdExtensionsViaServiceLoader() {
        for (IViewerProvider viewerProvider : ServiceLoader.load(IViewerProvider.class, KlighdDataManager.class.getClassLoader())) {
            this.registerViewer(viewerProvider.getClass().getName(), viewerProvider);
        }
        for (IUpdateStrategy updateStrategy : ServiceLoader.load(IUpdateStrategy.class, KlighdDataManager.class.getClassLoader())) {
            this.registerUpdateStrategy(updateStrategy.getClass().getName(), updateStrategy);
        }
        for (IStyleModifier styleModifier : ServiceLoader.load(IStyleModifier.class, KlighdDataManager.class.getClassLoader())) {
            this.registerStyleModifier(styleModifier.getClass().getName(), styleModifier);
        }
        for (IAction action : ServiceLoader.load(IAction.class, KlighdDataManager.class.getClassLoader())) {
            this.registerAction(action.getClass().getName(), action);
        }
        for (IPreservedProperties preservedProperties : ServiceLoader.load(IPreservedProperties.class, KlighdDataManager.class.getClassLoader())) {
            this.registerPreservedProperties(preservedProperties);
        }
        for (IKlighdStartupHook startupHook : ServiceLoader.load(IKlighdStartupHook.class, KlighdDataManager.class.getClassLoader())) {
            try {
                startupHook.execute();
            }
            catch (Throwable t) {
                Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", STARTUP_HOOK_ERROR_MSG, t));
            }
        }
    }

    private <T> void doRegisterExtension(IConfigurationElement element, Class<T> type, Consumer<T> registration) {
        try {
            Object action = element.createExecutableExtension(ATTRIBUTE_CLASS);
            if (type != null && type.isInstance(action)) {
                registration.accept(type.cast(action));
            }
        }
        catch (CoreException exception) {
            Klighd.handle(exception, "de.cau.cs.kieler.klighd");
        }
    }

    private IUpdateStrategy doRegisterUpdateStrategy(String id, IUpdateStrategy updateStrategy) {
        IUpdateStrategy previous = this.idUpdateStrategyMapping.put(id, updateStrategy);
        this.priorityUpdateStrategyMapping.put(updateStrategy.getPriority(), updateStrategy);
        if (this.highestPriorityUpdateStrategy == null || this.highestPriorityUpdateStrategy.getPriority() < updateStrategy.getPriority()) {
            this.highestPriorityUpdateStrategy = updateStrategy;
        }
        return previous;
    }

    private void registerExporter(String id, IConfigurationElement element) {
        String subFormat = element.getAttribute("subFormat");
        if (subFormat == null) {
            subFormat = "";
        }
        String extension = element.getAttribute("extension");
        String descr = element.getAttribute("description");
        boolean supportsTiling = Boolean.parseBoolean(element.getAttribute("supportsTiling"));
        ExporterDescriptor descriptor = new ExporterDescriptor(id, subFormat, descr, extension, supportsTiling);
        this.descriptors.add(descriptor);
        this.exportersMap.put(id, element);
    }

    private <T> void checkFormatsAndRegisterWithSupplier(IConfigurationElement element, Class<T> type, BiConsumer<Collection<String>, Supplier<T>> registration) {
        String supportedFormats = element.getAttribute(ATTRIBUTE_SUPPORTED_FORMATS);
        if (Strings.isNullOrEmpty((String)supportedFormats)) {
            KlighdDataManager.reportError(EXTP_ID_EXTENSIONS, element, ATTRIBUTE_SUPPORTED_FORMATS, "Attribute value must not be empty.", null);
        } else {
            List supportedFormatsSplit = Lists.transform(Arrays.asList(supportedFormats.split(",")), e -> e.trim());
            registration.accept(supportedFormatsSplit, () -> {
                try {
                    Object extension = element.createExecutableExtension(ATTRIBUTE_CLASS);
                    if (type.isInstance(extension)) {
                        return type.cast(extension);
                    }
                }
                catch (CoreException exception) {
                    Klighd.handle(exception, "de.cau.cs.kieler.klighd");
                }
                return null;
            });
        }
    }

    private void registerCustomFigureWrapper(IConfigurationElement element) {
        String customFigureType = element.getAttribute(ATTRIBUTE_FIGURE_CLASS_ENTRY_NAME);
        String wrapperType = element.getAttribute(ATTRIBUTE_WRAPPER_CLASS_ENTRY_NAME);
        String contributor = element.getContributor().getName();
        if (Strings.isNullOrEmpty((String)customFigureType)) {
            String msg = "KLighD: Custom figure type is 'null' or empty in a custom figure wrapper extension of '" + contributor + "'.";
            Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
        } else if (Strings.isNullOrEmpty((String)wrapperType)) {
            String msg = "KLighD: Wrapper figure type is 'null' or empty in a custom figure wrapper extension of '" + contributor + "'.";
            Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg));
        } else {
            this.customFigureWrapperMapping.add(new CustomFigureWrapperDescriptor(customFigureType, wrapperType, contributor));
        }
    }

    public KlighdDataManager registerViewer(String id, IViewerProvider viewerProvider) {
        return this.doRegisterExtension(id, viewerProvider, IViewerProvider.class, () -> this.idViewerProviderMapping.put(id, viewerProvider));
    }

    public KlighdDataManager registerUpdateStrategy(String id, IUpdateStrategy updateStrategy) {
        return this.doRegisterExtension(id, updateStrategy, IUpdateStrategy.class, () -> this.doRegisterUpdateStrategy(id, updateStrategy));
    }

    public KlighdDataManager registerStyleModifier(String id, IStyleModifier styleModifier) {
        return this.doRegisterExtension(id, styleModifier, IStyleModifier.class, () -> this.idStyleModifierMapping.put(id, styleModifier));
    }

    public KlighdDataManager registerAction(String id, IAction action) {
        return this.doRegisterExtension(id, action, IAction.class, () -> (IAction)this.idActionMapping.put((Object)id, (Object)action));
    }

    public KlighdDataManager registerExportBranding(String id, IExportBranding exportBranding, String supportedFormat, String ... moreSupportedFormats) {
        return this.doRegisterExtension(id, exportBranding, IExportBranding.class, () -> {
            if (Strings.isNullOrEmpty((String)supportedFormat)) {
                throw new IllegalArgumentException("KLighD: The 'supportedFormat' must not be 'null' or empty, more formats may be added.");
            }
            this.idExportBrandingMapping.put(id, new ExportBrandingDescriptor(id, Lists.asList((Object)supportedFormat, (Object[])moreSupportedFormats), () -> exportBranding));
            return null;
        });
    }

    public KlighdDataManager registerOffscreenRenderer(String id, IOffscreenRenderer offscreenRenderer, String supportedFormat, String ... moreSupportedFormats) {
        return this.doRegisterExtension(id, offscreenRenderer, IOffscreenRenderer.class, () -> {
            if (Strings.isNullOrEmpty((String)supportedFormat)) {
                throw new IllegalArgumentException("KLighD: The 'supportedFormat' must not be 'null' or empty, more formats may be added.");
            }
            this.idOffscreenRendererMapping.put(id, new OffscreenRendererDescriptor(id, Lists.asList((Object)supportedFormat, (Object[])moreSupportedFormats), () -> offscreenRenderer));
            return null;
        });
    }

    private <T> KlighdDataManager doRegisterExtension(String id, T element, Class<T> type, Supplier<T> registration) {
        String typeName = type.getSimpleName();
        String msgSuffix = " while registering an '" + typeName + "'.";
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("KLighD: 'id' must not be 'null' or empty" + msgSuffix);
        }
        if (element == null) {
            throw new IllegalArgumentException("KLighD: 'viewerProvider' must not be 'null'" + msgSuffix);
        }
        T previous = registration.get();
        if (previous != null) {
            Klighd.log((IStatus)new Status(2, "de.cau.cs.kieler.klighd", String.valueOf(typeName) + " mapping of '" + id + "' -> '" + previous.getClass().getCanonicalName() + "' has been overwritten with instance of type '" + type.getCanonicalName() + "'."));
        }
        return this;
    }

    public KlighdDataManager registerCustomFigureWrapper(String customFigureType, String wrapperType) {
        return this.registerCustomFigureWrapper(customFigureType, wrapperType, null);
    }

    public KlighdDataManager registerCustomFigureWrapper(String customFigureType, String wrapperType, String contributingBundle) {
        if (Strings.isNullOrEmpty((String)customFigureType)) {
            throw new IllegalArgumentException("KLighD: Custom figure type is 'null' or empty.");
        }
        if (Strings.isNullOrEmpty((String)wrapperType)) {
            throw new IllegalArgumentException("KLighD: Wrapper figure type is 'null' or empty.");
        }
        this.customFigureWrapperMapping.add(new CustomFigureWrapperDescriptor(customFigureType, wrapperType, contributingBundle));
        return this;
    }

    public KlighdDataManager registerDiagramSynthesisClass(Class<? extends AbstractDiagramSynthesis<?>> clazz) {
        return this.registerDiagramSynthesisClass(null, clazz);
    }

    public KlighdDataManager registerDiagramSynthesisClass(String id, Class<? extends AbstractDiagramSynthesis<?>> clazz) {
        return this.registerDiagramSynthesisClass(id, clazz, true);
    }

    public KlighdDataManager registerDiagramSynthesisClass(String id, Class<? extends AbstractDiagramSynthesis<?>> clazz, boolean wrapWithReinitializer) {
        this.registerDiagramSynthesisClass(id, clazz, wrapWithReinitializer, this.idSynthesisMapping, this.typeSynthesisMapping);
        return this;
    }

    public KlighdDataManager registerPreservedProperty(IProperty<?> preservedProperty) {
        this.preservedProperties.add(preservedProperty);
        return this;
    }

    public KlighdDataManager registerPreservedProperties(Iterable<IProperty<?>> preservedProperties) {
        for (IProperty<?> preservedProperty : preservedProperties) {
            this.registerPreservedProperty(preservedProperty);
        }
        return this;
    }

    public KlighdDataManager registerBlacklistedProperty(IProperty<?> blacklistedProperty) {
        this.blacklistedProperties.add(blacklistedProperty);
        return this;
    }

    public KlighdDataManager registerBlacklistedProperties(Iterable<IProperty<?>> blacklistedProperties) {
        for (IProperty<?> blacklistedProperty : blacklistedProperties) {
            this.registerBlacklistedProperty(blacklistedProperty);
        }
        return this;
    }

    public KlighdDataManager registerWhitelistedProperty(IProperty<?> whitelistedProperty) {
        this.whitelistedProperties.add(whitelistedProperty);
        return this;
    }

    public KlighdDataManager registerWhitelistedProperties(Iterable<IProperty<?>> whitelistedProperties) {
        for (IProperty<?> whitelistedProperty : whitelistedProperties) {
            this.registerWhitelistedProperty(whitelistedProperty);
        }
        return this;
    }

    private final void loadDiagramSynthesesViaExtensionPoint(Map<String, ISynthesis> idSynthesisMapping, Multimap<Class<?>, ISynthesis> typeSynthesisMapping) {
        Iterable extensions = Iterables.filter(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_DIAGRAM_SYNTHESES)), element -> ELEMENT_DIAGRAM_SYNTHESIS.equals(element.getName()));
        for (IConfigurationElement element2 : extensions) {
            String msg;
            String id = element2.getAttribute(ATTRIBUTE_ID);
            if (Strings.isNullOrEmpty((String)id)) {
                KlighdDataManager.reportError(EXTP_ID_DIAGRAM_SYNTHESES, element2, ATTRIBUTE_ID, null, null);
                continue;
            }
            ISynthesis synthesis = null;
            try {
                synthesis = (ISynthesis)element2.createExecutableExtension(ATTRIBUTE_CLASS);
            }
            catch (CoreException exception) {
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", CORE_EXCEPTION_ERROR_MSG.replace("<<CLAZZ>>", element2.getAttribute(ATTRIBUTE_CLASS)), (Throwable)exception));
            }
            catch (NoClassDefFoundError exception) {
                msg = NO_CLASS_DEF_FOUND_ERROR_MSG.replace("<<CLAZZ>>", element2.getAttribute(ATTRIBUTE_CLASS).replaceFirst(String.valueOf(GuiceBasedSynthesisFactory.CLASS_NAME) + ":", ""));
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)exception));
            }
            catch (WrappedException exception) {
                msg = NO_CLASS_DEF_FOUND_ERROR_MSG.replace("<<CLAZZ>>", element2.getAttribute(ATTRIBUTE_CLASS).replaceFirst(String.valueOf(GuiceBasedSynthesisFactory.CLASS_NAME) + ":", ""));
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, exception.getCause()));
            }
            catch (Throwable throwable) {
                msg = UNEXPECTED_FAILURE_MSG.replace("<<CLAZZ>>", element2.getAttribute(ATTRIBUTE_CLASS).replaceFirst(String.valueOf(GuiceBasedSynthesisFactory.CLASS_NAME) + ":", ""));
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, throwable));
            }
            if (synthesis == null) continue;
            idSynthesisMapping.put(id, synthesis);
            this.inferInputType(synthesis, id, typeSynthesisMapping);
        }
    }

    private void loadDiagramSynthesesViaServiceLoader(Map<String, ISynthesis> idSynthesisMapping, Multimap<Class<?>, ISynthesis> typeSynthesisMapping) {
        Iterable extensions = Iterables.transform(ServiceLoader.load(AbstractDiagramSynthesis.class, KlighdDataManager.class.getClassLoader()), s -> s.getClass());
        for (Class clazz : extensions) {
            this.registerDiagramSynthesisClass(null, clazz, true, idSynthesisMapping, typeSynthesisMapping);
        }
    }

    private void registerDiagramSynthesisClass(String id, Class<? extends AbstractDiagramSynthesis<?>> clazz, boolean wrapWithReinitializer, Map<String, ISynthesis> idSynthesisMapping, Multimap<Class<?>, ISynthesis> typeSynthesisMapping) {
        ISynthesis synthesis;
        String nonNullId;
        String string = nonNullId = !Strings.isNullOrEmpty((String)id) ? id : clazz.getCanonicalName();
        if (wrapWithReinitializer) {
            synthesis = GuiceBasedSynthesisFactory.getReinitializingDiagramSynthesisProxy(clazz);
        } else {
            Constructor<AbstractDiagramSynthesis<?>> constructor;
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                String msg = NO_VALID_CONSTRUCTOR_FAILURE_MSG.replace("<<CLAZZ>>", clazz.getCanonicalName());
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
                return;
            }
            try {
                synthesis = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                String msg = INSTANTIATION_FAILURE_MSG.replace("<<CLAZZ>>", clazz.getCanonicalName());
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, (Throwable)e));
                return;
            }
        }
        idSynthesisMapping.put(nonNullId, synthesis);
        this.inferInputType(synthesis, nonNullId, typeSynthesisMapping);
    }

    private void inferInputType(ISynthesis synthesis, String id, Multimap<Class<?>, ISynthesis> typeSynthesisMapping) {
        try {
            Class<?> inputDataType = synthesis.getInputDataType();
            if (inputDataType != null) {
                typeSynthesisMapping.put(inputDataType, (Object)synthesis);
            }
        }
        catch (WrappedException exception) {
            Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", exception.getMessage(), exception.getCause()));
        }
        catch (Exception exception) {
            String msg = "KLighD: An unexpected exception occured while loading diagram synthesis " + id + ". See attached trace for details." + NEW_LINE + exception.getMessage();
            Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd", msg, exception.getCause()));
        }
    }

    public Iterable<ISynthesis> getAvailableSyntheses(final Class<?> type) {
        ImmutableList res;
        if (type == null) {
            return null;
        }
        Iterable<ISynthesis> knownSyntheses = this.concreteTypeSynthesisMapping.get(type);
        if (knownSyntheses != null) {
            return knownSyntheses;
        }
        ArrayList validTypes = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.typeSynthesisMapping.keySet(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> clazz) {
                return clazz.isAssignableFrom(type);
            }
        }));
        if (validTypes.isEmpty()) {
            res = Collections.emptyList();
        } else {
            Collections.sort(validTypes, TYPE_SORTER);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Class validType : validTypes) {
                builder.addAll((Iterable)this.typeSynthesisMapping.get((Object)validType));
            }
            res = builder.build();
        }
        this.concreteTypeSynthesisMapping.put(type, (Iterable<ISynthesis>)res);
        return res;
    }

    public ISynthesis getDiagramSynthesisById(String id) {
        if (id == null) {
            return null;
        }
        return this.idSynthesisMapping.get(id);
    }

    public String getSynthesisID(ISynthesis synthesis) {
        if (synthesis != null) {
            for (Map.Entry<String, ISynthesis> entry : this.idSynthesisMapping.entrySet()) {
                if (synthesis != entry.getValue()) continue;
                return entry.getKey();
            }
            for (Map.Entry<String, ISynthesis> entry : this.idSynthesisMapping.entrySet()) {
                ISynthesis matchSynthesis = entry.getValue();
                if (!(matchSynthesis instanceof ReinitializingDiagramSynthesisProxy ? synthesis.getClass() == ((ReinitializingDiagramSynthesisProxy)matchSynthesis).getDelegate().getClass() : synthesis.getClass() == matchSynthesis.getClass())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Collection<IViewerProvider> getAvailableViewerProviders() {
        return Collections.unmodifiableCollection(this.idViewerProviderMapping.values());
    }

    public IViewerProvider getViewerProviderById(String id) {
        if (id == null) {
            return null;
        }
        return this.idViewerProviderMapping.get(id);
    }

    public IUpdateStrategy getUpdateStrategyById(String id) {
        return this.idUpdateStrategyMapping.get(id);
    }

    public IUpdateStrategy getHighestPriorityUpdateStrategy() {
        return this.highestPriorityUpdateStrategy;
    }

    public IUpdateStrategy getNextPrioritizedUpdateStrategy(IUpdateStrategy strategy) {
        Map.Entry<Integer, IUpdateStrategy> lowerEntry = this.priorityUpdateStrategyMapping.lowerEntry(strategy.getPriority());
        if (lowerEntry != null) {
            return lowerEntry.getValue();
        }
        return null;
    }

    public IStyleModifier getStyleModifierById(String id) {
        return this.idStyleModifierMapping.get(id);
    }

    public IAction getActionById(String id) {
        return (IAction)this.idActionMapping.get((Object)id);
    }

    public String getActionsId(IAction action) {
        return (String)this.idActionMapping.inverse().get((Object)action);
    }

    public Set<String> getActionIds() {
        return this.idActionMapping.keySet();
    }

    public List<ExporterDescriptor> getAvailableExporters() {
        return Lists.newLinkedList(this.descriptors);
    }

    public IDiagramExporter getExporter(String id) {
        IDiagramExporter exporter = null;
        IConfigurationElement element = null;
        try {
            element = this.exportersMap.get(id);
            if (element == null) {
                throw new IllegalArgumentException("Id of " + IDiagramExporter.class + " not registered: " + id + ".");
            }
            exporter = (IDiagramExporter)element.createExecutableExtension(ATTRIBUTE_CLASS);
        }
        catch (CoreException exception) {
            KlighdDataManager.reportError(EXTP_ID_EXTENSIONS, element, ATTRIBUTE_ID, null, (Exception)((Object)exception));
        }
        return exporter;
    }

    public Iterable<IExportBranding> getExportBrandingByFormat(String format, ViewContext viewContext) {
        Collection descriptors = Collections2.filter(this.idExportBrandingMapping.values(), descr -> descr.supportedFormats.contains(format));
        ArrayList result = Lists.newArrayList();
        for (ExportBrandingDescriptor descr2 : descriptors) {
            IExportBranding branding = descr2.supplier.get();
            if (branding == null) continue;
            branding.setViewContext(viewContext);
            if (!branding.isEnabled()) continue;
            result.add(branding);
        }
        return result;
    }

    public Collection<OffscreenRendererDescriptor> getOffscreenRenderersByFormat(String format) {
        return Collections.unmodifiableCollection(Collections2.filter(this.idOffscreenRendererMapping.values(), descr -> descr.supportedFormats.contains(format)));
    }

    public List<CustomFigureWrapperDescriptor> getCustomFigureWrapperDescriptors() {
        return Collections.unmodifiableList(this.customFigureWrapperMapping);
    }

    public List<IProperty<?>> getPreservedProperties() {
        return this.preservedProperties;
    }

    public List<IProperty<?>> getBlacklistedProperties() {
        return this.blacklistedProperties;
    }

    public List<IProperty<?>> getWhitelistedProperties() {
        return this.whitelistedProperties;
    }

    public static final class CustomFigureWrapperDescriptor {
        public final String customFigureType;
        public final String wrapperType;
        public final String contributor;

        private CustomFigureWrapperDescriptor(String customFigureType, String wrapperType, String contributor) {
            this.customFigureType = customFigureType;
            this.wrapperType = wrapperType;
            this.contributor = contributor;
        }
    }

    public static final class ExportBrandingDescriptor {
        public final String exporterId;
        public final Collection<String> supportedFormats;
        public final Supplier<IExportBranding> supplier;

        public ExportBrandingDescriptor(String id, Collection<String> supportedFormats, Supplier<IExportBranding> supplier) {
            this.exporterId = id;
            this.supportedFormats = supportedFormats;
            this.supplier = supplier;
        }
    }

    public static final class ExporterDescriptor {
        public final String exporterId;
        public final String subFormatId;
        public final String description;
        public final String fileExtension;
        public final boolean supportsTiling;

        private ExporterDescriptor(String exporterId, String subFormatId, String description, String fileExtension, boolean supportsTiling) {
            this.exporterId = exporterId;
            this.subFormatId = subFormatId;
            this.description = description;
            this.fileExtension = fileExtension;
            this.supportsTiling = supportsTiling;
        }
    }

    public static final class OffscreenRendererDescriptor {
        public final String id;
        public final Collection<String> supportedFormats;
        public final Supplier<IOffscreenRenderer> supplier;

        public OffscreenRendererDescriptor(String id, Collection<String> supportedFormats, Supplier<IOffscreenRenderer> supplier) {
            this.id = id;
            this.supportedFormats = supportedFormats;
            this.supplier = supplier;
        }
    }
}

