/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import de.cau.cs.kieler.klighd.IKlighdStatusManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class Klighd {
    public static final String PLUGIN_ID = "de.cau.cs.kieler.klighd";
    public static final String UI_PLUGIN_ID = "de.cau.cs.kieler.klighd.ui";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final boolean IS_LINUX;
    public static final boolean IS_MACOSX;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_PLATFORM_RUNNING;
    private static IKlighdStatusManager statusManager;
    private static boolean suppressDisplayScaleCompensationWhileHandlingText;
    private static boolean simulateSwtFontSizeInAwt;

    static {
        suppressDisplayScaleCompensationWhileHandlingText = false;
        simulateSwtFontSizeInAwt = true;
        boolean isLinux = false;
        boolean isOSX = false;
        boolean isWindows = false;
        boolean isPlatformRunning = false;
        try {
            isLinux = Platform.getOS().equals("linux");
            isOSX = Platform.getOS().equals("macosx");
            isWindows = Platform.getOS().equals("win32");
            isPlatformRunning = Platform.isRunning();
        }
        catch (Throwable t) {
            String os = System.getProperties().get("os.name").toString().toLowerCase();
            isLinux = os.startsWith("unix");
            isOSX = os.startsWith("osx");
            isWindows = os.startsWith("win");
        }
        IS_LINUX = isLinux;
        IS_MACOSX = isOSX;
        IS_WINDOWS = isWindows;
        IS_PLATFORM_RUNNING = isPlatformRunning;
    }

    private Klighd() {
    }

    public static IKlighdStatusManager getStatusManager() {
        if (statusManager == null) {
            statusManager = IKlighdStatusManager.Impl.getInstance();
        }
        return statusManager;
    }

    public static void setStatusManager(IKlighdStatusManager impl) {
        statusManager = impl;
    }

    public static void handle(IStatus status) {
        Klighd.getStatusManager().handle(status, 1);
    }

    public static void log(IStatus status) {
        Klighd.getStatusManager().handle(status, 1);
    }

    public static void show(IStatus status) {
        Klighd.getStatusManager().handle(status, 2);
    }

    public static void handle(IStatus status, int style) {
        Klighd.getStatusManager().handle(status, style);
    }

    public static void handle(CoreException coreException, String pluginId) {
        Klighd.getStatusManager().handle((IStatus)new Status(coreException.getStatus().getSeverity(), pluginId, coreException.getLocalizedMessage(), (Throwable)coreException), 0);
    }

    public static boolean isSuppressDisplayScaleCompensationWhileHandlingText() {
        return suppressDisplayScaleCompensationWhileHandlingText;
    }

    public static void setSuppressDisplayScaleCompensationWhileHandlingText(boolean suppress) {
        suppressDisplayScaleCompensationWhileHandlingText = suppress;
    }

    public static boolean simulateSwtFontSizeInAwt() {
        return simulateSwtFontSizeInAwt;
    }

    public static void setSimulateSwtFontSizeInAwt(boolean simulate) {
        simulateSwtFontSizeInAwt = simulate;
    }
}

