/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.ViewChangeType;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface IViewChangeListener {
    public void viewChanged(ViewChange var1);

    public static class ViewChange {
        private final IViewer activeViewer;
        private final ViewChangeType changeType;
        private final KGraphElement affectedElement;
        private final double diagramScale;
        private Map<ViewChangeType, Long> notificationSuppressions;
        private static final List<ViewChangeType> VIEW_PORT = Collections.singletonList(ViewChangeType.VIEW_PORT);

        public ViewChange(IViewer viewer, ViewChangeType type, KGraphElement element, Rectangle2D viewPort, double diagramScale) {
            this.activeViewer = viewer;
            this.changeType = type;
            this.affectedElement = element;
            this.diagramScale = diagramScale;
        }

        public IViewer getViewer() {
            return this.activeViewer;
        }

        public ViewContext getViewContext() {
            if (this.activeViewer != null) {
                return this.activeViewer.getViewContext();
            }
            return null;
        }

        public ViewChangeType getType() {
            return this.changeType;
        }

        public KGraphElement getAffectedElement() {
            return this.affectedElement;
        }

        public double getDiagramZoomScale() {
            return this.diagramScale;
        }

        public Iterator<KNode> visibleDiagramNodes() {
            return this.activeViewer.getVisibleDiagramNodes();
        }

        public Iterator<KGraphElement> visibleDiagramElements() {
            return this.activeViewer.getVisibleDiagramElements();
        }

        public ViewChange suppressSubsequentNotifications(ViewChangeType ... changeTypes) {
            return this.suppressSubsequentNotifications(0, changeTypes);
        }

        public ViewChange suppressSubsequentNotifications(Iterable<ViewChangeType> changeTypes) {
            return this.suppressSubsequentNotifications(0, changeTypes);
        }

        public ViewChange suppressSubsequentNotifications(int durationInMS, ViewChangeType ... changeTypes) {
            return this.suppressSubsequentNotifications(durationInMS, Lists.newArrayList((Object[])changeTypes));
        }

        public ViewChange suppressSubsequentNotifications(int durationInMS, Iterable<ViewChangeType> changeTypes) {
            if (this.notificationSuppressions == null) {
                this.notificationSuppressions = Maps.newHashMap();
            }
            for (ViewChangeType type : changeTypes) {
                if (durationInMS > 0) {
                    this.notificationSuppressions.put(type, System.currentTimeMillis() + (long)durationInMS);
                    continue;
                }
                this.notificationSuppressions.put(type, 0L);
            }
            return this;
        }

        public ViewChange suppressSubsequentViewPortChangeNotification() {
            return this.suppressSubsequentNotifications(0, VIEW_PORT);
        }

        public ViewChange suppressSubsequentViewPortChangeNotifications(int durationInMS) {
            return this.suppressSubsequentNotifications(durationInMS, VIEW_PORT);
        }

        public Map<ViewChangeType, Long> obtainAndResetNotificationSuppressionConfig() {
            Map<ViewChangeType, Long> result = this.notificationSuppressions;
            this.notificationSuppressions = null;
            return result;
        }
    }
}

