/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd;

import com.google.common.collect.ImmutableList;
import de.cau.cs.kieler.klighd.IExportBranding;
import de.cau.cs.kieler.klighd.ViewContext;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DiagramExportConfig {
    public final ViewContext viewContext;
    public final Rectangle2D diagramBounds;
    public final Dimension tileBounds;
    public final double diagramScale;
    public final java.awt.Point dotsPerInch;
    public final IExportBranding.Trim deviceTrim;
    public boolean exportViewport = false;
    public boolean applyCameraZoomLevel = false;
    public boolean exportSemanticData = false;
    public boolean setTextLengths = false;
    public Iterable<IExportBranding> exportBrandings = Collections.emptyList();
    public IExportBranding.Trim diagramTrim = null;
    public IExportBranding.Trim tileTrim = null;
    public final int pages;
    public int pageNo = 0;
    public int row = 0;
    public int column = 0;
    public boolean firstRow = false;
    public boolean firstColumn = false;
    public boolean lastRow = false;
    public boolean lastColumn = false;

    public DiagramExportConfig(ViewContext viewContext, Rectangle2D diagramBounds, Dimension tileBounds) {
        this(viewContext, diagramBounds, tileBounds, 1.0, null, IExportBranding.Trim.EMPTY_TRIM, 1);
    }

    public DiagramExportConfig(ViewContext viewContext, Rectangle2D diagramBounds, Dimension tileBounds, double diagramScale, int pages) {
        this(viewContext, diagramBounds, tileBounds, diagramScale, new java.awt.Point(), IExportBranding.Trim.EMPTY_TRIM, pages);
        Point dpi = Display.getCurrent().getDPI();
        this.dotsPerInch.setLocation(dpi.x, dpi.y);
    }

    public DiagramExportConfig(ViewContext viewContext, Rectangle2D diagramBounds, Dimension tileBounds, double diagramScale, java.awt.Point dotsPerInch, IExportBranding.Trim deviceTrim, int pages) {
        this.viewContext = viewContext;
        this.diagramBounds = diagramBounds;
        this.tileBounds = tileBounds;
        this.diagramScale = diagramScale;
        this.dotsPerInch = dotsPerInch;
        this.deviceTrim = deviceTrim;
        this.pages = pages;
    }

    public DiagramExportConfig(DiagramExportConfig original) {
        this.viewContext = original.viewContext;
        this.diagramBounds = new Rectangle2D.Double();
        this.diagramBounds.setRect(original.diagramBounds);
        this.diagramScale = original.diagramScale;
        this.diagramTrim = original.diagramTrim;
        this.tileBounds = new Dimension(original.tileBounds);
        this.tileTrim = original.tileTrim;
        this.dotsPerInch = new java.awt.Point(original.dotsPerInch);
        this.deviceTrim = original.deviceTrim;
        this.exportBrandings = ImmutableList.copyOf(original.exportBrandings);
        this.exportViewport = original.exportViewport;
        this.applyCameraZoomLevel = original.applyCameraZoomLevel;
        this.exportSemanticData = original.exportSemanticData;
        this.setTextLengths = original.setTextLengths;
        this.pages = original.pages;
        this.pageNo = original.pageNo;
        this.row = original.row;
        this.column = original.column;
        this.firstRow = original.firstRow;
        this.firstColumn = original.firstColumn;
        this.lastRow = original.lastRow;
        this.lastColumn = original.lastColumn;
    }

    public Rectangle2D getDiagramBoundsIncludingTrim() {
        return new Rectangle2D.Double(this.diagramTrim.left, this.diagramTrim.top, this.diagramBounds.getWidth() + (double)this.diagramTrim.getWidth(), this.diagramBounds.getHeight() + (double)this.diagramTrim.getHeight());
    }

    public DiagramExportConfig setExportViewport(boolean exportViewport) {
        this.exportViewport = exportViewport;
        return this;
    }

    public DiagramExportConfig setApplyCameraZoomLevel(boolean applyCameraZoomLevel) {
        this.applyCameraZoomLevel = applyCameraZoomLevel;
        return this;
    }

    public DiagramExportConfig setExportSemanticData(boolean exportSemanticData) {
        this.exportSemanticData = exportSemanticData;
        return this;
    }

    public DiagramExportConfig setTextLengths(boolean setTextLengths) {
        this.setTextLengths = setTextLengths;
        return this;
    }

    public DiagramExportConfig setBrandingsAndTrim(Iterable<IExportBranding> exportBrandings, IExportBranding.Trim diagramTrim, IExportBranding.Trim tileTrim) {
        this.exportBrandings = exportBrandings != null ? exportBrandings : Collections.emptyList();
        this.diagramTrim = diagramTrim;
        this.tileTrim = tileTrim;
        return this;
    }

    public DiagramExportConfig setPageAndTileNumbers(int pageNo, int row, int column, int rows, int columns) {
        this.setPageAndTileNumbers(pageNo, row, column, row == rows - 1, column == columns - 1);
        return this;
    }

    public DiagramExportConfig setPageAndTileNumbers(int pageNo, int row, int column, boolean lastRow, boolean lastColumn) {
        this.pageNo = pageNo;
        this.row = row;
        this.column = column;
        this.firstRow = row == 0;
        this.firstColumn = column == 0;
        this.lastRow = lastRow;
        this.lastColumn = lastColumn;
        return this;
    }

    public DiagramExportConfig setTileInfo(boolean firstColumn, boolean firstRow, boolean lastColumn, boolean lastRow) {
        this.firstColumn = firstColumn;
        this.firstRow = firstRow;
        this.lastColumn = lastColumn;
        this.lastRow = lastRow;
        return this;
    }
}

