/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.viewers;

import com.google.common.base.Function;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IKlighdSelection;
import de.cau.cs.kieler.klighd.IModelModificationHandler;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.IViewerProvider;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdConstants;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.piccolo.IKlighdNode;
import de.cau.cs.kieler.klighd.piccolo.KlighdNode;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KLabelNode;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KlighdMainCamera;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KlighdStyledText;
import de.cau.cs.kieler.klighd.piccolo.internal.util.NodeUtil;
import de.cau.cs.kieler.klighd.piccolo.viewer.PiccoloOutlinePage;
import de.cau.cs.kieler.klighd.piccolo.viewer.PiccoloViewer;
import de.cau.cs.kieler.klighd.ui.KlighdTextSelection;
import de.cau.cs.kieler.klighd.ui.modifymodel.ModelModificationHandlerProvider;
import de.cau.cs.kieler.klighd.ui.viewers.KlighdLabelWidgetEventHandler;
import de.cau.cs.kieler.klighd.viewers.ContextViewer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PiccoloViewerUI
extends PiccoloViewer {
    public static final String ID = "de.cau.cs.kieler.klighd.ui.viewers.PiccoloViewerUI";
    private StyledText labelWidget;
    private float dpiScaleY = 1.0f;
    static final String TEXT_STYLING_CHANGE_LISTENER_KEY = "TEXT_STYLING_CHANGE_LISTENER_KEY";
    private static final String STYLED_TEXT_FIGURE_KEY = "STYLED_TEXT_FIGURE_KEY";
    private static final String FONT_SCALE_FACTOR_KEY = "FONT_SCALE_FACTOR_KEY";
    private static final String FONT_HEIGHT_PATTERN_REGEX = "\\|\\d*\\p{Punct}\\d*\\|";
    private static Pattern fontHeightPattern = null;

    public PiccoloViewerUI(ContextViewer parentViewer, Composite parent) {
        this(parentViewer, parent, 0);
    }

    public PiccoloViewerUI(ContextViewer parentViewer, Composite parent, int style) {
        super(parentViewer, parent);
        this.addLabelTextWidget(parentViewer);
    }

    protected StyledText getLabelTextWidget() {
        return this.labelWidget;
    }

    protected void addLabelTextWidget(final ContextViewer parentViewer) {
        this.labelWidget = new StyledText((Composite)this.getControl(), 2);
        this.labelWidget.setEditable(false);
        this.labelWidget.setVisible(false);
        if (!Klighd.isSuppressDisplayScaleCompensationWhileHandlingText()) {
            this.dpiScaleY = KlighdConstants.DEFAULT_DISPLAY_DPI / (float)this.getControl().getDisplay().getDPI().y;
        }
        this.labelWidget.setFont(new Font((Device)this.labelWidget.getDisplay(), this.labelWidget.getFont().getFontData()));
        MenuManager menu = new MenuManager();
        this.labelWidget.setMenu(menu.createContextMenu((Control)this.labelWidget));
        IDiagramWorkbenchPart part = parentViewer.getViewContext().getDiagramWorkbenchPart();
        if (part != null) {
            part.getSite().registerContextMenu("de.cau.cs.kieler.klighd.ui.popupMenu.floatingText", menu, (ISelectionProvider)parentViewer);
        }
        this.getControl().getCamera().addInputEventListener((PInputEventListener)new KlighdLabelWidgetEventHandler(this, this.labelWidget));
        final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof KlighdTextSelection) {
                    return;
                }
                PiccoloViewerUI.this.labelWidget.setSelection(0, 0);
                PiccoloViewerUI.this.deactivateLabelWidget();
            }
        };
        parentViewer.addSelectionChangedListener(selectionListener);
        this.labelWidget.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                parentViewer.removeSelectionChangedListener(selectionListener);
            }
        });
        this.attachLabelTextWidgetEventListener(this.labelWidget);
    }

    protected void attachLabelTextWidgetEventListener(StyledText textLabelWidget) {
        new LabelTextWidgetListener(this, textLabelWidget);
    }

    protected void updateSelection(final IKlighdSelection selection) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PiccoloViewerUI.super.updateSelection(selection);
            }
        });
    }

    void updateWidgetBounds(KlighdStyledText styledText) {
        Matcher matcher;
        KlighdStyledText theStyledText;
        if (styledText != null) {
            this.labelWidget.setData(STYLED_TEXT_FIGURE_KEY, (Object)styledText);
            theStyledText = styledText;
        } else {
            if (this.labelWidget.isDisposed()) {
                return;
            }
            theStyledText = (KlighdStyledText)this.labelWidget.getData(STYLED_TEXT_FIGURE_KEY);
            if (theStyledText == null) {
                return;
            }
        }
        KlighdMainCamera camera = this.getControl().getCamera();
        PBounds bounds = NodeUtil.clipRelativeGlobalBoundsOf((PNode)theStyledText, (IKlighdNode.IKNodeNode)camera.getDisplayedKNodeNode());
        if (bounds == null) {
            return;
        }
        camera.getViewTransformReference().transform((Rectangle2D)bounds, (Rectangle2D)bounds);
        this.labelWidget.setLocation((int)Math.round(bounds.getX()), (int)Math.round(bounds.getY()));
        Float prevFontScale = (Float)this.labelWidget.getData(FONT_SCALE_FACTOR_KEY);
        float curViewScale = (float)camera.getViewScale() * this.dpiScaleY;
        if (styledText == null && prevFontScale != null && prevFontScale.floatValue() == curViewScale) {
            return;
        }
        this.labelWidget.setData(FONT_SCALE_FACTOR_KEY, (Object)Float.valueOf(curViewScale));
        String fontConfig = theStyledText.getFontData().toString();
        if (fontHeightPattern == null) {
            fontHeightPattern = Pattern.compile(FONT_HEIGHT_PATTERN_REGEX);
        }
        float givenHeight = (matcher = fontHeightPattern.matcher(fontConfig)).find() ? Float.valueOf(fontConfig.substring(matcher.start() + 1, matcher.end() - 1)).floatValue() : (float)theStyledText.getFontData().getHeight();
        FontData fd = new FontData(matcher.replaceFirst("|" + Float.toString(givenHeight * curViewScale) + "|"));
        Font previousFont = this.labelWidget.getFont();
        this.labelWidget.setFont(new Font((Device)this.labelWidget.getDisplay(), fd));
        this.labelWidget.setSize(this.labelWidget.computeSize(-1, -1));
        previousFont.dispose();
    }

    void deactivateLabelWidget() {
        this.labelWidget.setVisible(false);
        KlighdStyledText node = (KlighdStyledText)this.labelWidget.getData(STYLED_TEXT_FIGURE_KEY);
        if (node != null) {
            node.setOccludedOnMainDiagram(false);
            node.removePropertyChangeListener((PropertyChangeListener)this.labelWidget.getData(TEXT_STYLING_CHANGE_LISTENER_KEY));
        }
    }

    private void updateModelAfterTextChange(StyledText textWidget, ViewContext viewContext) {
        KNode relatedKGE;
        KLabelNode relatedLabel;
        KlighdStyledText textNode;
        block9: {
            textNode = (KlighdStyledText)textWidget.getData(STYLED_TEXT_FIGURE_KEY);
            if (textNode == null) {
                return;
            }
            KlighdStyledText node = textNode;
            do {
                if ((node = node.getParent()) == null) {
                    return;
                }
                if (!(node instanceof IKlighdNode.IKNodeNode)) continue;
                relatedLabel = null;
                relatedKGE = ((IKlighdNode.IKNodeNode)node).getViewModelElement();
                break block9;
            } while (!(node instanceof KLabelNode));
            relatedLabel = (KLabelNode)node;
            relatedKGE = relatedLabel.getViewModelElement();
        }
        if (relatedLabel != null && textWidget.getText().equals(relatedLabel.getText()) || relatedLabel == null && textWidget.getText().equals(textNode.getText())) {
            return;
        }
        Function f = viewContext.getDiagramSynthesis().getTextUpdateFunction((KText)textNode.getViewModelElement(), (KGraphElement)relatedKGE);
        if (f == null) {
            return;
        }
        IWorkbenchPart wPart = viewContext.getSourceWorkbenchPart();
        IModelModificationHandler handler = ModelModificationHandlerProvider.getInstance().getFittingHandler(wPart);
        try {
            if (handler != null) {
                handler.execute(wPart, f, textWidget.getText());
            } else {
                f.apply((Object)textWidget.getText());
            }
        }
        catch (Exception e) {
            String msg = "KLighD: An error occured while applying the updated string value in " + viewContext.getDiagramWorkbenchPart().getPartId() + "!";
            Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", msg, (Throwable)e));
        }
    }

    protected PiccoloOutlinePage createDiagramOutlinePage() {
        return new PiccoloContentOutlinePage();
    }

    public static class LabelTextWidgetListener
    implements Listener {
        private final PiccoloViewerUI diagramViewer;
        private final StyledText labelWidget;
        private String prevSelection = null;

        public LabelTextWidgetListener(PiccoloViewerUI viewer, StyledText textLabelWidget) {
            this.diagramViewer = viewer;
            this.labelWidget = textLabelWidget;
            textLabelWidget.addListener(3, (Listener)this);
            textLabelWidget.addListener(4, (Listener)this);
            textLabelWidget.addListener(1, (Listener)this);
            textLabelWidget.addListener(2, (Listener)this);
        }

        protected KlighdNode.KlighdFigureNode<KText> getFigureNode() {
            KlighdNode.KlighdFigureNode figureNode = (KlighdNode.KlighdFigureNode)this.labelWidget.getData(PiccoloViewerUI.STYLED_TEXT_FIGURE_KEY);
            return figureNode;
        }

        protected String getPrevSelection() {
            return this.prevSelection;
        }

        protected void setPrevSelection(String prevSelection) {
            this.prevSelection = prevSelection;
        }

        public void handleEvent(Event event) {
            StyledText text = this.labelWidget;
            switch (event.type) {
                case 1: {
                    if ((char)event.keyCode == '\r' && (event.stateMask & 0x20000) != 0) {
                        this.diagramViewer.updateModelAfterTextChange(text, this.diagramViewer.getViewContext());
                        text.setEditable(false);
                        text.setVisible(false);
                        break;
                    }
                    if ((char)event.keyCode != '\u20000') break;
                    this.prevSelection = this.labelWidget.getSelectionText();
                    break;
                }
                case 2: {
                    String selection;
                    if (event.keyCode != 131072 || (selection = this.labelWidget.getSelectionText()).equals(this.prevSelection)) break;
                    this.diagramViewer.updateSelection(new KlighdTextSelection(selection, this.labelWidget.getSelection().x, false, false, this.getFigureNode(), (IViewer)this.diagramViewer));
                    break;
                }
                case 3: {
                    if (event.button != 1 || (event.stateMask & 0x20000) != 0) break;
                    this.prevSelection = this.labelWidget.getSelectionText();
                    break;
                }
                case 4: {
                    String selection;
                    if (event.button != 1 || (selection = text.getSelectionText()).equals(this.prevSelection)) break;
                    this.diagramViewer.updateSelection(new KlighdTextSelection(selection, this.labelWidget.getSelection().x, false, false, this.getFigureNode(), (IViewer)this.diagramViewer));
                }
            }
        }
    }

    private static class PiccoloContentOutlinePage
    extends PiccoloOutlinePage
    implements IContentOutlinePage {
        private PiccoloContentOutlinePage() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return null;
        }

        public void setSelection(ISelection selection) {
        }
    }

    public static class Provider
    implements IViewerProvider {
        public IViewer createViewer(ContextViewer parentViewer, Composite parent) {
            return new PiccoloViewerUI(parentViewer, parent);
        }
    }
}

