/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.viewers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.klighd.IViewChangeListener;
import de.cau.cs.kieler.klighd.ViewChangeType;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.piccolo.IKlighdNode;
import de.cau.cs.kieler.klighd.ui.viewers.PiccoloViewerUI;
import de.cau.cs.kieler.klighd.util.ModelingUtil;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.StyledText;

class KlighdLabelWidgetViewChangeListener
implements IViewChangeListener {
    private final PiccoloViewerUI viewer;
    private StyledText labelWidget;

    KlighdLabelWidgetViewChangeListener(PiccoloViewerUI viewer, StyledText labelWidget) {
        this.viewer = viewer;
        this.labelWidget = labelWidget;
    }

    public void viewChanged(IViewChangeListener.ViewChange change) {
        if (change.getType() == ViewChangeType.VIEW_PORT || this.labelWidget.isDisposed() || !this.labelWidget.isVisible()) {
            return;
        }
        List graphNodes = (List)this.labelWidget.getData("STYLED_TEXT_PARENTS_KEY");
        switch (change.getType()) {
            case VIEW_PORT: {
                break;
            }
            case COLLAPSE: {
                this.handleCollapse(change, graphNodes);
                break;
            }
            case HIDE: {
                this.handleHide(change, graphNodes);
                break;
            }
            case CLIP: {
                this.handleClip(change, graphNodes);
            }
        }
    }

    private void handleCollapse(IViewChangeListener.ViewChange change, List<IKlighdNode.IKGraphElementNode> graphNodes) {
        KNode collapsedElement = (KNode)change.getAffectedElement();
        KNode parentKNode = (KNode)((IKlighdNode.IKGraphElementNode)Iterables.getLast(graphNodes)).getViewModelElement();
        UnmodifiableIterator it = Iterators.filter((Iterator)ModelingUtil.eAllContainers((EObject)parentKNode), KNode.class);
        KNode clip = change.getViewer().getClip();
        KNode node = (KNode)it.next();
        while (node != clip && it.hasNext()) {
            if (node == collapsedElement) {
                this.viewer.deactivateLabelWidget();
                return;
            }
            node = (KNode)it.next();
        }
    }

    private void handleHide(IViewChangeListener.ViewChange change, List<IKlighdNode.IKGraphElementNode> graphNodes) {
        KGraphElement hiddenElement = change.getAffectedElement();
        for (IKlighdNode.IKGraphElementNode node : graphNodes) {
            if (node.getViewModelElement() != hiddenElement) continue;
            this.viewer.deactivateLabelWidget();
            return;
        }
        if (!(hiddenElement instanceof KNode)) {
            return;
        }
        KNode parentKNode = (KNode)((IKlighdNode.IKGraphElementNode)Iterables.getLast(graphNodes)).getViewModelElement();
        UnmodifiableIterator it = Iterators.filter((Iterator)ModelingUtil.eAllContainers((EObject)parentKNode), KNode.class);
        KNode clip = change.getViewer().getClip();
        KNode node = (KNode)it.next();
        while (node != clip && it.hasNext()) {
            if (node == hiddenElement) {
                this.viewer.deactivateLabelWidget();
                return;
            }
            node = (KNode)it.next();
        }
    }

    private void handleClip(IViewChangeListener.ViewChange change, List<IKlighdNode.IKGraphElementNode> graphNodes) {
        KNode newClip = (KNode)change.getAffectedElement();
        KNode parentKNode = (KNode)((IKlighdNode.IKGraphElementNode)Iterables.getLast(graphNodes)).getViewModelElement();
        UnmodifiableIterator it = Iterators.filter((Iterator)ModelingUtil.eAllContainers((EObject)parentKNode), KNode.class);
        KNode node = (KNode)it.next();
        while (it.hasNext()) {
            if (node == newClip) {
                this.viewer.updateWidgetBounds(null);
                return;
            }
            node = (KNode)it.next();
        }
        this.viewer.deactivateLabelWidget();
    }
}

