/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.viewers;

import com.google.common.base.Strings;
import de.cau.cs.kieler.klighd.KlighdConstants;
import de.cau.cs.kieler.klighd.ViewChangeType;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.piccolo.IKlighdNode;
import de.cau.cs.kieler.klighd.piccolo.internal.events.KlighdBasicInputEventHandler;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KLabelNode;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KNodeNode;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KlighdMainCamera;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KlighdStyledText;
import de.cau.cs.kieler.klighd.ui.viewers.KlighdLabelWidgetViewChangeListener;
import de.cau.cs.kieler.klighd.ui.viewers.PiccoloViewerUI;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class KlighdLabelWidgetEventHandler
extends KlighdBasicInputEventHandler {
    private final PiccoloViewerUI viewer;
    private final KlighdMainCamera camera;
    private StyledText labelWidget;
    private PropertyChangeListener labelWidgetStylingEventListener;
    private boolean widgetJustPrepared = false;
    static final String STYLED_TEXT_PARENTS_KEY = "STYLED_TEXT_PARENTS_KEY";
    private final Runnable resetWidgetJustPrepared = new Runnable(){

        @Override
        public void run() {
            KlighdLabelWidgetEventHandler.this.widgetJustPrepared = false;
        }
    };

    public KlighdLabelWidgetEventHandler(final PiccoloViewerUI viewer, StyledText labelWidget) {
        this.viewer = viewer;
        this.camera = viewer.getControl().getCamera();
        this.labelWidget = labelWidget;
        new PropertyChangeListener(){
            {
                KlighdLabelWidgetEventHandler.this.camera.addPropertyChangeListener("viewTransform", (PropertyChangeListener)this);
                KlighdLabelWidgetEventHandler.this.camera.addPropertyChangeListener("dispose", (PropertyChangeListener)this);
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String propName = event.getPropertyName();
                if ("viewTransform".equals(propName)) {
                    viewer.updateWidgetBounds(null);
                } else if ("dispose".equals(propName)) {
                    KlighdLabelWidgetEventHandler.this.camera.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        };
        this.labelWidgetStylingEventListener = new PropertyChangeListener(labelWidget){
            {
                styledText.setData("TEXT_STYLING_CHANGE_LISTENER_KEY", (Object)this);
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                boolean update;
                String propName = event.getPropertyName();
                boolean bl = update = "paint" == propName || "font" == propName || "text  paint" == propName;
                if (update) {
                    KlighdLabelWidgetEventHandler.this.updateTextInputColoringAndSize((KlighdStyledText)event.getSource());
                }
            }
        };
        viewer.addViewChangeListener(new KlighdLabelWidgetViewChangeListener(viewer, labelWidget), new ViewChangeType[0]);
    }

    public void mouseMoved(PInputEvent event) {
        if (this.widgetJustPrepared) {
            event.setHandled(true);
        } else {
            if (this.viewer.isMagnificationLensVisible()) {
                return;
            }
            if (event.getPickedNode() instanceof KlighdStyledText) {
                this.updateTextInput(event, false);
            } else if (this.labelWidget.getSelectionCount() == 0) {
                this.viewer.deactivateLabelWidget();
            }
        }
    }

    public void mousePressed(PInputEvent event) {
        if (this.widgetJustPrepared) {
            event.setHandled(true);
        } else {
            boolean widgetVisible;
            if (this.viewer.isMagnificationLensVisible()) {
                return;
            }
            if (this.labelWidget.isVisible() && this.labelWidget.getSelectionCount() != 0) {
                boolean widgetVisible2 = this.updateTextInput(event, true);
                if (!widgetVisible2) {
                    return;
                }
                event.setHandled(true);
            } else if (!this.labelWidget.isVisible() && (widgetVisible = this.updateTextInput(event, false))) {
                event.setHandled(true);
            }
        }
    }

    public void mouseReleased(PInputEvent event) {
        if (this.widgetJustPrepared) {
            event.setHandled(true);
        }
    }

    private boolean updateTextInput(PInputEvent event, boolean force) {
        PNode n = event.getPickedNode();
        if (!(n instanceof KlighdStyledText)) {
            return false;
        }
        KlighdStyledText styledText = (KlighdStyledText)n;
        KText kText = (KText)styledText.getViewModelElement();
        if (kText == null || !kText.isCursorSelectable() || !force && this.labelWidget.getSelectionCount() > 0) {
            return false;
        }
        this.viewer.deactivateLabelWidget();
        String text = styledText.getText();
        if (text == null) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)text)) {
            this.labelWidget.setText(" ");
        } else {
            this.labelWidget.setText(text);
        }
        this.labelWidget.setEditable(kText.isEditable());
        this.updateTextInputColoringAndSize(styledText);
        styledText.addPropertyChangeListener(this.labelWidgetStylingEventListener);
        this.attachTextsParentInformation(styledText);
        styledText.setOccludedOnMainDiagram(true);
        this.labelWidget.setVisible(true);
        this.labelWidget.setFocus();
        this.setWidgetPrepared();
        return true;
    }

    private void updateTextInputColoringAndSize(KlighdStyledText styledText) {
        this.viewer.updateWidgetBounds(styledText);
        Color oldColor = this.labelWidget.getForeground();
        this.labelWidget.setForeground(new Color((Device)this.labelWidget.getDisplay(), styledText.getPenColor()));
        oldColor.dispose();
        Color oldBackground = this.labelWidget.getBackground();
        if (styledText.getBackgroundColor() != null) {
            this.labelWidget.setBackground(new Color((Device)this.labelWidget.getDisplay(), styledText.getBackgroundColor()));
            oldBackground.dispose();
        } else if (!oldBackground.getRGB().equals((Object)KlighdConstants.WHITE)) {
            this.labelWidget.setBackground(new Color((Device)this.labelWidget.getDisplay(), KlighdConstants.WHITE));
            oldBackground.dispose();
        }
    }

    private void attachTextsParentInformation(KlighdStyledText text) {
        PNode parent = KlighdLabelWidgetEventHandler.getParentGraphNode((PNode)text);
        if (parent == null) {
            return;
        }
        ArrayList<PNode> parents = new ArrayList<PNode>(3);
        if (parent instanceof KLabelNode) {
            parents.add(parent);
            parent = KlighdLabelWidgetEventHandler.getParentGraphNode(parent);
        }
        if (parent != null && !(parent instanceof KNodeNode)) {
            parents.add(parent);
            parent = KlighdLabelWidgetEventHandler.getParentGraphNode(parent);
        }
        if (parent != null) {
            parents.add(parent);
        }
        this.labelWidget.setData(STYLED_TEXT_PARENTS_KEY, parents);
    }

    static PNode getParentGraphNode(PNode node) {
        PNode parent = node;
        while ((parent = parent.getParent()) != null && !(parent instanceof IKlighdNode.IKGraphElementNode)) {
        }
        return parent;
    }

    private void setWidgetPrepared() {
        this.widgetJustPrepared = true;
        this.labelWidget.getDisplay().timerExec(250, this.resetWidgetJustPrepared);
    }
}

