/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing.dialog;

import de.cau.cs.kieler.klighd.ui.printing.DiagramPrintOptions;
import de.cau.cs.kieler.klighd.ui.printing.KlighdUIPrintingMessages;
import de.cau.cs.kieler.klighd.ui.printing.PrintExporter;
import de.cau.cs.kieler.klighd.ui.printing.PrintOptions;
import de.cau.cs.kieler.klighd.ui.printing.dialog.DialogUtil;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

final class ScalingBlock {
    private static final int MAX_PAGES = 100;
    private static final int BUTTONS_GROUP_COLUMNS = 3;
    private static final int PAGES_GROUP_COLUMNS = 5;
    private static final int SCALING_GROUP_COLUMNS = 4;

    private ScalingBlock() {
    }

    public static Group createContents(Composite parent, DataBindingContext bindings, PrintOptions options) {
        Group result = DialogUtil.group(parent, KlighdUIPrintingMessages.PrintDialog_Scaling);
        DialogUtil.layout((Composite)result, 1);
        Composite buttonsGroup = new Composite((Composite)result, 0);
        DialogUtil.layoutFillHorizontal((Control)buttonsGroup, true);
        buttonsGroup.setLayout((Layout)new GridLayout(3, false));
        Button oneToOneBtn = DialogUtil.button(buttonsGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_to100);
        Button fitToPagesBtn = DialogUtil.button(buttonsGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_fitPages);
        Button adjustPagesBtn = DialogUtil.button(buttonsGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_adjustPages);
        Composite scalingGroup = new Composite((Composite)result, 0);
        DialogUtil.layoutFillHorizontal((Control)scalingGroup, true);
        scalingGroup.setLayout((Layout)new GridLayout(4, false));
        DialogUtil.label(scalingGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_lbl_scaleTo);
        Spinner scaleSpinner = DialogUtil.spinner(scalingGroup, 1, Integer.MAX_VALUE);
        DialogUtil.layoutFillHorizontal((Control)scaleSpinner, true);
        DialogUtil.label(scalingGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_lbl_percent);
        Composite pagesGroup = new Composite((Composite)result, 0);
        DialogUtil.layoutFillHorizontal((Control)pagesGroup, true);
        pagesGroup.setLayout((Layout)new GridLayout(5, false));
        DialogUtil.label(pagesGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_lbl_printTo);
        Spinner spinnerWide = DialogUtil.spinner(pagesGroup, 1, 100);
        DialogUtil.layoutWidth((Control)spinnerWide, spinnerWide.computeSize((int)-1, (int)-1).x);
        DialogUtil.label(pagesGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_lbl_pagesWide);
        Spinner spinnerTall = DialogUtil.spinner(pagesGroup, 1, 100);
        DialogUtil.layoutWidth((Control)spinnerTall, spinnerTall.computeSize((int)-1, (int)-1).x);
        DialogUtil.label(pagesGroup, KlighdUIPrintingMessages.PrintDialog_Scaling_lbl_pagesTall);
        if (options instanceof DiagramPrintOptions) {
            DiagramPrintOptions dOptions = (DiagramPrintOptions)options;
            oneToOneBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> ScalingBlock.scaleOneToOne(dOptions)));
            fitToPagesBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> ScalingBlock.fitToPages(dOptions)));
            adjustPagesBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                PrintExporter exporter = dOptions.getExporter();
                Dimension2D trimmedPrinterBounds = exporter.getTrimmedTileBounds(dOptions);
                PDimension diagramBounds = exporter.getDiagramBoundsIncludingTrim();
                dOptions.setPagesWide((int)Math.ceil(diagramBounds.getWidth() * dOptions.getScaleFactor() / trimmedPrinterBounds.getWidth()));
                dOptions.setPagesTall((int)Math.ceil(diagramBounds.getHeight() * dOptions.getScaleFactor() / trimmedPrinterBounds.getHeight()));
            }));
            Realm realm = bindings.getValidationRealm();
            IObservableValue scalePercent = BeanProperties.value(DiagramPrintOptions.class, (String)"scalePercent").observe(realm, (Object)dOptions);
            ISWTObservableValue observerScaleSpinner = WidgetProperties.widgetSelection().observe((Widget)scaleSpinner);
            bindings.bindValue((IObservableValue)observerScaleSpinner, scalePercent);
            IObservableValue pagesWide = BeanProperties.value(DiagramPrintOptions.class, (String)"pagesWide").observe(realm, (Object)dOptions);
            ISWTObservableValue observerWideSpinner = WidgetProperties.widgetSelection().observe((Widget)spinnerWide);
            bindings.bindValue((IObservableValue)observerWideSpinner, pagesWide);
            IObservableValue pagesTall = BeanProperties.value(DiagramPrintOptions.class, (String)"pagesTall").observe(realm, (Object)dOptions);
            ISWTObservableValue observerTallSpinner = WidgetProperties.widgetSelection().observe((Widget)spinnerTall);
            bindings.bindValue((IObservableValue)observerTallSpinner, pagesTall);
            result.addListener(12, event -> {
                scalePercent.dispose();
                pagesWide.dispose();
                pagesTall.dispose();
            });
        } else {
            result.setEnabled(false);
            Control[] controlArray = result.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setEnabled(false);
                if (c instanceof Composite) {
                    Control[] controlArray2 = ((Composite)c).getChildren();
                    int n3 = controlArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Control d = controlArray2[n4];
                        d.setEnabled(false);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static void fitToPages(DiagramPrintOptions dOptions) {
        PrintExporter exporter = dOptions.getExporter();
        PDimension diagramBounds = exporter.getDiagramBoundsIncludingTrim();
        Dimension2D trimmedPrinterBounds = exporter.getTrimmedTileBounds(dOptions);
        double scaleX = trimmedPrinterBounds.getWidth() * (double)dOptions.getPagesWide() / diagramBounds.getWidth();
        double scaleY = trimmedPrinterBounds.getHeight() * (double)dOptions.getPagesTall() / diagramBounds.getHeight();
        dOptions.setScaleFactor(Math.min(scaleX, scaleY));
    }

    public static void scaleOneToOne(DiagramPrintOptions dOptions) {
        dOptions.setScaleFactor(1.0);
    }
}

