/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing.dialog;

import de.cau.cs.kieler.klighd.DiagramExportConfig;
import de.cau.cs.kieler.klighd.ui.printing.DiagramPrintOptions;
import de.cau.cs.kieler.klighd.ui.printing.PrintExporter;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class PrintPreviewTray
extends DialogTray {
    private final DataBindingContext bindings;
    private final DiagramPrintOptions options;
    private Composite body;
    private Composite composite;
    protected static final int MINIMAL_TILE_SIZE = 4;
    protected static final int BORDER_SIZE = 20;
    protected static final int OBSERVABLE_DELAY = 100;

    PrintPreviewTray(DataBindingContext bindings, DiagramPrintOptions options) {
        this.bindings = bindings;
        this.options = options;
    }

    public Control createContents(Composite parent) {
        Realm realm = this.bindings.getValidationRealm();
        this.body = new Composite(parent, 0);
        this.body.setBackground(Display.getCurrent().getSystemColor(15));
        this.body.setSize(parent.getSize());
        this.composite = new Composite(this.body, 0);
        this.updateComposite();
        IValueChangeListener listener = event -> this.updateComposite();
        ISWTObservableValue observedSize = WidgetProperties.size().observe((Widget)this.body);
        IObservableValue delayedResize = Observables.observeDelayedValue((int)100, (IObservableValue)observedSize);
        delayedResize.addValueChangeListener(listener);
        IObservableValue observedData = BeanProperties.value(DiagramPrintOptions.class, (String)"printerData").observe(realm, (Object)this.options);
        IObservableValue delayedPrinterData = Observables.observeDelayedValue((int)100, (IObservableValue)observedData);
        delayedPrinterData.addValueChangeListener(listener);
        IObservableValue observedScale = BeanProperties.value(DiagramPrintOptions.class, (String)"scaleFactor").observe(realm, (Object)this.options);
        IObservableValue delayedScale = Observables.observeDelayedValue((int)100, (IObservableValue)observedScale);
        delayedScale.addValueChangeListener(listener);
        IObservableValue observedPagesWide = BeanProperties.value(DiagramPrintOptions.class, (String)"pagesWide").observe(realm, (Object)this.options);
        IObservableValue delayedPagesWide = Observables.observeDelayedValue((int)100, (IObservableValue)observedPagesWide);
        delayedPagesWide.addValueChangeListener(listener);
        IObservableValue observedScaleTall = BeanProperties.value(DiagramPrintOptions.class, (String)"pagesTall").observe(realm, (Object)this.options);
        IObservableValue delayedPagesTall = Observables.observeDelayedValue((int)100, (IObservableValue)observedScaleTall);
        delayedPagesTall.addValueChangeListener(listener);
        IObservableValue observedHorCenter = BeanProperties.value(DiagramPrintOptions.class, (String)"horizontallyCentered").observe(realm, (Object)this.options);
        IObservableValue delayedHorCentered = Observables.observeDelayedValue((int)100, (IObservableValue)observedHorCenter);
        delayedHorCentered.addValueChangeListener(listener);
        IObservableValue observedVertCenter = BeanProperties.value(DiagramPrintOptions.class, (String)"verticallyCentered").observe(realm, (Object)this.options);
        IObservableValue delayedVerCentered = Observables.observeDelayedValue((int)100, (IObservableValue)observedVertCenter);
        delayedVerCentered.addValueChangeListener(listener);
        IObservableValue observedOrientation = BeanProperties.value(DiagramPrintOptions.class, (String)"orientation").observe(realm, (Object)this.options);
        IObservableValue delayedOrientation = Observables.observeDelayedValue((int)100, (IObservableValue)observedOrientation);
        delayedOrientation.addValueChangeListener(listener);
        this.body.addListener(12, event -> {
            delayedResize.dispose();
            delayedPrinterData.dispose();
            delayedScale.dispose();
            delayedPagesWide.dispose();
            delayedPagesTall.dispose();
            delayedHorCentered.dispose();
            delayedVerCentered.dispose();
            delayedOrientation.dispose();
        });
        return this.body;
    }

    public void updateComposite() {
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        this.body.setRedraw(false);
        Control[] children = this.composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.composite.setLayout(null);
        this.composite.pack();
        this.composite.setLayout((Layout)new GridLayout(this.options.getPagesWide(), true));
        Point bodySize = this.body.getSize();
        int imageHeight = (bodySize.y - (2 + this.options.getPagesTall() - 1) * 20) / this.options.getPagesTall();
        int imageWidth = (bodySize.x - (2 + this.options.getPagesWide() - 1) * 20) / this.options.getPagesWide();
        Dimension pageBounds = this.options.getPrinterBounds();
        float printerRatio = (float)pageBounds.width / (float)pageBounds.height;
        if ((float)imageHeight * printerRatio < (float)imageWidth) {
            imageWidth = (int)((float)imageHeight * printerRatio);
        } else if ((float)imageWidth * (1.0f / printerRatio) < (float)imageHeight) {
            imageHeight = (int)((float)imageWidth * (1.0f / printerRatio));
        }
        if (imageHeight > 4 && imageWidth > 4) {
            PrintExporter exporter = this.options.getExporter();
            int rows = this.options.getPagesTall();
            int columns = this.options.getPagesWide();
            DiagramExportConfig config = exporter.createExportConfig(this.options);
            Dimension imageBounds = new Dimension(imageWidth, imageHeight);
            double previewScale = (double)imageWidth / (double)pageBounds.width;
            Rectangle imageClip = exporter.getBasicPageClip(imageBounds, config.tileTrim.getScaled((float)previewScale));
            Point2D centeringOffset = this.options.getCenteringOffset(previewScale);
            int pageNo = 0;
            int row = 0;
            while (row < rows) {
                int column = 0;
                while (column < columns) {
                    config.setPageAndTileNumbers(++pageNo, row, column, rows, columns);
                    Image pageImg = exporter.exportPreview(config, this.options.getPrinter(), imageBounds, imageClip, previewScale, centeringOffset);
                    Label l = new Label(this.composite, 0);
                    l.setImage(pageImg);
                    l.addListener(12, event -> pageImg.dispose());
                    ++column;
                }
                ++row;
            }
        }
        this.composite.pack();
        org.eclipse.swt.graphics.Rectangle compositeBounds = this.composite.getBounds();
        compositeBounds.x = (this.body.getSize().x - compositeBounds.width) / 2;
        compositeBounds.y = (this.body.getSize().y - compositeBounds.height) / 2;
        this.composite.setBounds(compositeBounds);
        this.body.setRedraw(true);
    }
}

