/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing.dialog;

import de.cau.cs.kieler.klighd.ui.printing.DiagramPrintOptions;
import de.cau.cs.kieler.klighd.ui.printing.KlighdUIPrintingMessages;
import de.cau.cs.kieler.klighd.ui.printing.PrintOptions;
import de.cau.cs.kieler.klighd.ui.printing.dialog.ActionsBlock;
import de.cau.cs.kieler.klighd.ui.printing.dialog.AlignmentBlock;
import de.cau.cs.kieler.klighd.ui.printing.dialog.CopiesBlock;
import de.cau.cs.kieler.klighd.ui.printing.dialog.DialogUtil;
import de.cau.cs.kieler.klighd.ui.printing.dialog.OrientationBlock;
import de.cau.cs.kieler.klighd.ui.printing.dialog.PrintPreviewTray;
import de.cau.cs.kieler.klighd.ui.printing.dialog.PrinterBlock;
import de.cau.cs.kieler.klighd.ui.printing.dialog.RangeBlock;
import de.cau.cs.kieler.klighd.ui.printing.dialog.ScalingBlock;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class KlighdPrintDialog
extends TrayDialog {
    private DataBindingContext bindings;
    private final PrintOptions options;
    private final boolean diagramPrintOptionsAvailable;

    public KlighdPrintDialog(IShellProvider parentShell, PrintOptions options) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.options = options;
        this.diagramPrintOptionsAvailable = options instanceof DiagramPrintOptions;
    }

    public KlighdPrintDialog(Shell shell, PrintOptions options) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.options = options;
        this.diagramPrintOptionsAvailable = options instanceof DiagramPrintOptions;
    }

    public final int open() {
        if (!this.checkPrinterData()) {
            this.setBlockOnOpen(false);
            super.open();
            PrinterData data = this.getNativePrintDialog().open();
            if (data == null) {
                this.close();
                return 1;
            }
            this.options.setPrinterData(data);
        }
        this.setBlockOnOpen(true);
        return super.open();
    }

    private boolean checkPrinterData() {
        try {
            this.options.getPrinter();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected PrintDialog getNativePrintDialog() {
        PrintDialog printDialog = new PrintDialog(this.getParentShell());
        printDialog.setText(KlighdUIPrintingMessages.KlighdPrintDialog_InitialDialog_title);
        return printDialog;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(KlighdUIPrintingMessages.KlighdPrintDialog_Title);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.bindings = new DataBindingContext(DisplayRealm.getRealm((Display)parent.getDisplay()));
        boolean previewInitiallyOpen = this.diagramPrintOptionsAvailable && DiagramPrintOptions.getInitiallyShowPreview() && this.checkPrinterData();
        Composite result = new Composite(parent, 0);
        DialogUtil.layout(result, 2);
        this.createPrinterBlockArea(result);
        this.createScalingBlockArea(result);
        this.createOrientationBlockArea(result);
        this.createAlignmentBlockArea(result);
        this.createRangeBlockArea(result);
        this.createCopiesBlockArea(result);
        this.createExtensibleBlockArea(result);
        this.createActionsBlockArea(result, previewInitiallyOpen);
        if (previewInitiallyOpen) {
            parent.getDisplay().asyncExec(this::openPreview);
        }
        return result;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            return super.createButton(parent, id, KlighdUIPrintingMessages.KlighdPrintDialog_OK_label, defaultButton);
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    public PrintPreviewTray getTray() {
        return (PrintPreviewTray)super.getTray();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        shell.setMinimumSize(shell.getSize());
    }

    protected void createPrinterBlockArea(Composite parent) {
        DialogUtil.layoutSpanHorizontal((Control)PrinterBlock.createContents(parent, this.bindings, this.options, this), 2);
    }

    protected void createScalingBlockArea(Composite parent) {
        DialogUtil.layoutSpanHorizontal((Control)ScalingBlock.createContents(parent, this.bindings, this.options), 2);
        if (this.diagramPrintOptionsAvailable && DiagramPrintOptions.getAutoScaleTo100()) {
            ScalingBlock.scaleOneToOne((DiagramPrintOptions)this.options);
        }
        if (this.diagramPrintOptionsAvailable && DiagramPrintOptions.getAutoScaleToFit()) {
            ScalingBlock.fitToPages((DiagramPrintOptions)this.options);
        }
    }

    protected void createOrientationBlockArea(Composite parent) {
        OrientationBlock.createContents(parent, this.bindings, this.options);
    }

    protected void createAlignmentBlockArea(Composite parent) {
        AlignmentBlock.createContents(parent, this.bindings, this.options);
    }

    protected void createRangeBlockArea(Composite parent) {
        RangeBlock.createContents(parent, this.bindings, this.options);
    }

    protected void createCopiesBlockArea(Composite parent) {
        CopiesBlock.createContents(parent, this.bindings, this.options);
    }

    protected void createExtensibleBlockArea(Composite parent) {
    }

    protected void createActionsBlockArea(Composite parent, boolean previewInitiallyOpen) {
        DialogUtil.layoutSpanHorizontal(ActionsBlock.createContents(parent, this, this.diagramPrintOptionsAvailable, previewInitiallyOpen), 2);
    }

    public void openPreview() {
        if (this.diagramPrintOptionsAvailable) {
            this.openTray(new PrintPreviewTray(this.bindings, (DiagramPrintOptions)this.options));
        }
    }

    public boolean close() {
        this.options.storeToPreferences();
        return super.close();
    }
}

