/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing.dialog;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

final class DialogUtil {
    private static final int VERTICAL_INDENT = 15;
    private static final int HORIZONTAL_INDENT = 15;

    private DialogUtil() {
    }

    static Composite layout(Composite composite, int columns) {
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginLeft = 6;
        gridLayout.marginRight = 6;
        gridLayout.marginTop = 6;
        gridLayout.marginBottom = 3;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    static GridData getLayoutData(Control control) {
        GridData result = (GridData)control.getLayoutData();
        if (result == null) {
            result = new GridData();
            control.setLayoutData((Object)result);
        }
        return result;
    }

    static Control layoutFillHorizontal(Control control, boolean grab) {
        GridData data = DialogUtil.getLayoutData(control);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = grab;
        return control;
    }

    static Control layoutFillVertical(Control control) {
        GridData data = DialogUtil.getLayoutData(control);
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        return control;
    }

    static Control layoutAlignLeft(Control control) {
        GridData data = DialogUtil.getLayoutData(control);
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = false;
        return control;
    }

    static Control layoutAlignRight(Control control) {
        GridData data = DialogUtil.getLayoutData(control);
        data.horizontalAlignment = 0x1000008;
        data.grabExcessHorizontalSpace = false;
        return control;
    }

    static Control layoutFillBoth(Control control) {
        GridData data = DialogUtil.getLayoutData(control);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        return control;
    }

    static Control layoutSpanHorizontal(Control control, int span) {
        GridData data = DialogUtil.getLayoutData(control);
        data.horizontalSpan = span;
        return control;
    }

    static Control layoutHorizontalIndent(Control control) {
        DialogUtil.layoutHorizontalIndent(control, 15);
        return control;
    }

    static Control layoutHorizontalIndent(Control control, int indent) {
        GridData data = DialogUtil.getLayoutData(control);
        data.horizontalIndent = indent;
        return control;
    }

    static Control layoutVerticalIndent(Control control) {
        DialogUtil.layoutVerticalIndent(control, 15);
        return control;
    }

    static Control layoutVerticalIndent(Control control, int indent) {
        GridData data = DialogUtil.getLayoutData(control);
        data.verticalIndent = indent;
        return control;
    }

    static Control layoutWidth(Control control, int width) {
        if (width > 0) {
            GridData data = DialogUtil.getLayoutData(control);
            data.widthHint = width;
        }
        return control;
    }

    static Control layoutHeight(Control control, int height) {
        if (height > 0) {
            GridData data = DialogUtil.getLayoutData(control);
            data.heightHint = height;
        }
        return control;
    }

    static Group group(Composite parent, String text) {
        Group result = new Group(parent, 0);
        result.setText(text);
        DialogUtil.layoutFillBoth((Control)result);
        return result;
    }

    static Label label(Composite parent, String text) {
        Label result = new Label(parent, 0);
        result.setText(text);
        return result;
    }

    static Text text(Composite parent, int width) {
        Text result = new Text(parent, 2052);
        DialogUtil.layoutFillHorizontal((Control)result, false);
        DialogUtil.layoutWidth((Control)result, width);
        return result;
    }

    static ComboViewer combo(Composite parent) {
        ComboViewer result = new ComboViewer(parent);
        return result;
    }

    static Scale scale(Composite parent, int min, int max) {
        Scale result = new Scale(parent, 256);
        result.setMinimum(min);
        result.setMaximum(max);
        return result;
    }

    static Button button(Composite parent, String text) {
        Button result = new Button(parent, 8);
        result.setText(text);
        return result;
    }

    static Button radio(Composite parent, String text) {
        Button result = new Button(parent, 16);
        result.setText(text);
        return result;
    }

    static Button check(Composite parent, String text) {
        Button result = new Button(parent, 32);
        result.setText(text);
        return result;
    }

    static Spinner spinner(Composite parent, int min, int max) {
        Spinner result = new Spinner(parent, 2048);
        result.setMinimum(min);
        result.setMaximum(max);
        return result;
    }

    static Control blank(Composite parent) {
        Label result = new Label(parent, 0);
        return result;
    }
}

