/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing;

import com.google.common.base.Strings;
import de.cau.cs.kieler.klighd.IExportBranding;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PrintOptions {
    public static final String PROPERTY_PRINTER_DATA = "printerData";
    public static final String PROPERTY_PRINTER_NAME = "printerName";
    public static final String PROPERTY_COPIES = "copies";
    public static final String PROPERTY_COLLATE = "collate";
    public static final String PROPERTY_ALL_PAGES = "allPages";
    public static final String PROPERTY_RANGE_FROM = "rangeFrom";
    public static final String PROPERTY_RANGE_TO = "rangeTo";
    public static final String PROPERTY_DUPLEX = "duplex";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_SCALE_FACTOR = "scaleFactor";
    public static final String PROPERTY_SCALE_PERCENT = "scalePercent";
    public static final String PROPERTY_PAGES_WIDE = "pagesWide";
    public static final String PROPERTY_PAGES_TALL = "pagesTall";
    public static final String PROPERTY_CENTER_HORIZONTALLY = "horizontallyCentered";
    public static final String PROPERTY_CENTER_VERTICALLY = "verticallyCentered";
    private static final String PREFERENCE_PRINTER_DRIVER = "klighd.printing.driver";
    private static final String PREFERENCE_PRINTER_NAME = "klighd.printing.name";
    private static final String PREFERENCE_PRINTER_SCALE = "klighd.printing.scale";
    private static final String PREFERENCE_PRINTER_PAGES_TALL = "klighd.printing.pagesTall";
    private static final String PREFERENCE_PRINTER_PAGES_WIDE = "klighd.printing.pagesWide";
    private static final String PREFERENCE_PRINTER_SCOPE = "klighd.printing.scope";
    private static final String PREFERENCE_PRINTER_PAGES_START = "klighd.printing.pagesStart";
    private static final String PREFERENCE_PRINTER_PAGES_END = "klighd.printing.pagesEnd";
    private static final String PREFERENCE_PRINTER_CENTER_HORIZONTALLY = "klighd.printing.centerHorizontally";
    private static final String PREFERENCE_PRINTER_CENTER_VERTICALLY = "klighd.printing.centerVertically";
    private static final String PREFERENCE_PRINTER_ORIENTATION = "klighd.printing.orientation";
    private static final String PREFERENCE_PRINTER_DUPLEX = "klighd.printing.duplex";
    private static final String PREFERENCE_PRINTER_COLLATE = "klighd.printing.collate";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final IPreferenceStore prefStore;
    private PrinterData printerData;
    private double scaleFactor;
    private int pagesWide;
    private int pagesTall;
    private boolean centerHorizontally;
    private boolean centerVertically;
    private Printer printer = null;
    private Dimension printerBounds = null;
    private IExportBranding.Trim printerTrim = null;
    private Point2D centeringOffset = null;
    private static final double PERCENT_FACTOR = 100.0;

    public PrintOptions(IPreferenceStore prefStore) {
        this.prefStore = prefStore;
        this.restoreFromPreferences();
    }

    public void restoreFromPreferences() {
        String driver = this.prefStore.getString(PREFERENCE_PRINTER_DRIVER);
        String name = this.prefStore.getString(PREFERENCE_PRINTER_NAME);
        this.printerData = new PrinterData(Strings.emptyToNull((String)driver), Strings.emptyToNull((String)name));
        if (this.printerData != null) {
            this.setAllPages(this.prefStore.getInt(PREFERENCE_PRINTER_SCOPE) == 0);
            this.setRangeFrom(this.prefStore.getInt(PREFERENCE_PRINTER_PAGES_START));
            this.setRangeTo(this.prefStore.getInt(PREFERENCE_PRINTER_PAGES_END));
            this.setOrientation(this.prefStore.getInt(PREFERENCE_PRINTER_ORIENTATION));
            this.setDuplex(this.prefStore.getInt(PREFERENCE_PRINTER_DUPLEX));
            this.setCollate(this.prefStore.getBoolean(PREFERENCE_PRINTER_COLLATE));
        }
        this.setScaleFactor(this.prefStore.getDouble(PREFERENCE_PRINTER_SCALE));
        this.setPagesTall(this.prefStore.getInt(PREFERENCE_PRINTER_PAGES_TALL));
        this.setPagesWide(this.prefStore.getInt(PREFERENCE_PRINTER_PAGES_WIDE));
        this.setHorizontallyCentered(this.prefStore.getBoolean(PREFERENCE_PRINTER_CENTER_HORIZONTALLY));
        this.setVerticallyCentered(this.prefStore.getBoolean(PREFERENCE_PRINTER_CENTER_VERTICALLY));
    }

    public void storeToPreferences() {
        this.prefStore.setValue(PREFERENCE_PRINTER_DRIVER, this.printerData.driver);
        this.prefStore.setValue(PREFERENCE_PRINTER_NAME, this.printerData.name);
        this.prefStore.setValue(PREFERENCE_PRINTER_SCALE, this.scaleFactor);
        this.prefStore.setValue(PREFERENCE_PRINTER_PAGES_TALL, this.pagesTall);
        this.prefStore.setValue(PREFERENCE_PRINTER_PAGES_WIDE, this.pagesWide);
        this.prefStore.setValue(PREFERENCE_PRINTER_SCOPE, this.printerData.scope);
        this.prefStore.setValue(PREFERENCE_PRINTER_PAGES_START, this.printerData.startPage);
        this.prefStore.setValue(PREFERENCE_PRINTER_PAGES_END, this.printerData.endPage);
        this.prefStore.setValue(PREFERENCE_PRINTER_CENTER_HORIZONTALLY, this.centerHorizontally);
        this.prefStore.setValue(PREFERENCE_PRINTER_CENTER_VERTICALLY, this.centerVertically);
        this.prefStore.setValue(PREFERENCE_PRINTER_ORIENTATION, this.printerData.orientation);
        this.prefStore.setValue(PREFERENCE_PRINTER_DUPLEX, this.printerData.duplex);
        this.prefStore.setValue(PREFERENCE_PRINTER_COLLATE, this.printerData.collate);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        if (!(scaleFactor > 0.0)) {
            throw new IllegalArgumentException("Scale factor out of range: " + scaleFactor + "less or equal zero.");
        }
        double oldFactor = this.scaleFactor;
        this.scaleFactor = scaleFactor;
        this.firePropertyChange(PROPERTY_SCALE_FACTOR, oldFactor, this.scaleFactor);
        this.firePropertyChange(PROPERTY_SCALE_PERCENT, (int)(oldFactor * 100.0), (int)(this.scaleFactor * 100.0));
        this.resetCenteringOffset();
    }

    public int getScalePercent() {
        return (int)(this.scaleFactor * 100.0);
    }

    public void setScalePercent(int scalePercent) {
        if (scalePercent <= 0) {
            throw new IllegalArgumentException("Scale percent out of range: " + scalePercent + "less or equal 0.");
        }
        double oldFactor = this.scaleFactor;
        this.scaleFactor = (double)scalePercent / 100.0;
        this.firePropertyChange(PROPERTY_SCALE_FACTOR, oldFactor, this.scaleFactor);
        this.firePropertyChange(PROPERTY_SCALE_PERCENT, (int)(oldFactor * 100.0), (int)(this.scaleFactor * 100.0));
        this.resetCenteringOffset();
    }

    public int getPagesWide() {
        return this.pagesWide;
    }

    public void setPagesWide(int pagesWide) {
        if (pagesWide <= 0) {
            throw new IllegalArgumentException("Pages wide out of range: " + pagesWide + "less or equal 0.");
        }
        int oldPagesWide = this.pagesWide;
        this.pagesWide = pagesWide;
        this.firePropertyChange(PROPERTY_PAGES_WIDE, oldPagesWide, this.pagesWide);
        this.resetCenteringOffset();
    }

    public int getPagesTall() {
        return this.pagesTall;
    }

    public void setPagesTall(int pagesTall) {
        if (pagesTall <= 0) {
            throw new IllegalArgumentException("Pages tall out of range: " + pagesTall + "less or equal 0.");
        }
        int oldPagesTall = this.pagesTall;
        this.pagesTall = pagesTall;
        this.firePropertyChange(PROPERTY_PAGES_TALL, oldPagesTall, this.pagesTall);
        this.resetCenteringOffset();
    }

    public boolean isAllPages() {
        return this.printerData.scope == 0;
    }

    public void setAllPages(boolean allPages) {
        boolean oldAll = this.printerData.scope == 0;
        this.printerData.scope = allPages ? 0 : 1;
        this.firePropertyChange(PROPERTY_ALL_PAGES, oldAll, this.printerData.scope == 0);
        this.disposePrinter();
    }

    public int getRangeFrom() {
        return this.printerData.startPage;
    }

    public void setRangeFrom(int rangeFrom) {
        int oldFrom = this.printerData.startPage;
        this.printerData.startPage = rangeFrom;
        this.firePropertyChange(PROPERTY_RANGE_FROM, oldFrom, rangeFrom);
        this.disposePrinter();
    }

    public int getRangeTo() {
        return this.printerData.endPage;
    }

    public void setRangeTo(int rangeTo) {
        int oldTo = this.printerData.endPage;
        this.printerData.endPage = rangeTo;
        this.firePropertyChange(PROPERTY_RANGE_TO, oldTo, rangeTo);
        this.disposePrinter();
    }

    public int getCopies() {
        return this.printerData.copyCount;
    }

    public void setCopies(int copies) {
        int oldCopies = this.printerData.copyCount;
        this.printerData.copyCount = copies;
        this.firePropertyChange(PROPERTY_COPIES, oldCopies, copies);
        this.disposePrinter();
    }

    public boolean isCollate() {
        return this.printerData.collate;
    }

    public void setCollate(boolean collate) {
        boolean oldCollate = this.printerData.collate;
        this.printerData.collate = collate;
        this.firePropertyChange(PROPERTY_COLLATE, oldCollate, collate);
        this.disposePrinter();
    }

    public int getDuplex() {
        return this.printerData.duplex;
    }

    public void setDuplex(int duplex) {
        int oldDuplex = this.printerData.duplex;
        this.printerData.duplex = duplex;
        this.firePropertyChange(PROPERTY_DUPLEX, oldDuplex, this.printerData.duplex);
        this.disposePrinter();
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public void setPrinterData(PrinterData printerData) {
        PrinterData oldPrinterData = this.printerData;
        this.printerData = printerData;
        this.firePropertyChange(PROPERTY_PRINTER_DATA, oldPrinterData, printerData);
        this.firePropertyChange(PROPERTY_PRINTER_NAME, oldPrinterData.name, printerData.name);
        this.firePropertyChange(PROPERTY_COPIES, oldPrinterData.copyCount, printerData.copyCount);
        this.firePropertyChange(PROPERTY_COLLATE, oldPrinterData.collate, printerData.collate);
        this.firePropertyChange(PROPERTY_ALL_PAGES, oldPrinterData.scope == 0, printerData.scope == 0);
        this.firePropertyChange(PROPERTY_RANGE_FROM, oldPrinterData.startPage, printerData.startPage);
        this.firePropertyChange(PROPERTY_RANGE_TO, oldPrinterData.endPage, printerData.endPage);
        this.firePropertyChange(PROPERTY_DUPLEX, oldPrinterData.duplex, printerData.duplex);
        this.firePropertyChange(PROPERTY_ORIENTATION, oldPrinterData.orientation, printerData.orientation);
        this.disposePrinter();
        this.resetTrimData();
        this.resetCenteringOffset();
    }

    public int getOrientation() {
        return this.printerData.orientation;
    }

    public void setOrientation(int orientation) {
        int oldOrientation = this.printerData.orientation;
        this.printerData.orientation = orientation;
        this.firePropertyChange(PROPERTY_ORIENTATION, oldOrientation, this.printerData.orientation);
        this.disposePrinter();
        this.resetTrimData();
        this.resetCenteringOffset();
    }

    public boolean getHorizontallyCentered() {
        return this.centerHorizontally;
    }

    public void setHorizontallyCentered(boolean horCentered) {
        boolean oldHorCentered = this.centerHorizontally;
        this.centerHorizontally = horCentered;
        this.firePropertyChange(PROPERTY_CENTER_HORIZONTALLY, oldHorCentered, this.centerHorizontally);
        this.resetCenteringOffset();
    }

    public boolean getVerticallyCentered() {
        return this.centerVertically;
    }

    public void setVerticallyCentered(boolean verCentered) {
        boolean oldVerCentered = this.centerVertically;
        this.centerVertically = verCentered;
        this.firePropertyChange(PROPERTY_CENTER_VERTICALLY, oldVerCentered, this.centerVertically);
        this.resetCenteringOffset();
    }

    public String getPrinterName() {
        return this.printerData.name;
    }

    private void disposePrinter() {
        if (this.printer != null) {
            this.printer.dispose();
        }
        this.printer = null;
        this.printerBounds = null;
        this.printerTrim = null;
    }

    public Printer getPrinter() {
        if (this.printer != null) {
            return this.printer;
        }
        if (this.printerData != null) {
            if (Strings.isNullOrEmpty((String)this.printerData.driver)) {
                this.printerData.driver = null;
            }
            try {
                this.printer = new Printer(this.printerData);
            }
            catch (SWTError e) {
                this.disposePrinter();
                this.printerData.driver = null;
                this.printerData.name = null;
                this.printer = new Printer(this.printerData);
            }
            return this.printer;
        }
        return null;
    }

    public Dimension getPrinterBounds() {
        if (this.printerBounds != null) {
            return this.printerBounds;
        }
        Printer p = this.getPrinter();
        if (p != null) {
            Rectangle pageArea = this.printer.getClientArea();
            this.printerBounds = new Dimension(pageArea.width, pageArea.height);
            return this.printerBounds;
        }
        return null;
    }

    public IExportBranding.Trim getPrinterTrim() {
        if (this.printerTrim != null) {
            return this.printerTrim;
        }
        Printer p = this.getPrinter();
        if (p != null) {
            Rectangle trim = p.computeTrim(0, 0, 0, 0);
            this.printerTrim = new IExportBranding.Trim((float)(-trim.x), (float)(trim.x + trim.width), (float)(-trim.y), (float)(trim.y + trim.height));
            return this.printerTrim;
        }
        return null;
    }

    public java.awt.Point getPrinterDPI() {
        Printer p = this.getPrinter();
        if (p != null) {
            Point dpi = p.getDPI();
            return new java.awt.Point(dpi.x, dpi.y);
        }
        return null;
    }

    protected void resetTrimData() {
    }

    private void resetCenteringOffset() {
        this.centeringOffset = null;
    }

    public Point2D getCenteringOffset() {
        return this.getCenteringOffset(1.0);
    }

    public Point2D getCenteringOffset(double scale) {
        if (this.centeringOffset == null) {
            this.centeringOffset = this.updateCenteringOffset();
        }
        if (this.centeringOffset == null) {
            return new Point2D.Double();
        }
        return new Point2D.Double(this.centerHorizontally ? this.centeringOffset.getX() * scale : 0.0, this.centerVertically ? this.centeringOffset.getY() * scale : 0.0);
    }

    protected Point2D updateCenteringOffset() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return this.propertyChangeSupport.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public static abstract class Initializer
    extends AbstractPreferenceInitializer {
        protected abstract IPreferenceStore getPreferenceStore();

        public void initializeDefaultPreferences() {
            IPreferenceStore prefStore = this.getPreferenceStore();
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_SCALE, 1.0f);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_PAGES_TALL, 1);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_PAGES_WIDE, 1);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_SCOPE, 0);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_PAGES_START, 1);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_PAGES_END, 1);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_CENTER_HORIZONTALLY, false);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_CENTER_VERTICALLY, false);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_ORIENTATION, 1);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_DUPLEX, 0);
            prefStore.setDefault(PrintOptions.PREFERENCE_PRINTER_COLLATE, false);
        }
    }
}

