/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing;

import de.cau.cs.kieler.klighd.DiagramExportConfig;
import de.cau.cs.kieler.klighd.IExportBranding;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.piccolo.KlighdSWTGraphics;
import de.cau.cs.kieler.klighd.piccolo.export.AbstractDiagramExporter;
import de.cau.cs.kieler.klighd.piccolo.internal.KlighdSWTGraphicsEx;
import de.cau.cs.kieler.klighd.piccolo.internal.KlighdSWTGraphicsImpl;
import de.cau.cs.kieler.klighd.piccolo.internal.util.KlighdPaintContext;
import de.cau.cs.kieler.klighd.piccolo.viewer.PiccoloViewer;
import de.cau.cs.kieler.klighd.ui.printing.PrintOptions;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.Printer;

public final class PrintExporter
extends AbstractDiagramExporter {
    private final PiccoloViewer viewer;
    private final Iterable<IExportBranding> exportBrandings;
    private PBounds diagramBounds = null;
    private IExportBranding.Trim diagramTrim = null;
    private IExportBranding.Trim diagramTileTrim = null;

    public PrintExporter(PiccoloViewer viewer) {
        this.viewer = viewer;
        this.exportBrandings = KlighdDataManager.getInstance().getExportBrandingByFormat("printout", viewer.getViewContext());
    }

    private PBounds getExportedBounds() {
        if (this.diagramBounds == null) {
            this.diagramBounds = this.getExportedBounds(this.viewer.getControl().getCamera(), false);
        }
        return new PBounds(this.diagramBounds);
    }

    public IExportBranding.Trim getDiagramTrim() {
        if (this.diagramTrim == null) {
            this.diagramTrim = this.getMaximumDiagramTrim(this.exportBrandings, (Rectangle2D)this.getExportedBounds());
        }
        return this.diagramTrim;
    }

    public IExportBranding.Trim getDiagramTileTrim(Dimension tileBounds, IExportBranding.Trim printerTrim, Point dotsPerInch) {
        if (this.diagramTileTrim == null) {
            this.diagramTileTrim = this.getMaximumDiagramTileTrim(this.exportBrandings, new Rectangle(tileBounds), printerTrim, dotsPerInch);
        }
        return this.diagramTileTrim;
    }

    void resetTrimInformation() {
        this.diagramTrim = null;
        this.diagramTileTrim = null;
    }

    public Dimension2D getTrimmedTileBounds(PrintOptions options) {
        if (options == null || options.getPrinter() == null) {
            return new PDimension();
        }
        Dimension tileBounds = options.getPrinterBounds();
        IExportBranding.Trim tileTrim = this.getDiagramTileTrim(tileBounds, options.getPrinterTrim(), options.getPrinterDPI());
        return new PDimension((double)((float)tileBounds.width - tileTrim.getWidth()), (double)((float)tileBounds.height - tileTrim.getHeight()));
    }

    public PDimension getDiagramBoundsIncludingTrim() {
        PBounds exportedBounds = this.getExportedBounds();
        IExportBranding.Trim trim = this.getDiagramTrim();
        if (trim != null) {
            exportedBounds.width += (double)trim.getWidth();
            exportedBounds.height += (double)trim.getHeight();
        }
        return (PDimension)exportedBounds.getSize();
    }

    protected KlighdPaintContext createPaintContext(KlighdSWTGraphics graphics, DiagramExportConfig exportConfig) {
        return KlighdPaintContext.createPrintoutPaintContext((KlighdSWTGraphics)graphics, (boolean)exportConfig.applyCameraZoomLevel);
    }

    public DiagramExportConfig createExportConfig(PrintOptions options) {
        if (options == null || options.getPrinter() == null) {
            return null;
        }
        Dimension pageBounds = options.getPrinterBounds();
        IExportBranding.Trim printerTrim = options.getPrinterTrim();
        Point dpi = options.getPrinterDPI();
        int pages = options.getPagesTall() * options.getPagesWide();
        return new DiagramExportConfig(this.viewer.getViewContext(), (Rectangle2D)this.getExportedBounds(), pageBounds, options.getScaleFactor(), dpi, printerTrim, pages).setBrandingsAndTrim(this.exportBrandings, this.getDiagramTrim(), this.getDiagramTileTrim(pageBounds, printerTrim, dpi));
    }

    public Rectangle getBasicPageClip(Dimension drawablesBounds, IExportBranding.Trim tileTrimScaled) {
        return super.getBasicTileClip(drawablesBounds, tileTrimScaled);
    }

    public Image exportPreview(DiagramExportConfig exportConfig, Printer printer, Dimension imageBounds, Rectangle imageClip, double previewScale, Point2D centeringOffset) {
        Image image = new Image((Device)this.viewer.getControl().getDisplay(), imageBounds.width, imageBounds.height);
        this.export(exportConfig, (Drawable)image, (Device)printer, imageBounds, imageClip, previewScale, centeringOffset);
        return image;
    }

    public void print(DiagramExportConfig exportConfig, Printer printer, Dimension pageBounds, Rectangle pageClip, Point2D centeringOffset) {
        this.export(exportConfig, (Drawable)printer, (Device)printer, pageBounds, pageClip, 1.0, centeringOffset);
    }

    private void export(DiagramExportConfig exportConfig, Drawable drawable, Device fontDevice, Dimension drawablesBounds, Rectangle baseTileClip, double imageScale, Point2D centeringOffset) {
        GC gc = new GC(drawable);
        KlighdSWTGraphicsImpl graphics = new KlighdSWTGraphicsImpl(gc, fontDevice);
        this.drawDiagramTile(exportConfig, (KlighdSWTGraphicsEx)graphics, this.viewer.getControl().getCamera(), drawablesBounds, baseTileClip, imageScale, centeringOffset);
        graphics.dispose();
        gc.dispose();
    }
}

