/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing;

import de.cau.cs.kieler.klighd.DiagramExportConfig;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.piccolo.viewer.PiccoloViewer;
import de.cau.cs.kieler.klighd.ui.printing.DiagramPrintOptions;
import de.cau.cs.kieler.klighd.ui.printing.KlighdUIPrintingMessages;
import de.cau.cs.kieler.klighd.ui.printing.PrintExporter;
import de.cau.cs.kieler.klighd.ui.printing.PrintOptions;
import de.cau.cs.kieler.klighd.ui.printing.dialog.KlighdPrintDialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;

public class PrintAction
extends Action {
    private IViewer iViewer;
    private PiccoloViewer pViewer;

    public PrintAction() {
    }

    public PrintAction(IViewer viewer) {
        this.setViewer(viewer);
    }

    public void setViewer(IViewer viewer) {
        this.iViewer = viewer;
        this.pViewer = null;
    }

    private PiccoloViewer getViewer() {
        if (this.pViewer != null && !this.pViewer.getControl().isDisposed()) {
            return this.pViewer;
        }
        if (this.iViewer instanceof PiccoloViewer) {
            this.pViewer = (PiccoloViewer)this.iViewer;
        } else {
            IViewer aViewer = this.iViewer.getContextViewer().getActiveViewer();
            if (aViewer instanceof PiccoloViewer) {
                this.pViewer = (PiccoloViewer)aViewer;
            } else {
                String msg = "KLighD PrintAction: provided IViewer must be/contain an instance of PiccoloViewer!";
                throw new IllegalArgumentException("KLighD PrintAction: provided IViewer must be/contain an instance of PiccoloViewer!");
            }
        }
        return this.pViewer;
    }

    protected KlighdPrintDialog getPrintDialog(Shell parentShell, PrintOptions options) {
        return new KlighdPrintDialog(parentShell, options);
    }

    public final void run() {
        PiccoloViewer viewer = this.getViewer();
        if (viewer == null) {
            throw new IllegalStateException("KLighD PrintAction: The required viewer is not set!");
        }
        PrintExporter exporter = new PrintExporter(viewer);
        DiagramPrintOptions options = new DiagramPrintOptions(exporter);
        KlighdPrintDialog dlg = this.getPrintDialog(viewer.getControl().getShell(), options);
        if (dlg.open() != 0) {
            return;
        }
        Printer printer = options.getPrinter();
        if (printer == null) {
            return;
        }
        PrinterData printerData = printer.getPrinterData();
        printer.startJob(KlighdUIPrintingMessages.PrintAction_JobName);
        Dimension pageBounds = options.getPrinterBounds();
        int rows = options.getPagesTall();
        int columns = options.getPagesWide();
        DiagramExportConfig config = exporter.createExportConfig(options);
        Rectangle pageClip = exporter.getBasicPageClip(pageBounds, config.tileTrim);
        Point2D centeringOffset = options.getCenteringOffset();
        int pageNo = 0;
        int row = 0;
        block0: while (row != rows) {
            int column = 0;
            while (column != columns) {
                boolean pageEnabled;
                boolean bl = pageEnabled = printerData.scope == 0 || printerData.scope == 1 && printerData.startPage <= ++pageNo && printerData.endPage >= pageNo;
                if (pageEnabled) {
                    if (!printer.startPage()) break block0;
                    config.setPageAndTileNumbers(pageNo, row, column, rows, columns);
                    exporter.print(config, printer, pageBounds, pageClip, centeringOffset);
                    printer.endPage();
                }
                ++column;
            }
            ++row;
        }
        printer.endJob();
        printer.dispose();
    }
}

