/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.printing;

import de.cau.cs.kieler.klighd.ui.KlighdUIPlugin;
import de.cau.cs.kieler.klighd.ui.printing.PrintExporter;
import de.cau.cs.kieler.klighd.ui.printing.PrintOptions;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import org.eclipse.jface.preference.IPreferenceStore;

public class DiagramPrintOptions
extends PrintOptions {
    private static final IPreferenceStore PREF_STORE = KlighdUIPlugin.getDefault().getPreferenceStore();
    private static final String PREFERENCE_INITIALLY_SHOW_PREVIEW = "klighd.printing.initiallyShowPreview";
    private static final String PREFERENCE_AUTO_SCALE_TO_FIT = "klighd.printing.autoScaleToFit";
    private static final String PREFERENCE_AUTO_SCALE_TO_100 = "klighd.printing.autoScaleTo100";
    private PrintExporter exporter;
    private Dimension2D diagramBounds = null;

    public static boolean getInitiallyShowPreview() {
        return PREF_STORE.getBoolean(PREFERENCE_INITIALLY_SHOW_PREVIEW);
    }

    public static void setInitiallyShowPreview(boolean initiallyShow) {
        PREF_STORE.setValue(PREFERENCE_INITIALLY_SHOW_PREVIEW, initiallyShow);
    }

    public static boolean getAutoScaleToFit() {
        return PREF_STORE.getBoolean(PREFERENCE_AUTO_SCALE_TO_FIT);
    }

    public static void setAutoScaleToFit(boolean autoScale) {
        if (autoScale) {
            PREF_STORE.setValue(PREFERENCE_AUTO_SCALE_TO_100, false);
        }
        PREF_STORE.setValue(PREFERENCE_AUTO_SCALE_TO_FIT, autoScale);
    }

    public static boolean getAutoScaleTo100() {
        return PREF_STORE.getBoolean(PREFERENCE_AUTO_SCALE_TO_100);
    }

    public static void setAutoScaleTo100(boolean autoScale) {
        if (autoScale) {
            PREF_STORE.setValue(PREFERENCE_AUTO_SCALE_TO_FIT, false);
        }
        PREF_STORE.setValue(PREFERENCE_AUTO_SCALE_TO_100, autoScale);
    }

    public DiagramPrintOptions(PrintExporter printExporter) {
        super(PREF_STORE);
        this.exporter = printExporter;
    }

    public PrintExporter getExporter() {
        return this.exporter;
    }

    @Override
    protected void resetTrimData() {
        if (this.exporter != null) {
            this.exporter.resetTrimInformation();
        }
    }

    @Override
    protected Point2D updateCenteringOffset() {
        if (!this.getHorizontallyCentered() && !this.getVerticallyCentered()) {
            return new Point2D.Double();
        }
        Dimension2D pBounds = this.exporter.getTrimmedTileBounds(this);
        if (pBounds == null) {
            return null;
        }
        if (this.diagramBounds == null) {
            if (this.exporter == null) {
                return null;
            }
            this.diagramBounds = this.exporter.getDiagramBoundsIncludingTrim();
        }
        return new Point2D.Double((pBounds.getWidth() * (double)this.getPagesWide() - this.diagramBounds.getWidth() * this.getScaleFactor()) / 2.0, (pBounds.getHeight() * (double)this.getPagesTall() - this.diagramBounds.getHeight() * this.getScaleFactor()) / 2.0);
    }

    public static class Initializer
    extends PrintOptions.Initializer {
        @Override
        protected IPreferenceStore getPreferenceStore() {
            return PREF_STORE;
        }

        @Override
        public void initializeDefaultPreferences() {
            super.initializeDefaultPreferences();
            PREF_STORE.setDefault(DiagramPrintOptions.PREFERENCE_INITIALLY_SHOW_PREVIEW, false);
            PREF_STORE.setDefault(DiagramPrintOptions.PREFERENCE_AUTO_SCALE_TO_100, false);
            PREF_STORE.setDefault(DiagramPrintOptions.PREFERENCE_AUTO_SCALE_TO_FIT, false);
        }
    }
}

