/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.parts;

import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.KlighdPreferences;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.LightDiagramServices;
import de.cau.cs.kieler.klighd.ViewContext;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class DiagramWorkbenchParts {
    private DiagramWorkbenchParts() {
    }

    public static DiagramAreaChangeListener createDiagramAreaChangeListener(IDiagramWorkbenchPart dwb) {
        return new DiagramAreaChangeListener(dwb);
    }

    public static class DiagramAreaChangeListener
    extends ControlAdapter {
        private static final double ASPECT_RATIO_ROUND = 100.0;
        private double oldAspectRatio = -1.0;
        private boolean isScheduled = false;
        private final IDiagramWorkbenchPart diagramWorkbenchPart;

        public DiagramAreaChangeListener(IDiagramWorkbenchPart dwb) {
            this.diagramWorkbenchPart = dwb;
        }

        public void controlResized(ControlEvent e) {
            ViewContext context = this.diagramWorkbenchPart.getViewContext();
            if (KlighdPreferences.isZoomOnWorkbenchpartChange() && context != null) {
                Control control = context.getViewer().getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                if (this.isScheduled) {
                    return;
                }
                this.isScheduled = true;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IViewer viewer = diagramWorkbenchPart.getViewer();
                        Control control = viewer.getControl();
                        isScheduled = false;
                        if (!control.isDisposed() && control.isVisible()) {
                            this.zoomOrRelayout(viewer);
                        }
                    }
                });
            }
        }

        private void zoomOrRelayout(IViewer viewer) {
            Point size = viewer.getControl().getSize();
            if (size.x > 0 && size.y > 0) {
                double aspectRatio = (double)Math.round(100.0 * (double)size.x / (double)size.y) / 100.0;
                if (this.oldAspectRatio == -1.0 || this.oldAspectRatio > 1.0 && aspectRatio < 1.0 || this.oldAspectRatio < 1.0 && aspectRatio > 1.0) {
                    new LightDiagramLayoutConfig(this.diagramWorkbenchPart).performLayout();
                    this.oldAspectRatio = aspectRatio;
                } else {
                    LightDiagramServices.zoomDiagram((IDiagramWorkbenchPart)this.diagramWorkbenchPart);
                }
            }
        }
    }
}

