/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.parts;

import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.internal.ILayoutConfigProvider;
import de.cau.cs.kieler.klighd.ui.DiagramViewManager;
import de.cau.cs.kieler.klighd.ui.KlighdUIPlugin;
import de.cau.cs.kieler.klighd.ui.internal.options.DiagramSideBar;
import de.cau.cs.kieler.klighd.ui.parts.DiagramEditorPart;
import de.cau.cs.kieler.klighd.ui.parts.DiagramWorkbenchParts;
import de.cau.cs.kieler.klighd.ui.printing.PrintAction;
import de.cau.cs.kieler.klighd.ui.viewers.UiContextViewer;
import de.cau.cs.kieler.klighd.util.KlighdSynthesisProperties;
import de.cau.cs.kieler.klighd.viewers.ContextViewer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class DiagramViewPart
extends ViewPart
implements IDiagramWorkbenchPart,
ILayoutConfigProvider {
    public static final String VIEW_ID = "de.cau.cs.kieler.klighd.ui.parts.DiagramViewPart";
    public static final String ACTION_ID_RESET_LAYOUT_OPTIONS = "de.cau.cs.kieler.klighd.ui.parts.DiagramViewPart.resetLayoutOptions";
    public static final String DEFAULT_NAME = "KLighD Diagram";
    private ContextViewer viewer;
    private boolean disposed = false;
    private IAction resetLayoutOptionsAction;
    private DiagramSideBar sideBar;
    private Composite diagramComposite;
    private DropTarget dropTarget;
    private final ControlListener diagramAreaListener = DiagramWorkbenchParts.createDiagramAreaChangeListener(this);

    public void createPartControl(Composite parent) {
        this.createDiagramViewer(parent);
    }

    protected Composite createDiagramViewer(Composite parent) {
        this.diagramComposite = new Composite(parent, 0);
        this.diagramComposite.setVisible(false);
        this.diagramComposite.setLayout((Layout)new FillLayout());
        this.viewer = new UiContextViewer(this.diagramComposite, this);
        this.addButtons();
        this.fillViewMenu(this.getViewSite().getActionBars().getMenuManager());
        this.registerPrintSupport();
        this.installDropHandler(parent);
        this.viewer.setModel((Object)"No model selected.", false);
        this.diagramComposite.addControlListener(this.diagramAreaListener);
        return this.diagramComposite;
    }

    public void initialize(Object model, String name, IPropertyHolder properties) {
        if (name != null) {
            this.setName(name);
        }
        ViewContext viewContext = new ViewContext((IDiagramWorkbenchPart)this, model);
        if (properties != null) {
            viewContext.configure(properties);
        } else {
            viewContext.configure();
        }
        DiagramViewManager.getInstance().registerView(this);
        if (this.sideBar == null) {
            this.sideBar = DiagramSideBar.createSideBar(this.diagramComposite.getParent(), this.diagramComposite, viewContext);
        }
        this.viewer.setModel((Object)viewContext);
        viewContext.getLayoutRecorder().startRecording();
        viewContext.update();
        this.updateOptions(false);
        this.getViewSite().getPage().bringToTop((IWorkbenchPart)this);
        new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(false)).performLayout();
        this.diagramComposite.setVisible(true);
    }

    public ViewContext getViewContext() {
        return this.viewer.getViewContext();
    }

    public LayoutConfigurator getLayoutConfig() {
        return this.sideBar != null ? this.sideBar.getLayoutConfig() : null;
    }

    public void resetLayoutConfig() {
        this.resetLayoutConfig(true);
    }

    public void resetLayoutConfig(boolean doLayout) {
        if (this.sideBar != null) {
            this.sideBar.resetLayoutOptionsToDefaults(doLayout);
        }
    }

    public void dispose() {
        DiagramViewManager.getInstance().unregisterView(this);
        if (!this.diagramComposite.isDisposed()) {
            this.diagramComposite.removeControlListener(this.diagramAreaListener);
        }
        if (this.sideBar != null) {
            this.sideBar.dispose();
        }
        this.sideBar = null;
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.dispose();
        }
        IViewSite viewSite = this.getViewSite();
        viewSite.setSelectionProvider(null);
        viewSite.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), null);
        this.viewer = null;
        this.disposed = true;
        super.dispose();
    }

    public void updateOptions(boolean fitSpace) {
        this.sideBar.updateOptions(this.diagramComposite, this.viewer.getViewContext(), fitSpace);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void fillViewMenu(IMenuManager menuManager) {
    }

    protected void addButtons() {
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)new Action("Refresh diagram", KlighdUIPlugin.getImageDescriptorFromKlighdBase("icons/full/elcl16/refresh.gif")){
            final DiagramViewPart part;
            {
                this.part = DiagramViewPart.this;
            }

            public void run() {
                if (this.part.getViewContext() == null) {
                    Object model = this.part.loadModel();
                    if (model != null) {
                        this.part.initialize(model, DiagramViewPart.DEFAULT_NAME, (IPropertyHolder)DiagramViewPart.this.configureKlighdProperties());
                    }
                    return;
                }
                new LightDiagramLayoutConfig(DiagramViewPart.this.getViewContext()).model(this.part.loadModel()).animate(Boolean.valueOf(false)).performUpdate();
            }
        });
        toolBar.add((IAction)new Action("Arrange", KlighdUIPlugin.getImageDescriptor("icons/menu16/arrange.gif")){

            public void run() {
                new LightDiagramLayoutConfig((IDiagramWorkbenchPart)DiagramViewPart.this).performLayout();
            }
        });
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        this.resetLayoutOptionsAction = new Action("Reset Layout Options"){

            public void run() {
                DiagramViewPart.this.sideBar.resetLayoutOptionsToDefaults(true);
            }
        };
        this.resetLayoutOptionsAction.setId(ACTION_ID_RESET_LAYOUT_OPTIONS);
        menu.add(this.resetLayoutOptionsAction);
    }

    protected Object loadModel() {
        try {
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = page = window.getActivePage() != null ? window.getActivePage() : window.getPages()[0];
            IEditorInput input = page == null ? null : (page.getActiveEditor() != null ? page.getActiveEditor().getEditorInput() : (page.getEditorReferences().length == 0 ? null : page.getEditorReferences()[0].getEditorInput()));
            return input == null ? null : DiagramEditorPart.loadModel(input);
        }
        catch (PartInitException e) {
            Klighd.handle((CoreException)e, (String)"de.cau.cs.kieler.klighd.ui");
            return null;
        }
    }

    protected KlighdSynthesisProperties configureKlighdProperties() {
        return null;
    }

    protected void registerPrintSupport() {
        IActionBars actions = this.getViewSite().getActionBars();
        if (actions != null) {
            actions.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new PrintAction(this.getViewer()));
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public String getPartId() {
        return this.getViewSite().getSecondaryId();
    }

    public IViewer getViewer() {
        return this.viewer;
    }

    public IAction getAction(String id) {
        if (id.equals(ACTION_ID_RESET_LAYOUT_OPTIONS)) {
            return this.resetLayoutOptionsAction;
        }
        return null;
    }

    public void setName(String name) {
        this.setPartName(name);
    }

    private void installDropHandler(Composite parent) {
        DropTarget target;
        this.dropTarget = target = new DropTarget((Control)parent, 17);
        final ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
        target.setTransfer(new Transfer[]{resourceTransfer});
        target.addDropListener(new DropTargetListener(){

            public void drop(DropTargetEvent event) {
                if (resourceTransfer.isSupportedType(event.currentDataType) && event.data instanceof IResource[]) {
                    IResource[] resources = (IResource[])event.data;
                    int cfr_ignored_0 = resources.length;
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }
        });
    }
}

