/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.parts;

import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.internal.IDiagramOutlinePage;
import de.cau.cs.kieler.klighd.internal.ILayoutConfigProvider;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.SimpleUpdateStrategy;
import de.cau.cs.kieler.klighd.ui.internal.options.DiagramSideBar;
import de.cau.cs.kieler.klighd.ui.parts.DiagramWorkbenchParts;
import de.cau.cs.kieler.klighd.ui.printing.PrintAction;
import de.cau.cs.kieler.klighd.ui.viewers.UiContextViewer;
import de.cau.cs.kieler.klighd.util.KlighdSynthesisProperties;
import de.cau.cs.kieler.klighd.viewers.ContextViewer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DiagramEditorPart
extends EditorPart
implements IDiagramWorkbenchPart.IDiagramEditorPart,
ILayoutConfigProvider {
    private ResourceSet resourceSet;
    private Object model;
    private ContextViewer viewer;
    private boolean dirty;
    private Composite diagramComposite;
    private final ControlListener diagramAreaListener = DiagramWorkbenchParts.createDiagramAreaChangeListener((IDiagramWorkbenchPart)this);
    private DiagramSideBar sideBar;
    private IDiagramOutlinePage currentOutlinePage = null;
    private boolean toBeFocussed = false;
    private IResourceChangeListener resourceChangeListener;

    public DiagramEditorPart() {
        this(true);
    }

    protected DiagramEditorPart(boolean installResourceChangeListener) {
        if (installResourceChangeListener) {
            this.resourceChangeListener = new KlighdResourceChangeListener();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.loadModel();
        this.registerResourceChangeListener();
    }

    public void createPartControl(Composite parent) {
        this.setPartName(this.getEditorInput().getName());
        this.diagramComposite = new Composite(parent, 0);
        this.diagramComposite.setLayout((Layout)new FillLayout());
        this.viewer = new UiContextViewer(this.diagramComposite, (IDiagramWorkbenchPart)this);
        final ViewContext viewContext = new ViewContext((IDiagramWorkbenchPart)this, this.model).configure(this.configureKlighdProperties());
        this.sideBar = DiagramSideBar.createSideBar(parent, this.diagramComposite, viewContext);
        if (viewContext != null) {
            this.viewer.setModel((Object)viewContext);
            viewContext.update();
            if (this.requiresInitialLayout(viewContext)) {
                this.viewer.getControl().setVisible(false);
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DiagramEditorPart.this.viewer == null) {
                            return;
                        }
                        Control control = DiagramEditorPart.this.viewer.getControl();
                        if (control == null || control.isDisposed()) {
                            return;
                        }
                        new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(false)).zoomStyle(DiagramEditorPart.this.getInitialZoomStyle()).performLayout();
                        if (control.isDisposed()) {
                            return;
                        }
                        control.setVisible(true);
                        if (DiagramEditorPart.this.toBeFocussed) {
                            DiagramEditorPart.this.toBeFocussed = false;
                            control.setFocus();
                        }
                        if (DiagramEditorPart.this.currentOutlinePage != null) {
                            DiagramEditorPart.this.currentOutlinePage.setVisible(true);
                        }
                    }
                });
            } else if (this.currentOutlinePage != null) {
                this.currentOutlinePage.setVisible(true);
            }
            this.sideBar.updateOptions(this.diagramComposite, viewContext, false);
            this.viewer.resetSelectionTo((KGraphElement)this.getViewer().getClip());
        } else {
            this.viewer.setModel((Object)"The selected file does not contain any supported model.", false);
        }
        this.diagramComposite.addControlListener(this.diagramAreaListener);
    }

    protected boolean requiresInitialLayout(ViewContext viewContext) {
        KNode viewModel = viewContext.getViewModel();
        return viewModel.getWidth() == 0.0f && viewModel.getHeight() == 0.0f;
    }

    protected ZoomStyle getInitialZoomStyle() {
        return ZoomStyle.NONE;
    }

    public LayoutConfigurator getLayoutConfig() {
        return this.sideBar != null ? this.sideBar.getLayoutConfig() : null;
    }

    public void resetLayoutConfig() {
        this.resetLayoutConfig(true);
    }

    public void resetLayoutConfig(boolean doLayout) {
        if (this.sideBar != null) {
            this.sideBar.resetLayoutOptionsToDefaults(doLayout);
        }
    }

    public void dispose() {
        this.unregisterResourceChangeListener();
        if (!this.diagramComposite.isDisposed()) {
            this.diagramComposite.removeControlListener(this.diagramAreaListener);
        }
        this.diagramComposite = null;
        if (this.sideBar != null) {
            this.sideBar.dispose();
        }
        this.sideBar = null;
        this.getSite().setSelectionProvider(null);
        this.viewer = null;
        this.currentOutlinePage = null;
        if (this.resourceSet != null) {
            for (Resource r : this.resourceSet.getResources()) {
                r.unload();
            }
            this.resourceSet = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class && this.viewer instanceof IDiagramOutlinePage.Provider) {
            this.currentOutlinePage = this.viewer.getDiagramOutlinePage();
            if (this.currentOutlinePage != null) {
                this.currentOutlinePage.setVisible(this.viewer.getControl().isVisible() || !this.requiresInitialLayout(this.viewer.getViewContext()));
                return this.currentOutlinePage;
            }
        }
        return super.getAdapter(type);
    }

    public String getPartId() {
        return "diagramEditor:" + this.getEditorInput().toString();
    }

    public IViewer getViewer() {
        return this.viewer;
    }

    public ViewContext getViewContext() {
        return this.viewer.getViewContext();
    }

    public void setFocus() {
        Control c = this.viewer.getControl();
        if (c.isVisible()) {
            c.setFocus();
        } else {
            this.toBeFocussed = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.unregisterResourceChangeListener();
            for (Resource resource : this.resourceSet.getResources()) {
                resource.save(Collections.emptyMap());
            }
            this.registerResourceChangeListener();
            this.setDirty(false);
        }
        catch (IOException exception) {
            throw new WrappedException((Throwable)exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    protected Object loadModel() throws PartInitException {
        EObject model = DiagramEditorPart.loadModel(this.getEditorInput());
        this.model = model;
        this.resourceSet = model.eResource().getResourceSet();
        this.configureResourceSet(this.resourceSet);
        return model;
    }

    protected static EObject loadModel(IEditorInput input) throws PartInitException {
        Resource resource;
        URI uri = null;
        InputStream inputStream = null;
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        } else if (input instanceof IURIEditorInput) {
            java.net.URI inputUri = ((IURIEditorInput)input).getURI();
            uri = URI.createURI((String)inputUri.toString());
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            uri = URI.createFileURI((String)path.toString());
        } else if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                inputStream = storage.getContents();
            }
            catch (CoreException exception) {
                throw new PartInitException("An error occurred while accessing the storage.", (Throwable)exception);
            }
        } else {
            throw new PartInitException("The given editor input is not supported.");
        }
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            if (inputStream != null) {
                uri = URI.createFileURI((String)"temp.xmi");
                resource = resourceSet.createResource(uri);
                resource.load(inputStream, Collections.EMPTY_MAP);
            } else {
                resource = resourceSet.getResource(uri, true);
            }
        }
        catch (IOException exception) {
            throw new PartInitException("An error occurred while loading the resource.", (Throwable)exception);
        }
        catch (WrappedException exception) {
            throw new PartInitException("An error occurred while loading the resource.", exception.getCause());
        }
        if (resource.getContents().isEmpty()) {
            throw new PartInitException("The resource is empty.");
        }
        return (EObject)resource.getContents().get(0);
    }

    protected Object getModel() {
        return this.model;
    }

    protected void setModel(Object model) {
        this.model = model;
    }

    protected void configureResourceSet(ResourceSet set) {
    }

    protected IPropertyHolder configureKlighdProperties() {
        MapPropertyHolder props = new MapPropertyHolder();
        props.setProperty(KlighdSynthesisProperties.REQUESTED_UPDATE_STRATEGY, (Object)SimpleUpdateStrategy.ID);
        return props;
    }

    private void registerResourceChangeListener() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        }
    }

    private void unregisterResourceChangeListener() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    private class KlighdResourceChangeListener
    implements IResourceChangeListener {
        private KlighdResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new DeltaVisitor());
            }
            catch (CoreException exception) {
                Klighd.handle((CoreException)exception, (String)"de.cau.cs.kieler.klighd.ui");
            }
        }

        private class DeltaVisitor
        implements IResourceDeltaVisitor {
            private DeltaVisitor() {
            }

            public boolean visit(IResourceDelta delta) {
                if (delta.getResource().getType() != 1) {
                    return true;
                }
                if (delta.getKind() == 2) {
                    this.update(delta.getFullPath().toString(), true);
                } else if (delta.getKind() == 4 && delta.getFlags() != 131072) {
                    this.update(delta.getFullPath().toString(), false);
                }
                return false;
            }

            private void update(String fullPath, final boolean remove) {
                final Resource resource = ((KlighdResourceChangeListener)KlighdResourceChangeListener.this).DiagramEditorPart.this.resourceSet.getResource(URI.createPlatformResourceURI((String)fullPath, (boolean)true), false);
                if (resource == null) {
                    return;
                }
                DiagramEditorPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (remove) {
                            DiagramEditorPart.this.getSite().getPage().closeEditor((IEditorPart)DiagramEditorPart.this, false);
                        } else {
                            DeltaVisitor.this.reloadModel(resource);
                        }
                    }
                });
            }

            private void reloadModel(Resource resource) {
                if (resource.isLoaded()) {
                    resource.unload();
                    try {
                        resource.load(Collections.EMPTY_MAP);
                        ((KlighdResourceChangeListener)KlighdResourceChangeListener.this).DiagramEditorPart.this.model = resource.getContents().get(0);
                        ((KlighdResourceChangeListener)KlighdResourceChangeListener.this).DiagramEditorPart.this.viewer.getViewContext().update(((KlighdResourceChangeListener)KlighdResourceChangeListener.this).DiagramEditorPart.this.model);
                    }
                    catch (IOException exception) {
                        String msg = String.valueOf(this.getClass().getSimpleName()) + " : Failed to reload " + resource.getURI().toString() + " after it has been changed.";
                        Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", msg, (Throwable)exception));
                    }
                }
            }
        }
    }

    public static class PrintActionContributor
    extends EditorActionBarContributor
    implements IPartListener {
        private final PrintAction action = new PrintAction();
        private IDiagramWorkbenchPart currentEditor;

        public void init(IActionBars bars) {
            super.init(bars);
            this.getPage().addPartListener((IPartListener)this);
            bars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.action);
            bars.updateActionBars();
        }

        public void dispose() {
            this.getPage().removePartListener((IPartListener)this);
            super.dispose();
        }

        public void setActiveEditor(IEditorPart targetEditor) {
            super.setActiveEditor(targetEditor);
            this.currentEditor = (IDiagramWorkbenchPart)targetEditor;
            this.action.setViewer(this.currentEditor.getViewer());
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == this.currentEditor) {
                this.currentEditor = null;
                this.action.setViewer(null);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    }
}

