/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.modifymodel;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.IModelModificationHandler;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.ui.IWorkbenchPart;

public final class ModelModificationHandlerProvider {
    private static ModelModificationHandlerProvider instance = new ModelModificationHandlerProvider();
    private List<IModelModificationHandler> handlers = null;

    private ModelModificationHandlerProvider() {
    }

    public IModelModificationHandler getFittingHandler(IWorkbenchPart part) {
        if (this.handlers == null) {
            this.readHandlerExtensionPoint();
        }
        for (IModelModificationHandler handler : this.handlers) {
            if (!handler.canHandle(part)) continue;
            return handler;
        }
        return null;
    }

    private void readHandlerExtensionPoint() {
        IConfigurationElement[] elements;
        this.handlers = Lists.newLinkedList();
        IConfigurationElement[] iConfigurationElementArray = elements = RegistryFactory.getRegistry().getConfigurationElementsFor("de.cau.cs.kieler.klighd.extensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("handler")) {
                try {
                    IModelModificationHandler handler = (IModelModificationHandler)element.createExecutableExtension("class");
                    this.handlers.add(handler);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static ModelModificationHandlerProvider getInstance() {
        return instance;
    }
}

