/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.preferences;

import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.ui.internal.Messages;
import de.cau.cs.kieler.klighd.ui.internal.preferences.KlighdPlatformPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class KlighdPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button animationCheckBox;
    private Button advancedPanning;
    private Button expandSideBar;
    private Button showZoomConfigButtons;
    private static final String ADVANCED_PANNING_TOOLTIP = "If enabled diagram panning continues when mouse pointer leaves the diagram area and stops, until it returns to diagram area or the mouse button is released.";
    private static final String EXPAND_SIDE_BAR_TOOLTIP = "Diagram side bars accommodate the controls for diagram options and layout options. If deactivated the side bars must be expanded manually.";
    private static final String SHOW_ZOOM_CONFIG_BUTTONS_TOOLTIP = "Zoom buttons are used to change the zooming behavior. If deactivated the zoom buttons are not visible.";
    private Button zoomOnWorkbenchpartChange;
    private Button zoomToFit;
    private Button zoomToFocus;
    private Button zoomNone;
    private Button magLensEnabled;
    private Spinner magLensWidth;
    private Spinner magLensHeight;
    private Spinner magLensScale;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(KlighdPlatformPreferenceStore.INSTANCE.delegate);
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.animateLayout", this.animationCheckBox.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.advancedPanning", this.advancedPanning.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.expandSideBar", this.expandSideBar.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.showZoomConfigButtons", this.showZoomConfigButtons.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.zoomOnWorkBenchPartChange", this.zoomOnWorkbenchpartChange.getSelection());
        ZoomStyle zoomStyle = this.getZoomStyleFromSelection();
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.zoomStyle", zoomStyle.name());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.magnificationLensEnabled", this.magLensEnabled.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.magnificationLensWidth", this.magLensWidth.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.magnificationLensHeight", this.magLensHeight.getSelection());
        preferenceStore.setValue("de.cau.cs.kieler.klighd.preferences.magnificationLensScale", this.magLensScale.getSelection());
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.animationCheckBox.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.klighd.preferences.animateLayout"));
        this.advancedPanning.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.klighd.preferences.advancedPanning"));
        this.expandSideBar.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.klighd.preferences.expandSideBar"));
        this.showZoomConfigButtons.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.klighd.preferences.showZoomConfigButtons"));
        this.zoomOnWorkbenchpartChange.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.klighd.preferences.zoomOnWorkBenchPartChange"));
        this.setZoomStyleSelection(ZoomStyle.valueOf((String)preferenceStore.getDefaultString("de.cau.cs.kieler.klighd.preferences.zoomStyle")));
        this.magLensEnabled.setSelection(preferenceStore.getDefaultBoolean("de.cau.cs.kieler.klighd.preferences.magnificationLensEnabled"));
        this.magLensWidth.setSelection(preferenceStore.getDefaultInt("de.cau.cs.kieler.klighd.preferences.magnificationLensWidth"));
        this.magLensHeight.setSelection(preferenceStore.getDefaultInt("de.cau.cs.kieler.klighd.preferences.magnificationLensHeight"));
        this.magLensScale.setSelection(preferenceStore.getDefaultInt("de.cau.cs.kieler.klighd.preferences.magnificationLensScale"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 10;
        composite.setLayout((Layout)compositeLayout);
        Group generalGroup = this.createGeneralGroup(composite);
        generalGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Group zoomGroup = this.createZoomToFitGroup(composite);
        zoomGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Group magnificationLensGroup = this.createMagnificationLensGroup(composite);
        magnificationLensGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    private Group createGeneralGroup(Composite parent) {
        Group generalGroup = new Group(parent, 0);
        generalGroup.setText(Messages.KlighdPreferencePage_generalOptions);
        generalGroup.setLayout((Layout)new RowLayout(512));
        ((RowLayout)generalGroup.getLayout()).spacing = 5;
        this.animationCheckBox = new Button((Composite)generalGroup, 16416);
        this.animationCheckBox.setText(Messages.KlighdPreferencePage_animateLayout_text);
        this.animationCheckBox.setToolTipText(Messages.KlighdPreferencePage_animateLayout_tooltip);
        this.animationCheckBox.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.klighd.preferences.animateLayout"));
        this.advancedPanning = new Button((Composite)generalGroup, 16416);
        this.advancedPanning.setText("Advanced panning");
        this.advancedPanning.setToolTipText(ADVANCED_PANNING_TOOLTIP);
        this.advancedPanning.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.klighd.preferences.advancedPanning"));
        this.expandSideBar = new Button((Composite)generalGroup, 16416);
        this.expandSideBar.setText("Expand diagram side bar");
        this.expandSideBar.setToolTipText(EXPAND_SIDE_BAR_TOOLTIP);
        this.expandSideBar.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.klighd.preferences.expandSideBar"));
        return generalGroup;
    }

    private Group createZoomToFitGroup(Composite parent) {
        Group zoomGroup = new Group(parent, 0);
        zoomGroup.setText("Diagram Zoom Options");
        zoomGroup.setLayout((Layout)new RowLayout(512));
        ((RowLayout)zoomGroup.getLayout()).spacing = 5;
        Label zoomSettingsLabel = new Label((Composite)zoomGroup, 0);
        zoomSettingsLabel.setText("When opening a diagram:");
        RowLayout zoomStyleGroupLayout = new RowLayout(256);
        zoomStyleGroupLayout.marginLeft = 0;
        zoomStyleGroupLayout.marginTop = 0;
        zoomStyleGroupLayout.marginBottom = 5;
        Composite zoomStyleGroup = new Composite((Composite)zoomGroup, 0);
        zoomStyleGroup.setLayout((Layout)zoomStyleGroupLayout);
        this.zoomToFit = new Button(zoomStyleGroup, 16400);
        this.zoomToFit.setText(Messages.KlighdPreferencePage_zoomToFit_text);
        this.zoomToFit.setToolTipText(Messages.KlighdPreferencePage_zoomToFit_tooltip);
        this.zoomToFocus = new Button(zoomStyleGroup, 16400);
        this.zoomToFocus.setText(Messages.KlighdPreferencePage_zoomToFocus_text);
        this.zoomToFocus.setToolTipText(Messages.KlighdPreferencePage_zoomToFocus_tooltip);
        this.zoomNone = new Button(zoomStyleGroup, 16400);
        this.zoomNone.setText(Messages.KlighdPreferencePage_zoomNone_text);
        this.zoomNone.setToolTipText(Messages.KlighdPreferencePage_zoomNone_tooltip);
        this.setZoomStyleSelection(ZoomStyle.valueOf((String)this.getPreferenceStore().getString("de.cau.cs.kieler.klighd.preferences.zoomStyle")));
        this.showZoomConfigButtons = new Button((Composite)zoomGroup, 16416);
        this.showZoomConfigButtons.setText("Show zoom configuration buttons in diagram");
        this.showZoomConfigButtons.setToolTipText(SHOW_ZOOM_CONFIG_BUTTONS_TOOLTIP);
        this.showZoomConfigButtons.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.klighd.preferences.showZoomConfigButtons"));
        this.zoomOnWorkbenchpartChange = new Button((Composite)zoomGroup, 16416);
        this.zoomOnWorkbenchpartChange.setText("Update layout and zoom after diagram window size changes");
        this.zoomOnWorkbenchpartChange.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.klighd.preferences.zoomOnWorkBenchPartChange"));
        return zoomGroup;
    }

    private void setZoomStyleSelection(ZoomStyle style) {
        switch (style) {
            case ZOOM_TO_FIT: {
                this.zoomToFit.setSelection(true);
                break;
            }
            case ZOOM_TO_FOCUS: {
                this.zoomToFocus.setSelection(true);
                break;
            }
            case ZOOM_TO_FOCUS_OR_INCREASE_TO_FIT: {
                this.zoomToFocus.setSelection(true);
                break;
            }
            default: {
                this.zoomNone.setSelection(true);
            }
        }
    }

    private ZoomStyle getZoomStyleFromSelection() {
        if (this.zoomToFit.getSelection()) {
            return ZoomStyle.ZOOM_TO_FIT;
        }
        if (this.zoomToFocus.getSelection()) {
            return ZoomStyle.getZoomToFocusStyle();
        }
        return ZoomStyle.NONE;
    }

    private Group createMagnificationLensGroup(Composite parent) {
        Group magnificationLensGroup = new Group(parent, 0);
        magnificationLensGroup.setText("Magification lens");
        magnificationLensGroup.setLayout((Layout)new RowLayout(512));
        this.magLensEnabled = new Button((Composite)magnificationLensGroup, 16416);
        this.magLensEnabled.setText("Enable magnification lens, hit ALT + CTRL/CMD to use it");
        this.magLensEnabled.setSelection(this.getPreferenceStore().getBoolean("de.cau.cs.kieler.klighd.preferences.magnificationLensEnabled"));
        final Composite magnificationLensSizeGroup = new Composite((Composite)magnificationLensGroup, 0);
        magnificationLensSizeGroup.setLayout((Layout)new GridLayout(6, false));
        magnificationLensSizeGroup.setEnabled(this.magLensEnabled.getSelection());
        this.magLensEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                magnificationLensSizeGroup.setEnabled(KlighdPreferencePage.this.magLensEnabled.getSelection());
            }
        });
        Label width = new Label(magnificationLensSizeGroup, 0);
        width.setText("Width:");
        this.magLensWidth = new Spinner(magnificationLensSizeGroup, 0);
        this.magLensWidth.setMinimum(100);
        this.magLensWidth.setMaximum(1000);
        this.magLensWidth.setIncrement(10);
        this.magLensWidth.setPageIncrement(50);
        this.magLensWidth.setSelection(this.getPreferenceStore().getInt("de.cau.cs.kieler.klighd.preferences.magnificationLensWidth"));
        Label height = new Label(magnificationLensSizeGroup, 0);
        height.setText("Height:");
        this.magLensHeight = new Spinner(magnificationLensSizeGroup, 0);
        this.magLensHeight.setMinimum(100);
        this.magLensHeight.setMaximum(1000);
        this.magLensHeight.setIncrement(10);
        this.magLensHeight.setPageIncrement(50);
        this.magLensHeight.setSelection(this.getPreferenceStore().getInt("de.cau.cs.kieler.klighd.preferences.magnificationLensHeight"));
        Label scale = new Label(magnificationLensSizeGroup, 0);
        scale.setText("Scale:");
        this.magLensScale = new Spinner(magnificationLensSizeGroup, 0);
        this.magLensScale.setMinimum(50);
        this.magLensScale.setDigits(2);
        this.magLensScale.setMaximum(500);
        this.magLensScale.setIncrement(25);
        this.magLensScale.setPageIncrement(100);
        this.magLensScale.setSelection(this.getPreferenceStore().getInt("de.cau.cs.kieler.klighd.preferences.magnificationLensScale"));
        return magnificationLensGroup;
    }
}

