/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.options;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.IAction;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.SynthesisOption;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.internal.ISynthesis;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.ui.KlighdUIPlugin;
import de.cau.cs.kieler.klighd.util.KlighdSynthesisProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SynthesisOptionControlFactory {
    private Composite parent;
    private FormToolkit formToolkit;
    private final Collection<Control> controls = Lists.newArrayList();
    private boolean isSubFactory = false;
    private final String parentTitle;
    private final List<SynthesisOptionControlFactory> subFactories = Lists.newArrayList();
    private SynthesisOption factoryCategory = null;
    private final Map<SynthesisOption, SynthesisOptionControlFactory> subCategoryFactories = Maps.newHashMap();
    private static final String SUB_FACTORY_PREFIX = "sidebar.synthesis.expansion.";
    private static final String CATEGORY_FACTORY_PREFIX = "sidebar.category.expansion.";
    private static final int SLIDER_MIN_WIDTH = 70;
    private static final int MAJOR_VERTICAL_SPACING = 6;
    private static final int MINOR_VERTICAL_SPACING = 3;
    private static final int GROUP_SEPARATOR_SPACING = 10;
    private static final int MINOR_HORIZONTAL_MARGIN = 10;
    private static final int UPDATE_WAIT_TIME_MS = 1000;

    public SynthesisOptionControlFactory(Composite parent, FormToolkit formToolkit) {
        this.parent = parent;
        this.formToolkit = formToolkit;
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 6;
        this.parent.setLayout((Layout)gl);
        this.parentTitle = parent.getParent() instanceof Form ? ((Form)parent.getParent()).getText() : null;
    }

    public void clear() {
        for (Control c : this.controls) {
            c.dispose();
        }
        this.controls.clear();
        for (SynthesisOptionControlFactory subFactory : this.subFactories) {
            subFactory.clear();
            subFactory.parent.getParent().dispose();
        }
        this.subFactories.clear();
        if (this.isSubFactory && this.parent.getParent() instanceof Form) {
            ((Form)this.parent.getParent()).setText(this.parentTitle);
        }
        for (SynthesisOptionControlFactory categoryFactory : this.subCategoryFactories.values()) {
            categoryFactory.clear();
            categoryFactory.parent.getParent().dispose();
        }
        this.subCategoryFactories.clear();
    }

    public SynthesisOptionControlFactory createSubSynthesisOptionControlFactory(ISynthesis synthesis) {
        if (!this.isSubFactory && this.parent.getParent() instanceof Form) {
            ((Form)this.parent.getParent()).setText(null);
        }
        Section synthesisSection = this.formToolkit.createSection(this.parent, 16450);
        synthesisSection.setFont(JFaceResources.getHeaderFont());
        synthesisSection.setForeground(this.formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        synthesisSection.setText(String.valueOf(synthesis.getInputDataType().getSimpleName()) + " " + this.parentTitle);
        final String preferenceKey = SUB_FACTORY_PREFIX + KlighdDataManager.getInstance().getSynthesisID(synthesis);
        IPreferenceStore preferenceStore = KlighdUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.setDefault(preferenceKey, true);
        synthesisSection.setExpanded(preferenceStore.getBoolean(preferenceKey));
        synthesisSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                KlighdUIPlugin.getDefault().getPreferenceStore().setValue(preferenceKey, e.getState());
            }
        });
        Composite client = this.formToolkit.createComposite((Composite)synthesisSection);
        synthesisSection.setClient((Control)client);
        SynthesisOptionControlFactory subSynthesisOptionControlFactory = new SynthesisOptionControlFactory(client, this.formToolkit);
        subSynthesisOptionControlFactory.isSubFactory = true;
        this.subFactories.add(subSynthesisOptionControlFactory);
        return subSynthesisOptionControlFactory;
    }

    public boolean createOptionControl(SynthesisOption option, ViewContext context) {
        SynthesisOption category = option.getCategory();
        if (category != null && this.factoryCategory != category) {
            return this.createCategorySynthesisOptionControlFactories(category, context).createOptionControl(option, context);
        }
        if (option.isCheckOption()) {
            this.createCheckOptionControl(option, context);
            return true;
        }
        if (option.isChoiceOption()) {
            this.createChoiceOptionControl(option, context);
            return true;
        }
        if (option.isRangeOption()) {
            this.createRangeOptionControl(option, context);
            return true;
        }
        if (option.isTextOption()) {
            this.createTextOptionControl(option, context);
            return true;
        }
        if (option.isSeparator()) {
            this.createSeparator(option.getName());
            return false;
        }
        if (option.isCategory()) {
            SynthesisOptionControlFactory categoryFactory = this.createCategorySynthesisOptionControlFactories(option, context);
            categoryFactory.parent.getParent().moveBelow(this.parent.getChildren()[this.parent.getChildren().length - 1]);
        }
        return false;
    }

    private SynthesisOptionControlFactory createCategorySynthesisOptionControlFactories(SynthesisOption option, ViewContext context) {
        LinkedList<SynthesisOption> categoryPath = new LinkedList<SynthesisOption>();
        categoryPath.add(option);
        SynthesisOption parentCategory = option.getCategory();
        while (parentCategory != this.factoryCategory) {
            if (categoryPath.contains(parentCategory)) {
                throw new IllegalArgumentException("The given category option has a cycle in the parent categories");
            }
            categoryPath.add(parentCategory);
            parentCategory = parentCategory.getCategory();
        }
        Collections.reverse(categoryPath);
        SynthesisOptionControlFactory categoryFactory = this;
        for (SynthesisOption category : categoryPath) {
            if (!categoryFactory.subCategoryFactories.containsKey(category)) {
                categoryFactory.createCategorySynthesisOptionControlFactory(category, context);
            }
            categoryFactory = categoryFactory.subCategoryFactories.get(category);
        }
        return categoryFactory;
    }

    private SynthesisOptionControlFactory createCategorySynthesisOptionControlFactory(SynthesisOption option, ViewContext context) {
        Section categorySection = this.formToolkit.createSection(this.parent, 16402);
        categorySection.setToolTipText(option.getDescription());
        if (option.getName() != null && !option.getName().isEmpty()) {
            categorySection.setText(option.getName());
        } else {
            categorySection.setText("Unknown Category");
        }
        final String preferenceKey = CATEGORY_FACTORY_PREFIX + KlighdDataManager.getInstance().getSynthesisID(context.getDiagramSynthesis()) + "." + option.getName();
        IPreferenceStore preferenceStore = KlighdUIPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.contains(preferenceKey)) {
            categorySection.setExpanded(KlighdUIPlugin.getDefault().getPreferenceStore().getBoolean(preferenceKey));
        } else {
            categorySection.setExpanded(((Boolean)context.getOptionValue(option)).booleanValue());
        }
        categorySection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                KlighdUIPlugin.getDefault().getPreferenceStore().setValue(preferenceKey, e.getState());
            }
        });
        Composite client = this.formToolkit.createComposite((Composite)categorySection);
        categorySection.setClient((Control)client);
        SynthesisOptionControlFactory categorySynthesisOptionControlFactory = new SynthesisOptionControlFactory(client, this.formToolkit);
        categorySynthesisOptionControlFactory.factoryCategory = option;
        this.subCategoryFactories.put(option, categorySynthesisOptionControlFactory);
        return categorySynthesisOptionControlFactory;
    }

    private void createSeparator(String labelText) {
        if (labelText == null || labelText.isEmpty()) {
            Label separator = this.formToolkit.createSeparator(this.parent, 256);
            this.controls.add((Control)separator);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        } else {
            Label label = this.formToolkit.createLabel(this.parent, labelText);
            this.controls.add((Control)label);
            label.setForeground(this.formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            GridDataFactory.fillDefaults().grab(true, false).indent(0, 10).applyTo((Control)label);
        }
    }

    private void createCheckOptionControl(final SynthesisOption option, final ViewContext context) {
        Button checkButton = this.formToolkit.createButton(this.parent, option.getName(), 32);
        checkButton.setToolTipText(option.getDescription());
        this.controls.add((Control)checkButton);
        checkButton.setSelection(((Boolean)context.getOptionValue(option)).booleanValue());
        String us = option.getUpdateStrategy();
        final KlighdSynthesisProperties properties = us == null ? null : KlighdSynthesisProperties.create((IPropertyHolder[])new IPropertyHolder[0]).useUpdateStrategy(us);
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                context.configureOption(option, (Object)((Button)event.widget).getSelection());
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (option.getUpdateAction() != null) {
                            SynthesisOptionControlFactory.this.invokeUpdateAction(option.getUpdateAction(), context);
                        } else {
                            new LightDiagramLayoutConfig(context).properties((IPropertyHolder)properties).animate(option.getAnimateUpdate()).performUpdate();
                        }
                    }
                });
            }
        });
    }

    private void createChoiceOptionControl(final SynthesisOption option, final ViewContext context) {
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 3;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        Composite valuesContainer = this.formToolkit.createComposite(this.parent);
        valuesContainer.setLayout((Layout)gl);
        this.controls.add((Control)valuesContainer);
        Label label = this.formToolkit.createLabel(valuesContainer, String.valueOf(option.getName()) + ":");
        label.setToolTipText(option.getDescription());
        for (final Object value : option.getValues()) {
            GridData vGd = new GridData();
            vGd.horizontalIndent = 10;
            Button button = this.formToolkit.createButton(valuesContainer, value.toString(), 16);
            button.setToolTipText(option.getDescription());
            button.setLayoutData((Object)vGd);
            String us = option.getUpdateStrategy();
            final KlighdSynthesisProperties properties = us == null ? null : KlighdSynthesisProperties.create((IPropertyHolder[])new IPropertyHolder[0]).useUpdateStrategy(us);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (((Button)event.widget).getSelection()) {
                        context.configureOption(option, value);
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (option.getUpdateAction() != null) {
                                    SynthesisOptionControlFactory.this.invokeUpdateAction(option.getUpdateAction(), context);
                                } else {
                                    new LightDiagramLayoutConfig(context).properties((IPropertyHolder)properties).animate(option.getAnimateUpdate()).performUpdate();
                                }
                            }
                        });
                    }
                }
            });
            button.setSelection(value.equals(context.getOptionValue(option)));
        }
    }

    private void createRangeOptionControl(final SynthesisOption option, final ViewContext context) {
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 3;
        gl.marginTop = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        final Composite container = this.formToolkit.createComposite(this.parent);
        container.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        container.setLayout((Layout)gl);
        this.controls.add((Control)container);
        final Label label = this.formToolkit.createLabel(container, "");
        label.setToolTipText(option.getDescription());
        Scale scale = new Scale(container, 0);
        scale.setBackground(container.getBackground());
        scale.setToolTipText(option.getDescription());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumWidth = 70;
        scale.setLayoutData((Object)gridData);
        final double min = ((Number)option.getRange().getFirst()).doubleValue();
        double max = ((Number)option.getRange().getSecond()).doubleValue();
        final double stepSize = option.getStepSize().doubleValue();
        double init = ((Number)context.getOptionValue(option)).doubleValue();
        final double minShifted = min + stepSize / 2.0;
        final boolean floatSteps = option.getStepSize() instanceof Float || option.getStepSize() instanceof Double;
        int scalerMax = 255;
        final double scalerStepSize = (max - min) / 255.0;
        scale.setMinimum(0);
        scale.setMaximum(255);
        int scaleInit = (int)Math.ceil((init - min) / scalerStepSize);
        scale.setSelection(scaleInit);
        final String labelString = String.valueOf(option.getName()) + ": ";
        label.setText(String.valueOf(labelString) + context.getOptionValue(option));
        String us = option.getUpdateStrategy();
        final KlighdSynthesisProperties properties = us == null ? null : KlighdSynthesisProperties.create((IPropertyHolder[])new IPropertyHolder[0]).useUpdateStrategy(us);
        scale.addSelectionListener((SelectionListener)new SelectionAdapter(scale){
            private Timer timer;
            private double currentValue;
            {
                this.currentValue = scale.getSelection();
            }

            public void widgetSelected(SelectionEvent event) {
                if (this.timer != null) {
                    this.timer.cancel();
                }
                Scale scale = (Scale)event.widget;
                double sourceValue = minShifted + scalerStepSize * (double)scale.getSelection();
                final double value = min + Math.floor((sourceValue - min) / stepSize) * stepSize;
                scale.setSelection((int)Math.floor((value - min) / scalerStepSize));
                if (floatSteps) {
                    label.setText(String.valueOf(labelString) + value);
                } else {
                    label.setText(String.valueOf(labelString) + (int)value);
                }
                this.timer = new Timer();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (value == currentValue) {
                            return;
                        }
                        currentValue = value;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (floatSteps) {
                                    context.configureOption(option, (Object)Float.valueOf((float)value));
                                } else {
                                    context.configureOption(option, (Object)((int)value));
                                }
                                container.layout(true);
                                if (option.getUpdateAction() != null) {
                                    SynthesisOptionControlFactory.this.invokeUpdateAction(option.getUpdateAction(), context);
                                } else {
                                    new LightDiagramLayoutConfig(context).properties((IPropertyHolder)properties).animate(option.getAnimateUpdate()).performUpdate();
                                }
                            }
                        });
                        timer.cancel();
                    }
                };
                this.timer.schedule(task, 1000L);
            }
        });
    }

    private void createTextOptionControl(final SynthesisOption option, final ViewContext context) {
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 3;
        gl.marginTop = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        final Composite container = this.formToolkit.createComposite(this.parent);
        container.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        container.setLayout((Layout)gl);
        this.controls.add((Control)container);
        Label label = this.formToolkit.createLabel(container, "");
        label.setToolTipText(option.getDescription());
        Text text = this.formToolkit.createText(container, (String)context.getOptionValue(option));
        text.setToolTipText(option.getDescription());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        text.setLayoutData((Object)gridData);
        label.setText(String.valueOf(option.getName()) + ":");
        String us = option.getUpdateStrategy();
        final KlighdSynthesisProperties properties = us == null ? null : KlighdSynthesisProperties.create((IPropertyHolder[])new IPropertyHolder[0]).useUpdateStrategy(us);
        text.addModifyListener(new ModifyListener(text){
            private Timer timer;
            private String currentValue;
            {
                this.currentValue = text.getText();
            }

            public void modifyText(ModifyEvent e) {
                if (this.timer != null) {
                    this.timer.cancel();
                }
                Text text = (Text)e.widget;
                final String s = text.getText();
                this.timer = new Timer();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (s == currentValue) {
                            return;
                        }
                        currentValue = s;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                context.configureOption(option, (Object)s);
                                container.layout(true);
                                if (option.getUpdateAction() != null) {
                                    SynthesisOptionControlFactory.this.invokeUpdateAction(option.getUpdateAction(), context);
                                } else {
                                    new LightDiagramLayoutConfig(context).properties((IPropertyHolder)properties).animate(option.getAnimateUpdate()).performUpdate();
                                }
                            }
                        });
                        timer.cancel();
                    }
                };
                this.timer.schedule(task, 1000L);
            }
        });
    }

    private void invokeUpdateAction(String actionID, ViewContext viewContext) {
        if (actionID == null) {
            return;
        }
        IAction action = KlighdDataManager.getInstance().getActionById(actionID);
        if (action == null) {
            return;
        }
        IViewer viewer = viewContext.getViewer();
        viewContext.getLayoutRecorder().startRecording();
        IAction.ActionResult result = action.execute(new IAction.ActionContext(viewer, null, (KGraphElement)viewer.getViewContext().getViewModel(), null));
        if (result.getActionPerformed()) {
            if (result.getNeedsSynthesis()) {
                viewContext.update();
            }
            new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(result.getAnimateLayout())).zoomStyle(ZoomStyle.create((IAction.ActionResult)result, (ViewContext)viewContext)).focusElement(result.getFocusElement()).previousPosition(result.getPreviousPosition()).options(result.getLayoutConfigs()).performLayout();
        } else {
            viewContext.getLayoutRecorder().stopRecording(ZoomStyle.NONE, null, 0);
        }
    }
}

