/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.options;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.inject.Injector;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.elk.core.service.LayoutConfigurationManager;
import org.eclipse.elk.core.service.LayoutConnectorsService;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LayoutOptionControlFactory {
    private Composite parent;
    private ViewContext viewContext;
    private IDiagramWorkbenchPart workbenchPart;
    private FormToolkit formToolkit;
    private LayoutConfigurator layoutConfig;
    private LayoutConfigurationManager layoutConfigManager;
    private ILayoutConfigurationStore layoutConfigStore;
    private final Collection<Control> controls = new LinkedList<Control>();
    private boolean autoRefreshLayout = true;
    private static final int ENUM_GRID_COLS = 1;
    private static final String DATA_SELECTION_LISTENER = "klighd.selectionListener";
    private static final int DEFAULT_MIN = 0;
    private static final int DEFAULT_MAX = 100;
    private static final Pattern MAX_2_DIGITS = Pattern.compile("(.*\\.\\d[^0]?)\\d*");
    private static final String FIRST_GROUP = "$1";

    public LayoutOptionControlFactory(Composite parent, FormToolkit formToolkit) {
        this.parent = parent;
        this.formToolkit = formToolkit;
        this.parent.setLayout((Layout)new GridLayout(1, false));
    }

    public void initialize(ViewContext theViewContext) {
        this.layoutConfig = new LayoutConfigurator();
        this.viewContext = theViewContext;
        this.workbenchPart = this.viewContext.getDiagramWorkbenchPart();
        KNode viewModel = this.viewContext.getViewModel();
        Injector injector = LayoutConnectorsService.getInstance().getInjector(null, (Object)theViewContext);
        this.layoutConfigManager = (LayoutConfigurationManager)injector.getInstance(LayoutConfigurationManager.class);
        ILayoutConfigurationStore.Provider layoutConfigStoreProvider = (ILayoutConfigurationStore.Provider)injector.getInstance(ILayoutConfigurationStore.Provider.class);
        this.layoutConfigStore = layoutConfigStoreProvider.get((IWorkbenchPart)this.workbenchPart, (Object)viewModel);
    }

    public LayoutConfigurator getLayoutConfig() {
        return this.layoutConfig;
    }

    public void clear() {
        for (Control c : this.controls) {
            c.dispose();
        }
        this.controls.clear();
    }

    private void refreshLayout(boolean animate) {
        if (this.autoRefreshLayout) {
            new LightDiagramLayoutConfig(this.viewContext).animate(Boolean.valueOf(animate)).performLayout();
        }
    }

    public void createControl(String optionId) {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(optionId);
        if (optionData != null) {
            this.createControl(optionData, null, null, null);
        }
    }

    public void createControl(String optionId, Float minValue, Float maxValue) {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(optionId);
        if (optionData != null) {
            this.createControl(optionData, minValue, maxValue, null);
        }
    }

    public void createControl(String optionId, Collection<?> availableValues) {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(optionId);
        if (optionData != null) {
            this.createControl(optionData, null, null, availableValues);
        }
    }

    public void resetToDefaults(boolean doLayout) {
        this.autoRefreshLayout = false;
        this.layoutConfig = new LayoutConfigurator();
        block4: for (Control control : this.controls) {
            if (!(control.getData() instanceof LayoutOptionData)) continue;
            LayoutOptionData optionData = (LayoutOptionData)control.getData();
            final Object defaultValue = this.layoutConfigManager.getOptionValue(optionData, this.layoutConfigStore);
            switch (optionData.getType()) {
                case INT: 
                case DOUBLE: {
                    Scale slider = (Scale)control;
                    SliderListener sliderListener = (SliderListener)((Object)control.getData(DATA_SELECTION_LISTENER));
                    if (sliderListener == null) break;
                    double initialValue = ElkMath.boundd((double)((Number)defaultValue).doubleValue(), (double)sliderListener.minVal, (double)sliderListener.maxVal);
                    int selection = (int)Math.round((initialValue - sliderListener.minVal) / (sliderListener.maxVal - sliderListener.minVal) * (double)(slider.getMaximum() - slider.getMinimum())) + slider.getMinimum();
                    slider.setSelection(selection);
                    break;
                }
                case BOOLEAN: 
                case ENUM: {
                    Composite composite = (Composite)control;
                    Control selection = (Control)Iterators.find((Iterator)Iterators.forArray((Object[])composite.getChildren()), (Predicate)new Predicate<Control>(){

                        public boolean apply(Control input) {
                            if (input.getData() != null) {
                                return input.getData().equals(defaultValue);
                            }
                            return false;
                        }
                    }, null);
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        ((Button)c).setSelection(c == selection);
                        ++n2;
                    }
                    continue block4;
                }
            }
        }
        this.autoRefreshLayout = true;
        if (doLayout) {
            this.refreshLayout(true);
        }
    }

    private void createControl(LayoutOptionData optionData, Float minValue, Float maxValue, Collection<?> availableValues) {
        Label label = this.formToolkit.createLabel(this.parent, String.valueOf(optionData.getName()) + ":");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.controls.add((Control)label);
        switch (optionData.getType()) {
            case INT: 
            case DOUBLE: {
                Scale slider = new Scale(this.parent, 0);
                slider.setBackground(this.parent.getBackground());
                slider.setToolTipText(optionData.getDescription());
                SliderListener sliderListener = new SliderListener(label, optionData, LayoutOptionControlFactory.getMinValue(optionData, minValue), LayoutOptionControlFactory.getMaxValue(optionData, maxValue));
                GridData gridData = new GridData(4, 128, true, false);
                slider.setLayoutData((Object)gridData);
                slider.setData((Object)optionData);
                this.controls.add((Control)slider);
                double initialValue = ((Number)this.layoutConfigManager.getOptionValue(optionData, this.layoutConfigStore)).doubleValue();
                initialValue = ElkMath.boundd((double)initialValue, (double)sliderListener.minVal, (double)sliderListener.maxVal);
                label.setText(String.valueOf(optionData.getName()) + ": " + initialValue);
                int selection = (int)Math.round((initialValue - sliderListener.minVal) / (sliderListener.maxVal - sliderListener.minVal) * (double)(slider.getMaximum() - slider.getMinimum())) + slider.getMinimum();
                slider.setSelection(selection);
                slider.addSelectionListener((SelectionListener)sliderListener);
                slider.setData(DATA_SELECTION_LISTENER, (Object)sliderListener);
                break;
            }
            case BOOLEAN: {
                Composite valuesContainer = this.formToolkit.createComposite(this.parent);
                valuesContainer.setLayout((Layout)new GridLayout(2, false));
                Button trueButton = this.formToolkit.createButton(valuesContainer, "True", 16);
                trueButton.setToolTipText(optionData.getDescription());
                trueButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                trueButton.setData((Object)true);
                Button falseButton = this.formToolkit.createButton(valuesContainer, "False", 16);
                falseButton.setToolTipText(optionData.getDescription());
                falseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                falseButton.setData((Object)false);
                valuesContainer.setData((Object)optionData);
                this.controls.add((Control)valuesContainer);
                if (((Boolean)this.layoutConfigManager.getOptionValue(optionData, this.layoutConfigStore)).booleanValue()) {
                    trueButton.setSelection(true);
                } else {
                    falseButton.setSelection(true);
                }
                trueButton.addSelectionListener((SelectionListener)new EnumerationListener(optionData, Boolean.TRUE));
                falseButton.addSelectionListener((SelectionListener)new EnumerationListener(optionData, Boolean.FALSE));
                break;
            }
            case ENUM: {
                Object[] values;
                Composite valuesContainer = this.formToolkit.createComposite(this.parent);
                valuesContainer.setLayout((Layout)new GridLayout(1, false));
                if (availableValues != null) {
                    values = availableValues.toArray();
                } else {
                    Class clazz = optionData.getOptionClass();
                    values = clazz.getEnumConstants();
                }
                Object initialValue = this.layoutConfigManager.getOptionValue(optionData, this.layoutConfigStore);
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    Button button = this.formToolkit.createButton(valuesContainer, LayoutOptionControlFactory.getUserValue(value), 16);
                    button.setToolTipText(optionData.getDescription());
                    button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                    button.setData(value);
                    if (value.equals(initialValue)) {
                        button.setSelection(true);
                    }
                    button.addSelectionListener((SelectionListener)new EnumerationListener(optionData, value));
                    ++n2;
                }
                valuesContainer.setData((Object)optionData);
                this.controls.add((Control)valuesContainer);
                break;
            }
            case ENUMSET: {
                Composite valuesContainer = this.formToolkit.createComposite(this.parent);
                valuesContainer.setLayout((Layout)new GridLayout(1, false));
                if (availableValues == null) {
                    Label errorLabel = new Label(this.parent, 0);
                    errorLabel.setText("This option type requires pre-defined values.");
                    errorLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
                    this.controls.add((Control)errorLabel);
                    break;
                }
                Object[] values = availableValues.toArray();
                Object initialValue = this.layoutConfigManager.getOptionValue(optionData, this.layoutConfigStore);
                Object[] objectArray = values;
                int n = values.length;
                int n3 = 0;
                while (n3 < n) {
                    Object value = objectArray[n3];
                    Button button = this.formToolkit.createButton(valuesContainer, LayoutOptionControlFactory.getUserValue(value), 16);
                    button.setToolTipText(optionData.getDescription());
                    button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                    button.setData(value);
                    if (value.equals(initialValue)) {
                        button.setSelection(true);
                    }
                    button.addSelectionListener((SelectionListener)new EnumerationListener(optionData, value));
                    ++n3;
                }
                valuesContainer.setData((Object)optionData);
                this.controls.add((Control)valuesContainer);
                break;
            }
            default: {
                Label errorLabel = new Label(this.parent, 0);
                errorLabel.setText("This option type is not supported");
                errorLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
                this.controls.add((Control)errorLabel);
            }
        }
    }

    private static float getMinValue(LayoutOptionData optionData, Float requested) {
        if (requested != null) {
            return requested.floatValue();
        }
        Comparable lowerBound = optionData.getLowerBound();
        if (lowerBound instanceof Number) {
            return ((Number)((Object)lowerBound)).floatValue();
        }
        return 0.0f;
    }

    private static float getMaxValue(LayoutOptionData optionData, Float requested) {
        if (requested != null) {
            return requested.floatValue();
        }
        Comparable upperBound = optionData.getUpperBound();
        if (upperBound instanceof Number) {
            return ((Number)((Object)upperBound)).floatValue();
        }
        return 100.0f;
    }

    private static String getUserValue(Object object) {
        String string = object.toString();
        StringBuilder builder = new StringBuilder(string.length());
        boolean capital = true;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '_') {
                builder.append(' ');
                capital = true;
            } else if (capital) {
                builder.append(Character.toUpperCase(string.charAt(i)));
                capital = false;
            } else {
                builder.append(Character.toLowerCase(string.charAt(i)));
            }
            ++i;
        }
        return builder.toString();
    }

    private class EnumerationListener
    extends SelectionAdapter {
        private LayoutOptionData optionData;
        private Object value;

        EnumerationListener(LayoutOptionData optionData, Object value) {
            this.optionData = optionData;
            this.value = value;
        }

        public void widgetSelected(SelectionEvent event) {
            if (((Button)event.widget).getSelection()) {
                LayoutOptionControlFactory.this.layoutConfig.configure(ElkGraphElement.class).setProperty((IProperty)this.optionData, this.value);
                LayoutOptionControlFactory.this.refreshLayout(true);
            }
        }
    }

    private class SliderListener
    extends SelectionAdapter {
        private final Label correspondingLabel;
        private final LayoutOptionData optionData;
        private final double minVal;
        private final double maxVal;

        SliderListener(Label textLabel, LayoutOptionData optionData, double minVal, double maxVal) {
            this.correspondingLabel = textLabel;
            this.optionData = optionData;
            this.minVal = minVal;
            this.maxVal = maxVal <= minVal ? minVal + 1.0 : maxVal;
        }

        public void widgetSelected(SelectionEvent event) {
            Scale slider = (Scale)event.widget;
            double sliderValue = (float)(slider.getSelection() - slider.getMinimum()) / (float)(slider.getMaximum() - slider.getMinimum());
            double optionValue = this.minVal + sliderValue * (this.maxVal - this.minVal);
            this.setOptionValue(optionValue);
            this.correspondingLabel.setText(String.valueOf(this.optionData.getName()) + ": " + MAX_2_DIGITS.matcher(String.valueOf(optionValue)).replaceFirst(LayoutOptionControlFactory.FIRST_GROUP));
            this.correspondingLabel.getParent().layout(true);
            LayoutOptionControlFactory.this.refreshLayout(false);
        }

        public void setOptionValue(double optionValue) {
            switch (this.optionData.getType()) {
                case INT: {
                    LayoutOptionControlFactory.this.layoutConfig.configure(ElkGraphElement.class).setProperty((IProperty)this.optionData, (Object)((int)optionValue));
                    break;
                }
                case DOUBLE: {
                    LayoutOptionControlFactory.this.layoutConfig.configure(ElkGraphElement.class).setProperty((IProperty)this.optionData, (Object)optionValue);
                }
            }
        }
    }
}

