/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.options;

import de.cau.cs.kieler.klighd.DisplayedActionData;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewChangeListener;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.KlighdConstants;
import de.cau.cs.kieler.klighd.KlighdPreferences;
import de.cau.cs.kieler.klighd.LightDiagramServices;
import de.cau.cs.kieler.klighd.SynthesisOption;
import de.cau.cs.kieler.klighd.ViewChangeType;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.internal.ISynthesis;
import de.cau.cs.kieler.klighd.ui.KlighdUIPlugin;
import de.cau.cs.kieler.klighd.ui.internal.options.ActionControlFactory;
import de.cau.cs.kieler.klighd.ui.internal.options.LayoutOptionControlFactory;
import de.cau.cs.kieler.klighd.ui.internal.options.SynthesisOptionControlFactory;
import de.cau.cs.kieler.klighd.ui.parts.DiagramViewPart;
import de.cau.cs.kieler.klighd.util.KlighdSynthesisProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class DiagramSideBar {
    private static final int INITIAL_OPTIONS_FORM_WIDTH = 230;
    private static final int MINIMAL_OPTIONS_FORM_WIDTH = 100;
    private static final int SYNTHESIS_LAYOUT_OPTIONS_SPACE = 20;
    private static final int SASH_WIDTH = 7;
    private static final int FULL = 100;
    private static final int CANVAS_ZOOM_BTNS_OFFSET = 3;
    private boolean zoomButtonsVisible = KlighdPreferences.isShowZoomConfigButtons();
    private boolean initiallyExpanded = KlighdPreferences.isExpandSideBar();
    private final Composite sideBarParent;
    private ActionControlFactory actionControlFactory;
    private SynthesisOptionControlFactory synthesisOptionControlFactory;
    private LayoutOptionControlFactory layoutOptionControlFactory;
    private FormToolkit optionsformToolkit;
    private Form sideZoomBtnsForm;
    private Composite canvasZoomBtnsContainer;
    private ScrolledForm scrolledRootForm;
    private Form actionsForm;
    private Form synthesisOptionsForm;
    private Form layoutOptionsForm;
    private final List<Resource> resources = new LinkedList<Resource>();
    private final List<Control> sideBarControls = new ArrayList<Control>(5);
    private FormData sashLayoutData = null;
    private int horizontalPos = this.initiallyExpanded ? -230 : -7;
    private ViewContext viewContext;
    private static final String BUTTON_TYPE = "type";

    private DiagramSideBar(Composite parent) {
        this.sideBarParent = parent;
    }

    public LayoutConfigurator getLayoutConfig() {
        return this.layoutOptionControlFactory.getLayoutConfig();
    }

    public static DiagramSideBar createSideBar(Composite parent, Composite diagramContainer, ViewContext viewContext) {
        return new DiagramSideBar(parent).initialize(diagramContainer, viewContext);
    }

    private DiagramSideBar initialize(Composite diagramContainer, ViewContext theViewContext) {
        this.viewContext = theViewContext;
        switch ((KlighdSynthesisProperties.SideBarHandling)this.viewContext.getProperty(KlighdSynthesisProperties.REQUESTED_SIDE_BAR_HANDLING)) {
            case UNDEFINED: {
                break;
            }
            case EXPAND: {
                this.initiallyExpanded = true;
                this.horizontalPos = -230;
                break;
            }
            case COLLAPSE: {
                this.initiallyExpanded = false;
                this.horizontalPos = -7;
            }
        }
        switch ((KlighdSynthesisProperties.ZoomConfigButtonsHandling)this.viewContext.getProperty(KlighdSynthesisProperties.REQUESTED_ZOOM_CONFIG_BUTTONS_HANDLING)) {
            case UNDEFINED: {
                break;
            }
            case SHOW: {
                this.zoomButtonsVisible = true;
                break;
            }
            case HIDE: {
                this.zoomButtonsVisible = false;
            }
        }
        this.sideBarParent.setLayout((Layout)new FormLayout());
        Composite arrowsContainer = new Composite(this.sideBarParent, 0);
        this.sideBarControls.add((Control)arrowsContainer);
        arrowsContainer.setVisible(false);
        final StackLayout arrowLabelContainerLayout = new StackLayout();
        arrowsContainer.setLayout((Layout)arrowLabelContainerLayout);
        final Label rightArrowLabel = new Label(arrowsContainer, 0);
        Image rightArrow = KlighdUIPlugin.getImageDescriptorFromKlighdBase("icons/arrow-right.gif").createImage();
        this.resources.add((Resource)rightArrow);
        rightArrowLabel.setImage(rightArrow);
        rightArrowLabel.setVisible(true);
        final Label leftArrowLabel = new Label(arrowsContainer, 0);
        Image leftArrow = KlighdUIPlugin.getImageDescriptorFromKlighdBase("icons/arrow-left.gif").createImage();
        this.resources.add((Resource)leftArrow);
        leftArrowLabel.setImage(leftArrow);
        leftArrowLabel.setVisible(true);
        arrowLabelContainerLayout.topControl = this.initiallyExpanded ? rightArrowLabel : leftArrowLabel;
        final Sash sash = new Sash(this.sideBarParent, 512);
        this.sideBarControls.add((Control)sash);
        sash.addPaintListener((PaintListener)new LinePainter());
        sash.setVisible(false);
        this.optionsformToolkit = new FormToolkit(this.sideBarParent.getDisplay());
        if (this.zoomButtonsVisible) {
            this.sideZoomBtnsForm = this.optionsformToolkit.createForm(this.sideBarParent);
            this.sideZoomBtnsForm.setText(null);
            this.sideBarControls.add((Control)this.sideZoomBtnsForm);
            Composite sideZoomBtnsContainer = this.sideZoomBtnsForm.getBody();
            this.sideZoomBtnsForm.setBackground(Display.getCurrent().getSystemColor(25));
            this.initializeZoomButtons(sideZoomBtnsContainer);
        }
        this.scrolledRootForm = this.optionsformToolkit.createScrolledForm(this.sideBarParent);
        this.scrolledRootForm.setText(null);
        this.sideBarControls.add((Control)this.scrolledRootForm);
        Composite formRoot = this.scrolledRootForm.getBody();
        formRoot.setLayout((Layout)new FormLayout());
        this.actionsForm = this.optionsformToolkit.createForm(formRoot);
        this.sideBarControls.add((Control)this.actionsForm);
        this.actionsForm.setText("Actions");
        this.actionsForm.setVisible(false);
        Composite actionsContainer = this.actionsForm.getBody();
        this.actionControlFactory = new ActionControlFactory(actionsContainer, this.optionsformToolkit);
        this.synthesisOptionsForm = this.optionsformToolkit.createForm(formRoot);
        this.sideBarControls.add((Control)this.synthesisOptionsForm);
        this.synthesisOptionsForm.setText("Diagram Options");
        this.synthesisOptionsForm.setVisible(false);
        Composite synthesisOptionsContainer = this.synthesisOptionsForm.getBody();
        this.synthesisOptionControlFactory = new SynthesisOptionControlFactory(synthesisOptionsContainer, this.optionsformToolkit);
        this.layoutOptionsForm = this.optionsformToolkit.createForm(formRoot);
        this.sideBarControls.add((Control)this.layoutOptionsForm);
        this.layoutOptionsForm.setText("Layout Options");
        this.layoutOptionsForm.setVisible(false);
        Composite layoutOptionsContainer = this.layoutOptionsForm.getBody();
        this.layoutOptionControlFactory = new LayoutOptionControlFactory(layoutOptionsContainer, this.optionsformToolkit);
        FormData diagramContainerLayoutData = new FormData();
        diagramContainerLayoutData.top = new FormAttachment(0);
        diagramContainerLayoutData.bottom = new FormAttachment(100);
        diagramContainerLayoutData.left = new FormAttachment(0);
        diagramContainerLayoutData.right = new FormAttachment((Control)sash);
        diagramContainer.setLayoutData((Object)diagramContainerLayoutData);
        FormData arrowsContainerLayoutData = new FormData();
        arrowsContainerLayoutData.top = new FormAttachment(0);
        arrowsContainerLayoutData.bottom = new FormAttachment((Control)sash);
        arrowsContainerLayoutData.left = new FormAttachment((Control)diagramContainer);
        arrowsContainerLayoutData.right = new FormAttachment((Control)this.scrolledRootForm);
        arrowsContainer.setLayoutData((Object)arrowsContainerLayoutData);
        this.sashLayoutData = new FormData();
        this.sashLayoutData.top = new FormAttachment((Control)arrowsContainer);
        this.sashLayoutData.bottom = new FormAttachment(100);
        this.sashLayoutData.left = new FormAttachment(100);
        this.sashLayoutData.width = 7;
        sash.setLayoutData((Object)this.sashLayoutData);
        if (this.zoomButtonsVisible) {
            FormData toolbarFormLayoutData = new FormData();
            toolbarFormLayoutData.top = new FormAttachment(1);
            toolbarFormLayoutData.left = new FormAttachment((Control)sash);
            toolbarFormLayoutData.right = new FormAttachment(100);
            this.sideZoomBtnsForm.setLayoutData((Object)toolbarFormLayoutData);
        }
        FormData formRootLayoutData = new FormData();
        formRootLayoutData.top = this.zoomButtonsVisible ? new FormAttachment((Control)this.sideZoomBtnsForm) : new FormAttachment(0);
        formRootLayoutData.bottom = new FormAttachment(100);
        formRootLayoutData.left = new FormAttachment((Control)sash);
        formRootLayoutData.right = new FormAttachment(100);
        this.scrolledRootForm.setLayoutData((Object)formRootLayoutData);
        FormData acionsFormLayoutData = new FormData();
        acionsFormLayoutData.top = new FormAttachment(0);
        acionsFormLayoutData.left = new FormAttachment(0);
        acionsFormLayoutData.right = new FormAttachment(100);
        this.actionsForm.setLayoutData((Object)acionsFormLayoutData);
        FormData synthesisOptionsFormLayoutData = new FormData();
        synthesisOptionsFormLayoutData.top = new FormAttachment((Control)this.actionsForm, 20);
        synthesisOptionsFormLayoutData.left = new FormAttachment(0);
        synthesisOptionsFormLayoutData.right = new FormAttachment(100);
        this.synthesisOptionsForm.setLayoutData((Object)synthesisOptionsFormLayoutData);
        FormData layoutOptionsFormLayoutData = new FormData();
        layoutOptionsFormLayoutData.top = new FormAttachment((Control)this.synthesisOptionsForm, 20);
        layoutOptionsFormLayoutData.bottom = new FormAttachment(100);
        layoutOptionsFormLayoutData.left = new FormAttachment(0);
        layoutOptionsFormLayoutData.right = new FormAttachment(100);
        this.layoutOptionsForm.setLayoutData((Object)layoutOptionsFormLayoutData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramSideBar.this.updateZoomButtons(true);
                int maxDiagSize = DiagramSideBar.this.sideBarParent.getClientArea().width - 100;
                if (maxDiagSize > event.x) {
                    DiagramSideBar.this.sashLayoutData.left.numerator = 100;
                    DiagramSideBar.this.sashLayoutData.left.offset = -(DiagramSideBar.this.sideBarParent.getClientArea().width - event.x);
                } else {
                    DiagramSideBar.this.sashLayoutData.left.numerator = 100;
                    DiagramSideBar.this.sashLayoutData.left.offset = -100;
                    event.x = maxDiagSize;
                }
                DiagramSideBar.this.horizontalPos = DiagramSideBar.this.sashLayoutData.left.offset;
                arrowLabelContainerLayout.topControl = rightArrowLabel;
                DiagramSideBar.this.sideBarParent.layout(true, true);
            }
        });
        final int[] lastXpos = new int[]{230};
        rightArrowLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                DiagramSideBar.this.updateZoomButtons(false);
                DiagramSideBar.this.sashLayoutData.left.numerator = 100;
                DiagramSideBar.this.sashLayoutData.left.offset = -DiagramSideBar.this.sashLayoutData.width;
                lastXpos[0] = DiagramSideBar.this.sideBarParent.getClientArea().width - sash.getBounds().x;
                DiagramSideBar.this.horizontalPos = DiagramSideBar.this.sashLayoutData.left.offset;
                arrowLabelContainerLayout.topControl = leftArrowLabel;
                DiagramSideBar.this.sideBarParent.layout(true, true);
            }
        });
        leftArrowLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                DiagramSideBar.this.updateZoomButtons(true);
                DiagramSideBar.this.sashLayoutData.left.numerator = 100;
                DiagramSideBar.this.horizontalPos = DiagramSideBar.this.sashLayoutData.left.offset = -lastXpos[0];
                arrowLabelContainerLayout.topControl = rightArrowLabel;
                DiagramSideBar.this.sideBarParent.layout(true, true);
            }
        });
        return this;
    }

    private void initializeZoomButtons(Composite parent) {
        if (!this.zoomButtonsVisible) {
            return;
        }
        parent.setLayout((Layout)new RowLayout());
        final Button zoomToFitBtn = new Button(parent, 0x800002);
        final Button zoomToFocusBtn = new Button(parent, 0x800002);
        Button zoomToOneBtn = new Button(parent, 0x800008);
        Image zoomToFitImage = KlighdUIPlugin.getImageDescriptorFromKlighdBase("icons/kieler-zoomtofit.gif").createImage();
        this.resources.add((Resource)zoomToFitImage);
        zoomToFitBtn.setImage(zoomToFitImage);
        zoomToFitBtn.setToolTipText("Toggle Zoom to Fit");
        zoomToFitBtn.setData(BUTTON_TYPE, (Object)ZoomStyle.ZOOM_TO_FIT);
        zoomToFitBtn.setSelection(this.viewContext.isZoomToFit());
        zoomToFitBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagramSideBar.this.viewContext.setZoomStyle(ZoomStyle.create((boolean)false, (boolean)zoomToFitBtn.getSelection(), (boolean)false, (boolean)false, (boolean)false));
                if (zoomToFitBtn.getSelection()) {
                    LightDiagramServices.zoomDiagram((ViewContext)DiagramSideBar.this.viewContext);
                    zoomToFocusBtn.setSelection(false);
                }
            }
        });
        Image zoomToFocusImage = KlighdUIPlugin.getImageDescriptorFromKlighdBase("icons/kieler-zoomtofocus.gif").createImage();
        this.resources.add((Resource)zoomToFocusImage);
        zoomToFocusBtn.setImage(zoomToFocusImage);
        zoomToFocusBtn.setToolTipText("Toggle Zoom to Focus");
        zoomToFocusBtn.setData(BUTTON_TYPE, (Object)ZoomStyle.getZoomToFocusStyle());
        zoomToFocusBtn.setSelection(this.viewContext.isZoomToFocus());
        zoomToFocusBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagramSideBar.this.viewContext.setZoomStyle(ZoomStyle.create((boolean)false, (boolean)false, (boolean)false, (boolean)zoomToFocusBtn.getSelection(), (boolean)false));
                if (zoomToFocusBtn.getSelection()) {
                    LightDiagramServices.zoomDiagram((ViewContext)DiagramSideBar.this.viewContext);
                    zoomToFitBtn.setSelection(false);
                }
            }
        });
        Image zoomToOneImage = KlighdUIPlugin.getImageDescriptorFromKlighdBase("icons/kieler-zoomtoone.gif").createImage();
        this.resources.add((Resource)zoomToOneImage);
        zoomToOneBtn.setImage(zoomToOneImage);
        zoomToOneBtn.setToolTipText("Zoom to Original Size");
        zoomToOneBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagramSideBar.this.viewContext.getViewer().zoomToLevel(1.0f, 500);
            }
        });
        int maxWidth = Math.max(zoomToFitBtn.getBounds().width, Math.max(zoomToFocusBtn.getBounds().width, zoomToOneBtn.getBounds().width));
        int maxHeight = Math.max(zoomToFitBtn.getBounds().height, Math.max(zoomToFocusBtn.getBounds().height, zoomToOneBtn.getBounds().height));
        zoomToFitBtn.setSize(maxWidth, maxHeight);
        zoomToFocusBtn.setSize(maxWidth, maxHeight);
        zoomToOneBtn.setSize(maxWidth, maxHeight);
    }

    public void updateOptions(Composite diagramComposite, ViewContext theViewContext, boolean fitSpace) {
        IAction action;
        this.viewContext = theViewContext;
        if (diagramComposite.isDisposed()) {
            return;
        }
        this.actionControlFactory.clear();
        boolean actionsAvailable = false;
        LinkedHashSet allActionData = new LinkedHashSet();
        allActionData.addAll(this.viewContext.getDisplayedActions());
        if (!this.viewContext.getChildViewContexts(false).isEmpty()) {
            for (ViewContext childVC : this.viewContext.getChildViewContexts(true)) {
                allActionData.addAll(childVC.getDisplayedActions());
            }
        }
        for (DisplayedActionData actionData : allActionData) {
            this.actionControlFactory.createActionControl(actionData, theViewContext);
            actionsAvailable = true;
        }
        IViewer viewer = this.viewContext.getViewer();
        if (actionsAvailable) {
            viewer.getContextViewer().addSelectionChangedListener((ISelectionChangedListener)this.actionControlFactory);
            viewer.addViewChangeListener((IViewChangeListener)this.actionControlFactory, ViewChangeType.clipCollapseExpandHideShow());
        } else {
            viewer.getContextViewer().removeSelectionChangedListener((ISelectionChangedListener)this.actionControlFactory);
            viewer.removeViewChangeListener((IViewChangeListener)this.actionControlFactory);
        }
        this.synthesisOptionControlFactory.clear();
        boolean synthesisOptionsAvailable = false;
        if (!this.viewContext.getChildViewContexts(false).isEmpty()) {
            LinkedHashSet<ISynthesis> allSyntheses = new LinkedHashSet<ISynthesis>();
            allSyntheses.add(this.viewContext.getDiagramSynthesis());
            for (ViewContext childVC : this.viewContext.getChildViewContexts(true)) {
                allSyntheses.add(childVC.getDiagramSynthesis());
            }
            for (ISynthesis synthesis : allSyntheses) {
                if (synthesis == null) continue;
                SynthesisOptionControlFactory subFactory = this.synthesisOptionControlFactory.createSubSynthesisOptionControlFactory(synthesis);
                for (SynthesisOption option : synthesis.getDisplayedSynthesisOptions()) {
                    synthesisOptionsAvailable |= subFactory.createOptionControl(option, this.viewContext);
                }
            }
        } else {
            for (SynthesisOption option : this.viewContext.getDisplayedSynthesisOptions()) {
                synthesisOptionsAvailable |= this.synthesisOptionControlFactory.createOptionControl(option, this.viewContext);
            }
        }
        this.layoutOptionControlFactory.clear();
        this.layoutOptionControlFactory.initialize(this.viewContext);
        boolean layoutOptionsAvailable = false;
        for (Pair pair : this.viewContext.getDisplayedLayoutOptions()) {
            Object second;
            Object first;
            if (pair.getSecond() instanceof Collection) {
                Iterator it = ((Collection)pair.getSecond()).iterator();
                first = it.hasNext() ? it.next() : null;
                second = it.hasNext() ? it.next() : null;
            } else {
                first = null;
                second = null;
            }
            if (first instanceof Number && second instanceof Number) {
                this.layoutOptionControlFactory.createControl(((IProperty)pair.getFirst()).getId(), Float.valueOf(((Number)first).floatValue()), Float.valueOf(((Number)second).floatValue()));
                layoutOptionsAvailable = true;
                continue;
            }
            if (pair.getSecond() == null) {
                this.layoutOptionControlFactory.createControl(((IProperty)pair.getFirst()).getId());
                layoutOptionsAvailable = true;
                continue;
            }
            this.layoutOptionControlFactory.createControl(((IProperty)pair.getFirst()).getId(), (Collection)pair.getSecond());
            layoutOptionsAvailable = true;
        }
        boolean sideBarEnabled = this.enableOptionsSideBar(fitSpace, actionsAvailable, synthesisOptionsAvailable, layoutOptionsAvailable);
        this.updateZoomButtons(sideBarEnabled);
        IDiagramWorkbenchPart part = this.viewContext.getDiagramWorkbenchPart();
        if (part instanceof DiagramViewPart && (action = ((DiagramViewPart)part).getAction("de.cau.cs.kieler.klighd.ui.parts.DiagramViewPart.resetLayoutOptions")) != null) {
            action.setEnabled(layoutOptionsAvailable);
        }
    }

    private void updateZoomButtons(boolean sideBarEnabled) {
        if (!this.zoomButtonsVisible) {
            return;
        }
        if (this.canvasZoomBtnsContainer != null) {
            this.canvasZoomBtnsContainer.setVisible(!sideBarEnabled);
        }
        if (sideBarEnabled) {
            this.updateZoomButtonSelection(this.sideZoomBtnsForm.getBody());
            return;
        }
        if (this.viewContext.getViewer().getControl() instanceof Composite && this.canvasZoomBtnsContainer == null) {
            final Composite canvas = (Composite)this.viewContext.getViewer().getControl();
            canvas.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    DiagramSideBar.this.canvasZoomBtnsContainer = null;
                }
            });
            this.canvasZoomBtnsContainer = new Composite(canvas, 524288);
            Color white = new Color((Device)Display.getCurrent(), KlighdConstants.WHITE);
            this.resources.add((Resource)white);
            this.canvasZoomBtnsContainer.setBackground(white);
            this.initializeZoomButtons(this.canvasZoomBtnsContainer);
            this.canvasZoomBtnsContainer.pack();
            Point canvasSize = canvas.getSize();
            Point buttonBarSize = this.canvasZoomBtnsContainer.getSize();
            this.canvasZoomBtnsContainer.setLocation(canvasSize.x - buttonBarSize.x - 3, 3);
            canvas.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Point canvasSize = canvas.getSize();
                    Point buttonBarSize = DiagramSideBar.this.canvasZoomBtnsContainer.getSize();
                    DiagramSideBar.this.canvasZoomBtnsContainer.setLocation(canvasSize.x - buttonBarSize.x - 3, 3);
                }
            });
        }
        this.updateZoomButtonSelection(this.canvasZoomBtnsContainer);
    }

    private void updateZoomButtonSelection(Composite container) {
        Control[] controlArray = container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control button = controlArray[n2];
            Object type = button.getData(BUTTON_TYPE);
            if (ZoomStyle.ZOOM_TO_FIT == type) {
                ((Button)button).setSelection(this.viewContext.isZoomToFit());
            } else if (ZoomStyle.getZoomToFocusStyle() == type) {
                ((Button)button).setSelection(this.viewContext.isZoomToFocus());
            }
            ++n2;
        }
    }

    private boolean enableOptionsSideBar(boolean zoomToFit, boolean showActions, boolean showSynthesisOptions, boolean showLayoutOptions) {
        boolean enabled;
        if (showActions || showSynthesisOptions || showLayoutOptions) {
            for (Control c : this.sideBarControls) {
                if (c == this.actionsForm) {
                    c.setVisible(showActions);
                    continue;
                }
                if (c == this.synthesisOptionsForm) {
                    c.setVisible(showSynthesisOptions);
                    continue;
                }
                if (c == this.layoutOptionsForm) {
                    c.setVisible(showLayoutOptions);
                    continue;
                }
                c.setVisible(true);
            }
            if (showSynthesisOptions) {
                ((FormData)this.synthesisOptionsForm.getLayoutData()).top = showActions ? new FormAttachment((Control)this.actionsForm, 20) : new FormAttachment(0);
                ((FormData)this.layoutOptionsForm.getLayoutData()).top = new FormAttachment((Control)this.synthesisOptionsForm, 20);
            } else {
                ((FormData)this.layoutOptionsForm.getLayoutData()).top = showActions ? new FormAttachment((Control)this.actionsForm, 20) : new FormAttachment(0);
            }
            if (this.sashLayoutData != null) {
                this.sashLayoutData.left.numerator = 100;
                this.sashLayoutData.left.offset = this.horizontalPos;
            }
            enabled = true;
        } else {
            for (Control c : this.sideBarControls) {
                c.setVisible(false);
            }
            if (this.sashLayoutData != null) {
                if (this.sashLayoutData.left.offset != 0) {
                    this.horizontalPos = this.sashLayoutData.left.offset;
                }
                this.sashLayoutData.left.numerator = 100;
                this.sashLayoutData.left.offset = 0;
            }
            enabled = false;
        }
        if (!this.sideBarParent.isDisposed()) {
            this.scrolledRootForm.reflow(true);
            this.sideBarParent.layout(true, true);
        }
        if (zoomToFit) {
            this.viewContext.getViewer().zoom(ZoomStyle.ZOOM_TO_FIT, 0);
        }
        return enabled;
    }

    public void resetLayoutOptionsToDefaults(boolean doLayout) {
        this.layoutOptionControlFactory.resetToDefaults(doLayout);
    }

    public void dispose() {
        if (this.optionsformToolkit != null) {
            this.optionsformToolkit.dispose();
            this.optionsformToolkit = null;
        }
        for (Resource res : this.resources) {
            res.dispose();
        }
        this.resources.clear();
        this.viewContext = null;
        this.layoutOptionControlFactory = null;
        this.synthesisOptionControlFactory = null;
    }

    private final class LinePainter
    implements PaintListener {
        private LinePainter() {
        }

        public void paintControl(PaintEvent event) {
            Point size = ((Control)event.widget).getSize();
            event.gc.setForeground(Display.getCurrent().getSystemColor(18));
            event.gc.drawLine(event.width / 2, 0, event.width / 2, size.y);
        }
    }
}

