/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.options;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.DisplayedActionData;
import de.cau.cs.kieler.klighd.IAction;
import de.cau.cs.kieler.klighd.IKlighdSelection;
import de.cau.cs.kieler.klighd.IViewChangeListener;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.KlighdTreeSelection;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.util.Iterables2;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ActionControlFactory
implements ISelectionChangedListener,
IViewChangeListener {
    private Composite parent;
    private FormToolkit formToolkit;
    private final Collection<Control> controls = new LinkedList<Control>();
    private static final int MAJOR_VERTICAL_SPACING = 6;
    private Map<DisplayedActionData, Control> actionDataControlMap = Maps.newHashMap();

    public ActionControlFactory(Composite parent, FormToolkit formToolkit) {
        this.parent = parent;
        this.formToolkit = formToolkit;
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 6;
        this.parent.setLayout((Layout)gl);
    }

    public void clear() {
        for (Control c : this.controls) {
            c.dispose();
        }
        this.controls.clear();
        this.actionDataControlMap.clear();
    }

    public void createActionControl(final DisplayedActionData actionData, final ViewContext viewContext) {
        Button button = new Button(this.parent, 8);
        button.setText(actionData.displayedName);
        button.setToolTipText(actionData.tooltipText);
        if (actionData.image != null) {
            button.setImage(actionData.image);
        }
        this.formToolkit.adapt((Control)button, true, true);
        this.controls.add((Control)button);
        if (actionData.enablementTester == null) {
            button.setEnabled(true);
        } else {
            this.actionDataControlMap.put(actionData, (Control)button);
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IAction action = KlighdDataManager.getInstance().getActionById(actionData.actionId);
                IViewer viewer = viewContext.getViewer();
                IAction.ActionResult result = null;
                boolean anyActionPerformed = false;
                boolean anyActionRequiresSynthesis = false;
                viewContext.getLayoutRecorder().startRecording();
                KlighdTreeSelection diagramSelection = viewer.getDiagramSelection();
                if (diagramSelection.isEmpty()) {
                    result = action.execute(new IAction.ActionContext(viewer, null, (KGraphElement)viewer.getViewContext().getViewModel(), null));
                    anyActionPerformed = result.getActionPerformed();
                    anyActionRequiresSynthesis = result.getNeedsSynthesis();
                } else {
                    for (EObject e : Iterables2.toIterable((Iterator)diagramSelection.diagramElementsIterator())) {
                        IAction.ActionContext aContext;
                        if (e instanceof KGraphElement) {
                            aContext = new IAction.ActionContext(viewer, null, (KGraphElement)e, null);
                        } else {
                            if (!(e instanceof KRendering)) continue;
                            aContext = new IAction.ActionContext(viewer, null, null, (KRendering)e);
                        }
                        IAction.ActionResult res = action.execute(aContext);
                        if (res == null) continue;
                        result = res;
                        anyActionPerformed |= res.getActionPerformed();
                        anyActionRequiresSynthesis |= res.getNeedsSynthesis();
                    }
                }
                if (anyActionRequiresSynthesis) {
                    viewContext.update();
                }
                if (anyActionPerformed) {
                    new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(result.getAnimateLayout())).zoomStyle(ZoomStyle.create((IAction.ActionResult)result, (ViewContext)viewContext)).focusElement(result.getFocusElement()).previousPosition(result.getPreviousPosition()).options(result.getLayoutConfigs()).performLayout();
                } else {
                    viewContext.getLayoutRecorder().stopRecording(ZoomStyle.NONE, null, 0);
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof IKlighdSelection)) {
            return;
        }
        this.updateControls((IKlighdSelection)event.getSelection());
    }

    public void viewChanged(IViewChangeListener.ViewChange change) {
        this.updateControls(change.getViewer().getSelection());
    }

    private void updateControls(IKlighdSelection selection) {
        for (Map.Entry<DisplayedActionData, Control> entry : this.actionDataControlMap.entrySet()) {
            entry.getValue().setEnabled(entry.getKey().enablementTester.apply((Object)selection));
        }
    }
}

