/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.handlers;

import de.cau.cs.kieler.klighd.IDiagramExporter;
import de.cau.cs.kieler.klighd.ui.internal.Messages;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class TilingDialog
extends Dialog {
    private IDiagramExporter.TilingData info;
    private Spinner spinnerX;
    private Spinner spinnerY;
    private Spinner spinnerWidth;
    private Spinner spinnerHeight;
    private LinkedList<Control> rowsColsGroup;
    private LinkedList<Control> maxSizeGroup;
    private Button rowsColsButton;
    private Button maxSizeButton;
    private static final int GROUP_COLUMNS = 4;
    private static final int SPINNER_WIDTH = 50;

    public TilingDialog(Shell parentShell, IDiagramExporter.TilingData info) {
        super(parentShell);
        this.setShellStyle(67680);
        this.info = info;
        this.rowsColsGroup = new LinkedList();
        this.maxSizeGroup = new LinkedList();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TilingDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = this.createComposite(area, 4);
        this.rowsColsButton = new Button(composite, 16);
        this.rowsColsButton.setText("Define number of rows and columns");
        this.rowsColsButton.setSelection(!this.info.isMaxsize);
        this.rowsColsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TilingDialog.this.updateEnabledState(false);
            }
        });
        GridData gridData = new GridData(0);
        gridData.horizontalSpan = 4;
        this.rowsColsButton.setLayoutData((Object)gridData);
        this.addRowsColsGroup(composite);
        this.maxSizeButton = new Button(composite, 16);
        this.maxSizeButton.setText("Define maximum size");
        this.maxSizeButton.setSelection(this.info.isMaxsize);
        this.maxSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TilingDialog.this.updateEnabledState(true);
            }
        });
        gridData = new GridData(0);
        gridData.horizontalSpan = 4;
        this.maxSizeButton.setLayoutData((Object)gridData);
        this.addMaxSizeGroup(composite);
        Button resetButton = new Button(area, 8);
        resetButton.setText("Reset");
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TilingDialog.this.info = IDiagramExporter.TilingData.createNonTiledData();
                TilingDialog.this.updateSpinnerSelections();
                TilingDialog.this.rowsColsButton.setSelection(!TilingDialog.this.info.isMaxsize);
                TilingDialog.this.maxSizeButton.setSelection(TilingDialog.this.info.isMaxsize);
                TilingDialog.this.updateEnabledState(TilingDialog.this.info.isMaxsize);
            }
        });
        this.updateSpinnerSelections();
        this.updateEnabledState(this.info.isMaxsize);
        return composite;
    }

    private void updateEnabledState(boolean isMaxSize) {
        for (Control control : this.rowsColsGroup) {
            control.setEnabled(!isMaxSize);
        }
        for (Control control : this.maxSizeGroup) {
            control.setEnabled(isMaxSize);
        }
    }

    private void updateSpinnerSelections() {
        this.spinnerX.setSelection(this.info.rows);
        this.spinnerY.setSelection(this.info.cols);
        this.spinnerWidth.setSelection(this.info.maxWidth);
        this.spinnerHeight.setSelection(this.info.maxHeight);
    }

    private void addRowsColsGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Rows:");
        this.rowsColsGroup.add((Control)label);
        this.spinnerX = new Spinner(parent, 0);
        this.rowsColsGroup.add((Control)this.spinnerX);
        label = new Label(parent, 0);
        label.setText("Columns:");
        this.rowsColsGroup.add((Control)label);
        this.spinnerY = new Spinner(parent, 0);
        this.rowsColsGroup.add((Control)this.spinnerY);
        this.spinnerX.setMinimum(1);
        this.spinnerX.setMaximum(Integer.MAX_VALUE);
        this.spinnerY.setMinimum(1);
        this.spinnerY.setMaximum(Integer.MAX_VALUE);
        GridData gridData = new GridData(0);
        gridData.widthHint = 50;
        this.spinnerX.setLayoutData((Object)gridData);
        this.spinnerY.setLayoutData((Object)gridData);
    }

    private void addMaxSizeGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Width:");
        this.maxSizeGroup.add((Control)label);
        this.spinnerWidth = new Spinner(parent, 0);
        this.maxSizeGroup.add((Control)this.spinnerWidth);
        label = new Label(parent, 0);
        label.setText("Height:");
        this.maxSizeGroup.add((Control)label);
        this.spinnerHeight = new Spinner(parent, 0);
        this.maxSizeGroup.add((Control)this.spinnerHeight);
        this.spinnerWidth.setMinimum(1);
        this.spinnerWidth.setMaximum(Integer.MAX_VALUE);
        this.spinnerHeight.setMinimum(1);
        this.spinnerHeight.setMaximum(Integer.MAX_VALUE);
        GridData gridData = new GridData(0);
        gridData.widthHint = 50;
        this.spinnerWidth.setLayoutData((Object)gridData);
        this.spinnerHeight.setLayoutData((Object)gridData);
    }

    private Composite createComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData data = new GridData(4, 0, true, false);
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    public IDiagramExporter.TilingData getTilingInfo() {
        return this.info;
    }

    protected void okPressed() {
        this.info = this.rowsColsButton.getSelection() ? IDiagramExporter.TilingData.createTiledData((int)this.spinnerX.getSelection(), (int)this.spinnerY.getSelection()) : IDiagramExporter.TilingData.createMaxSizeTiledData((int)this.spinnerWidth.getSelection(), (int)this.spinnerHeight.getSelection());
        super.okPressed();
    }
}

