/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.handlers;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdTreeSelection;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.ui.internal.handlers.ExportKGraphHelper;
import de.cau.cs.kieler.klighd.ui.internal.handlers.SaveKGraphDialog;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveKGraphHandler
extends AbstractHandler {
    private static final String EXPORT_TYPE_ID = "de.cau.cs.kieler.klighd.ui.saveKGraph.exportType";
    private static final String EXPORT_TYPE_SINGLE = "single";
    private static final String EXPORT_TYPE_CHUNKY = "chunky";
    private static final String[] KGRAPH_FILE_EXTENSIONS = new String[]{".kgx"};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        KlighdTreeSelection selection;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof IDiagramWorkbenchPart)) {
            return null;
        }
        IViewer viewer = ((IDiagramWorkbenchPart)part).getViewer();
        ISelection s = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (s instanceof KlighdTreeSelection) {
            selection = (KlighdTreeSelection)s;
        } else {
            if (s != null) return null;
            s = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (!(s instanceof KlighdTreeSelection)) return null;
            selection = (KlighdTreeSelection)s;
        }
        ViewContext viewContext = selection.getViewContext();
        if (viewContext == null) {
            Klighd.show((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", "Could not determine ViewContext."));
        }
        if (selection.isEmpty()) {
            Klighd.show((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", "Please select something to export."));
            return null;
        }
        KNode subgraph = selection.size() == 1 && selection.getFirstElement() instanceof KNode ? (KNode)selection.getFirstElement() : viewContext.getViewModel();
        Shell shell = Display.getCurrent().getActiveShell();
        String exportType = event.getParameter(EXPORT_TYPE_ID);
        if (exportType.equals(EXPORT_TYPE_SINGLE)) {
            SaveKGraphDialog fd = new SaveKGraphDialog(viewer.getControl().getShell());
            int success = fd.open();
            if (success != 0) return null;
            IPath file = fd.getFilePath();
            if (Arrays.stream(KGRAPH_FILE_EXTENSIONS).noneMatch(ext -> file.toOSString().endsWith((String)ext))) {
                file.addFileExtension(KGRAPH_FILE_EXTENSIONS[0]);
            }
            URI uri = null;
            uri = fd.isWorkspacePath() ? URI.createPlatformResourceURI((String)file.toOSString(), (boolean)true) : URI.createFileURI((String)file.toOSString());
            ExportKGraphHelper.export(subgraph, uri, fd.protectIP(), false);
            String title = "Diagram export successful.";
            String msg = "KLighD diagram export finished successfully.";
            MessageDialog.openInformation((Shell)shell, (String)"Diagram export successful.", (String)"KLighD diagram export finished successfully.");
            return null;
        } else {
            ContainerSelectionDialog csd;
            int success;
            if (!exportType.equals(EXPORT_TYPE_CHUNKY) || (success = (csd = new ContainerSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "")).open()) != 0) return null;
            IPath container = (IPath)csd.getResult()[0];
            String destination = container.toOSString().toString();
            this.exportRecursivelyChunky(subgraph, destination, viewContext);
        }
        return null;
    }

    private void exportRecursivelyChunky(KNode subgraph, String destination, ViewContext viewContext) {
        URI uri;
        String filename;
        LinkedList flatNodes = Lists.newLinkedList();
        LinkedList expandedNodes = Lists.newLinkedList();
        String path = String.valueOf(destination) + File.separator;
        flatNodes.add(subgraph);
        expandedNodes.add(subgraph);
        while (!flatNodes.isEmpty()) {
            KNode n = (KNode)flatNodes.poll();
            if (n.getChildren().size() > 1) {
                String filename2 = "flat_" + this.getModelPathName(n, viewContext) + KGRAPH_FILE_EXTENSIONS[0];
                System.out.println("Exporting: " + filename2);
                Iterator uri2 = URI.createPlatformResourceURI((String)(String.valueOf(path) + filename2), (boolean)true);
                ExportKGraphHelper.export(n, (URI)uri2, false, true);
            }
            for (KNode child : n.getChildren()) {
                if (child.getChildren().isEmpty()) continue;
                viewContext.getViewer().expand(child);
                flatNodes.add(child);
                expandedNodes.add(child);
            }
            if (n.getChildren().isEmpty()) continue;
            new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(false)).performLayout();
        }
        for (KNode node : expandedNodes) {
            if (node == subgraph) continue;
            viewContext.getViewer().collapse(node);
        }
        LinkedList increaseHierarchy = Lists.newLinkedList();
        increaseHierarchy.add(subgraph);
        new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(false)).performLayout();
        int i = 0;
        int requiredPaddingZeroes = (int)Math.ceil(Math.log(expandedNodes.size()) / Math.log(10.0));
        do {
            KNode toExpand = (KNode)increaseHierarchy.poll();
            viewContext.getViewer().expand(toExpand);
            new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(false)).performLayout();
            filename = "inchierarchy_" + this.getModelPathName(subgraph, viewContext) + "_" + String.format("%0" + requiredPaddingZeroes + "d", i++) + KGRAPH_FILE_EXTENSIONS[0];
            System.out.println("Exporting: " + filename);
            uri = URI.createPlatformResourceURI((String)(String.valueOf(path) + filename), (boolean)true);
            ExportKGraphHelper.export(subgraph, uri, false, false);
            for (KNode child : toExpand.getChildren()) {
                if (child.getChildren().isEmpty()) continue;
                increaseHierarchy.add(child);
            }
        } while (!increaseHierarchy.isEmpty());
        while (!expandedNodes.isEmpty()) {
            KNode n = (KNode)expandedNodes.poll();
            if (n.getChildren().size() <= 1) continue;
            filename = String.valueOf(this.getModelPathName(n, viewContext)) + KGRAPH_FILE_EXTENSIONS[0];
            System.out.println("Exporting: " + filename);
            uri = URI.createPlatformResourceURI((String)(String.valueOf(path) + "expanded_" + filename), (boolean)true);
            ExportKGraphHelper.export(n, uri, false, false);
            uri = URI.createPlatformResourceURI((String)(String.valueOf(path) + "expanded_flat_" + filename), (boolean)true);
            ExportKGraphHelper.export(n, uri, false, true);
        }
    }

    private String getModelPathName(KNode node, ViewContext vc) {
        String s = "";
        KNode parent = node;
        while (parent != null) {
            String name = parent.toString().replace("\"", "").replace(" ", "").replace("KNode", "");
            name = name.replace("de.cau.cs.kieler.klighd.kgraph.impl.Impl", "Node");
            s = "-" + name + s;
            parent = parent.getParent();
        }
        s = s.substring(1);
        if (vc != null && vc.getDiagramWorkbenchPart() != null) {
            s = String.valueOf(vc.getDiagramWorkbenchPart().getTitle()) + "-" + s;
        }
        return s;
    }
}

