/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.handlers;

import de.cau.cs.kieler.klighd.ui.KlighdUIPlugin;
import de.cau.cs.kieler.klighd.ui.internal.Messages;
import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class SaveKGraphDialog
extends Dialog {
    private static final String PREFERENCE_FILE_PATH = "exportUnderlyingKGraphDialog.filePath";
    private static final String PREFERENCE_WORKSPACE_PATH = "exportUnderlyingKGraphDialog.workspacePath";
    private static final String PREFERENCE_PROTECT_IP = "exportUnderlyingKGraphDialog.protectIP";
    private static final String[] EXTENSIONS = new String[]{"kgx"};
    private static final String[] DESCRIPTIONS = new String[]{"KGraph XMI"};
    private final IPreferenceStore preferenceStore = KlighdUIPlugin.getDefault().getPreferenceStore();
    private Text fileText;
    private Button workspacePathCheckbox;
    private Button ipProtectCheckbox;
    private IPath resultPath = null;
    private Boolean isWorkspacePath = false;
    private Boolean protectIP;
    private static final int FILE_GROUP_COLUMNS = 3;
    private static final int FILE_TEXT_WIDTH_HINT = 300;
    private static final int BROWSE_WIDTH_HINT = 150;

    public SaveKGraphDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateFileText();
        this.validateFileText();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createExportGroup(composite);
        return composite;
    }

    private void createExportGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 3);
        Label label = new Label(composite, 0);
        label.setText(Messages.ExportUnderlyingKGraphDialog_file_caption);
        this.fileText = new Text(composite, 2048);
        this.fileText.setText(this.preferenceStore.getString(PREFERENCE_FILE_PATH));
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveKGraphDialog.this.validateFileText();
            }
        });
        GridData gridData = new GridData(4, 0, true, false);
        gridData.widthHint = 300;
        this.fileText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText(Messages.ExportUnderlyingKGraphDialog_browse_workspace_caption);
        gridData = new GridData(131072, 0, true, false);
        gridData.widthHint = 150;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveKGraphDialog.this.handleWorkspaceBrowse();
            }
        });
        this.workspacePathCheckbox = new Button(composite, 16416);
        this.workspacePathCheckbox.setText(Messages.ExportUnderlyingKGraphDialog_is_workspace_path_caption);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        this.workspacePathCheckbox.setLayoutData((Object)gridData);
        this.workspacePathCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_WORKSPACE_PATH));
        this.workspacePathCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveKGraphDialog.this.validateFileText();
            }
        });
        button = new Button(composite, 8);
        button.setText(Messages.ExportUnderlyingKGraphDialog_browse_file_system_caption);
        gridData = new GridData(131072, 0, true, false);
        gridData.widthHint = 150;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveKGraphDialog.this.handleFileSystemBrowse();
            }
        });
        this.ipProtectCheckbox = new Button(composite, 16416);
        this.ipProtectCheckbox.setText(Messages.ExportUnderlyingKGraphDialog_protectIP);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        this.ipProtectCheckbox.setLayoutData((Object)gridData);
        this.ipProtectCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_PROTECT_IP));
        this.ipProtectCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveKGraphDialog.this.preferenceStore.setValue(SaveKGraphDialog.PREFERENCE_PROTECT_IP, SaveKGraphDialog.this.ipProtectCheckbox.getSelection());
            }
        });
    }

    private void validateFileText() {
        if (this.fileText.getText().length() > 0 && Path.ROOT.isValidPath(this.fileText.getText())) {
            Path filePath = new Path(this.fileText.getText());
            IPath containerPath = filePath.removeLastSegments(1);
            if (filePath.hasTrailingSeparator()) {
                this.setErrorStatus(Messages.ExportUnderlyingKGraphDialog_path_is_not_valid_error);
                return;
            }
            if (this.workspacePathCheckbox.getSelection()) {
                if (containerPath.segmentCount() == 0) {
                    this.setErrorStatus(Messages.ExportUnderlyingKGraphDialog_file_outside_project_error);
                    return;
                }
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IResource resource = root.findMember((IPath)filePath);
                if (resource != null && resource.exists() && resource instanceof IContainer) {
                    this.setErrorStatus(Messages.ExportUnderlyingKGraphDialog_path_is_not_valid_error);
                    return;
                }
                resource = root.findMember(containerPath);
                if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
                    this.setErrorStatus(Messages.ExportUnderlyingKGraphDialog_container_not_exist_error);
                    return;
                }
            } else {
                File file = new File(filePath.toString());
                if (file.isDirectory()) {
                    this.setErrorStatus(Messages.ExportUnderlyingKGraphDialog_path_is_not_valid_error);
                    return;
                }
                File container = new File(containerPath.toString());
                if (!container.exists()) {
                    this.setErrorStatus(Messages.ExportUnderlyingKGraphDialog_container_not_exist_error);
                    return;
                }
            }
        } else {
            this.setErrorStatus(Messages.ExportUnderlyingKGraphDialog_path_is_not_valid_error);
            return;
        }
        this.setOKStatus();
    }

    private void handleWorkspaceBrowse() {
        SaveAsDialog fileDialog = new SaveAsDialog(this.getShell());
        int status = fileDialog.open();
        if (status == 0) {
            IPath filePath = fileDialog.getResult();
            String ext = filePath.getFileExtension();
            this.workspacePathCheckbox.setSelection(true);
            if (ext == null) {
                this.fileText.setText(String.valueOf(filePath.toOSString()) + "." + EXTENSIONS[0]);
            } else {
                this.fileText.setText(filePath.toOSString());
            }
        }
    }

    private void handleFileSystemBrowse() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setOverwrite(true);
        String[] newExt = new String[EXTENSIONS.length];
        int i = 0;
        while (i < EXTENSIONS.length) {
            String ext = EXTENSIONS[i];
            newExt[i] = ext.charAt(0) == '.' ? ext : String.valueOf('.') + ext;
            ++i;
        }
        String[] extensions = newExt;
        fileDialog.setFilterExtensions(extensions);
        fileDialog.setFilterNames(DESCRIPTIONS);
        fileDialog.setText(Messages.ExportUnderlyingKGraphDialog_save_as_caption);
        String selectedFile = fileDialog.open();
        if (selectedFile != null) {
            this.workspacePathCheckbox.setSelection(false);
            this.fileText.setText(selectedFile);
        }
    }

    private void updateFileText() {
        if (this.fileText.getText().length() > 0 && Path.ROOT.isValidPath(this.fileText.getText())) {
            Path filePath = new Path(this.fileText.getText());
            if (filePath.getFileExtension() != null) {
                if (Arrays.stream(EXTENSIONS).noneMatch(arg_0 -> SaveKGraphDialog.lambda$0((IPath)filePath, arg_0))) {
                    this.fileText.setText(filePath.removeFileExtension().addFileExtension(EXTENSIONS[0]).toString());
                }
            } else {
                this.fileText.setText(filePath.addFileExtension(EXTENSIONS[0]).toString());
            }
        }
    }

    private void setErrorStatus(String message) {
        this.getButton(0).setEnabled(false);
        this.getButton(1).getShell().setDefaultButton(this.getButton(1));
    }

    private void setOKStatus() {
        this.getButton(0).setEnabled(true);
        this.getButton(0).getShell().setDefaultButton(this.getButton(0));
    }

    private Composite createComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData data = new GridData(4, 0, true, false);
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ExportUnderlyingKGraphDialog_title);
    }

    protected IPath getFilePath() {
        return this.resultPath;
    }

    protected boolean isWorkspacePath() {
        return this.isWorkspacePath;
    }

    protected boolean protectIP() {
        return this.protectIP;
    }

    public boolean close() {
        this.preferenceStore.setValue(PREFERENCE_FILE_PATH, this.fileText.getText());
        this.preferenceStore.setValue(PREFERENCE_WORKSPACE_PATH, this.workspacePathCheckbox.getSelection());
        return super.close();
    }

    protected void okPressed() {
        this.updateFileText();
        this.resultPath = new Path(this.fileText.getText());
        this.isWorkspacePath = this.workspacePathCheckbox.getSelection();
        this.protectIP = this.ipProtectCheckbox.getSelection();
        super.okPressed();
    }

    private static /* synthetic */ boolean lambda$0(IPath iPath, String ext) {
        return iPath.getFileExtension().equals(ext);
    }
}

