/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.handlers;

import de.cau.cs.kieler.klighd.IDiagramExporter;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.ui.internal.handlers.SaveAsImageDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveAsImageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String msg;
        IStatus res;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof IDiagramWorkbenchPart)) {
            return null;
        }
        IViewer viewer = ((IDiagramWorkbenchPart)part).getViewer();
        Shell shell = viewer.getControl().getShell();
        SaveAsImageDialog dialog = new SaveAsImageDialog(viewer.getViewContext(), shell);
        int code = dialog.open();
        if (code != 0 || dialog.getCurrentExporter() == null) {
            return null;
        }
        IDiagramExporter exporter = KlighdDataManager.getInstance().getExporter(dialog.getCurrentExporter().exporterId);
        try {
            res = exporter.export(viewer.getControl(), dialog.getExportData());
        }
        catch (Throwable t) {
            msg = "The diagram export could not be completed.";
            res = new Status(4, "de.cau.cs.kieler.klighd.ui", "The diagram export could not be completed.", t);
        }
        if (res == Status.OK_STATUS) {
            String title = "Diagram export successful.";
            msg = "KLighD diagram export finished successfully.";
            MessageDialog.openInformation((Shell)shell, (String)"Diagram export successful.", (String)"KLighD diagram export finished successfully.");
            return null;
        }
        if (res == null) {
            String msg2 = "KLighD diagram export: " + exporter.getClass().getCanonicalName() + " must return an IStatus!";
            Klighd.show((IStatus)new Status(2, "de.cau.cs.kieler.klighd.ui", msg2));
        } else if (res.getException() instanceof OutOfMemoryError) {
            String title = "Out of heap memory.";
            msg = "Diagram image could not be exported due to heap space overflow. Retry tiled export with more or smaller image tiles.";
            MessageDialog.openError((Shell)shell, (String)"Out of heap memory.", (String)"Diagram image could not be exported due to heap space overflow. Retry tiled export with more or smaller image tiles.");
        } else {
            Klighd.getStatusManager().handle(res, 7);
        }
        return null;
    }
}

