/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.handlers;

import com.google.common.base.Strings;
import de.cau.cs.kieler.klighd.IDiagramExporter;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ui.KlighdUIPlugin;
import de.cau.cs.kieler.klighd.ui.internal.Messages;
import de.cau.cs.kieler.klighd.ui.internal.handlers.TilingDialog;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class SaveAsImageDialog
extends Dialog {
    private static final String PREFERENCE_FILE_PATH = "saveAsImageDialog.filePath";
    private static final String PREFERENCE_WORKSPACE_PATH = "saveAsImageDialog.workspacePath";
    private static final String PREFERENCE_IMAGE_FORMAT = "saveAsImageDialog.imageFormat";
    private static final String PREFERENCE_CAMERA_VIEWPORT = "saveAsImageDialog.cameraViewport";
    private static final String PREFERENCE_CAMERA_ZOOM_LEVEL = "saveAsImageDialog.cameraZoomLevel";
    private static final String PREFERENCE_SCALE_FACTOR = "saveAsImageDialog.scaleFactor";
    private static final String PREFERENCE_TEXT_AS_SHAPES = "saveAsImageDialog.textAsShapes";
    private static final String PREFERENCE_EMBED_FONTS = "saveAsImageDialog.embedFonts";
    private static final String PREFERENCE_SET_TEXT_LENGTHS = "saveAsImageDialog.setTextLengths";
    private static final String PREFERENCE_TRANSPARENT_BACKGROUND = "saveAsImageDialog.embedFonts";
    private static final String PREFERENCE_TILING_IS_MAXSIZE = "saveAsImageDialog.tilingIsMaxsize";
    private static final String PREFERENCE_TILING_X = "saveAsImageDialog.tilingX";
    private static final String PREFERENCE_TILING_Y = "saveAsImageDialog.tilingY";
    private final IPreferenceStore preferenceStore = KlighdUIPlugin.getDefault().getPreferenceStore();
    private final ViewContext viewContext;
    private Text fileText;
    private Button workspacePathCheckbox;
    private Combo imageFormatCombo;
    private Button tilingOptionsButton;
    private Label tilingStateLabel;
    private Button cameraViewportCheckbox;
    private Button cameraZoomLevelCheckbox;
    private Button transparentBackgroundCheckbox;
    private Button textAsShapesCheckbox;
    private Button embedFontsCheckbox;
    private Button setTextLengthsCheckbox;
    private Label messageImageLabel;
    private Label messageLabel;
    private Scale scaleSlider;
    private IDiagramExporter.ExportData exportData;
    private IDiagramExporter.TilingData tilingInfo;
    private List<KlighdDataManager.ExporterDescriptor> descriptors;
    private KlighdDataManager.ExporterDescriptor currentExporter;
    private static final int FILE_GROUP_COLUMNS = 3;
    private static final int FILE_TEXT_WIDTH_HINT = 300;
    private static final int BROWSE_WIDTH_HINT = 150;
    private static final int IMAGE_FORMAT_GROUP_COLUMNS = 4;
    private static final int IMAGE_FORMAT_COMBO_WIDTH_HINT = 210;
    private static final int IMAGE_FORMAT_SLIDER_MAX = 16;
    private static final int MESSAGE_LABEL_WIDTH_HINT = 300;

    public SaveAsImageDialog(ViewContext viewContext, Shell parentShell) {
        super(parentShell);
        this.preferenceStore.setDefault(PREFERENCE_SET_TEXT_LENGTHS, true);
        this.viewContext = viewContext;
        this.descriptors = KlighdDataManager.getInstance().getAvailableExporters();
        Collections.sort(this.descriptors, new Comparator<KlighdDataManager.ExporterDescriptor>(){

            @Override
            public int compare(KlighdDataManager.ExporterDescriptor e1, KlighdDataManager.ExporterDescriptor e2) {
                return e1.fileExtension.compareTo(e2.fileExtension);
            }
        });
        this.tilingInfo = this.preferenceStore.getBoolean(PREFERENCE_TILING_IS_MAXSIZE) ? IDiagramExporter.TilingData.createMaxSizeTiledData((int)this.preferenceStore.getInt(PREFERENCE_TILING_X), (int)this.preferenceStore.getInt(PREFERENCE_TILING_Y)) : IDiagramExporter.TilingData.createTiledData((int)this.preferenceStore.getInt(PREFERENCE_TILING_X), (int)this.preferenceStore.getInt(PREFERENCE_TILING_Y));
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateFileText();
        this.validateFileText();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFileGroup(composite);
        this.createImageFormatGroup(composite);
        this.createOptionsGroup(composite);
        this.createMessageGroup(composite);
        this.updateTilingOptions();
        return composite;
    }

    private void createFileGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 3);
        Label label = new Label(composite, 0);
        label.setText(Messages.SaveAsImageDialog_file_caption);
        this.fileText = new Text(composite, 2048);
        this.fileText.setText(this.preferenceStore.getString(PREFERENCE_FILE_PATH));
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveAsImageDialog.this.validateFileText();
            }
        });
        GridData gridData = new GridData(4, 0, true, false);
        gridData.widthHint = 300;
        this.fileText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText(Messages.SaveAsImageDialog_browse_workspace_caption);
        gridData = new GridData(131072, 0, true, false);
        gridData.widthHint = 150;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveAsImageDialog.this.handleWorkspaceBrowse();
            }
        });
        this.workspacePathCheckbox = new Button(composite, 16416);
        this.workspacePathCheckbox.setText(Messages.SaveAsImageDialog_is_workspace_path_caption);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        this.workspacePathCheckbox.setLayoutData((Object)gridData);
        this.workspacePathCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_WORKSPACE_PATH));
        this.workspacePathCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveAsImageDialog.this.validateFileText();
            }
        });
        button = new Button(composite, 8);
        button.setText(Messages.SaveAsImageDialog_browse_file_system_caption);
        gridData = new GridData(131072, 0, true, false);
        gridData.widthHint = 150;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SaveAsImageDialog.this.handleFileSystemBrowse();
            }
        });
    }

    private void createImageFormatGroup(Composite parent) {
        final Composite composite = this.createComposite(parent, 4);
        Label label = new Label(composite, 0);
        label.setText(Messages.SaveAsImageDialog_image_format_caption);
        String[] imageFormats = new String[this.descriptors.size()];
        int i = 0;
        for (KlighdDataManager.ExporterDescriptor descr : this.descriptors) {
            String string = imageFormats[i++] = Strings.isNullOrEmpty((String)descr.description) ? descr.fileExtension : descr.description;
        }
        this.imageFormatCombo = new Combo(composite, 12);
        this.imageFormatCombo.setItems(imageFormats);
        int index = this.preferenceStore.getInt(PREFERENCE_IMAGE_FORMAT);
        index = index < 0 || index >= imageFormats.length ? 0 : index;
        this.imageFormatCombo.setText(imageFormats[index]);
        this.imageFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveAsImageDialog.this.updateFileText();
                SaveAsImageDialog.this.validateFileText();
                SaveAsImageDialog.this.updateTilingOptions();
            }
        });
        GridData gridData = new GridData(0);
        gridData.widthHint = 210;
        gridData.horizontalSpan = 3;
        this.imageFormatCombo.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(Messages.SaveAsImageDialog_scale_factor);
        this.scaleSlider = new Scale(composite, 256);
        this.scaleSlider.setToolTipText("Scale factor");
        this.scaleSlider.setMinimum(1);
        this.scaleSlider.setMaximum(16);
        this.scaleSlider.setSelection(this.preferenceStore.getInt(PREFERENCE_SCALE_FACTOR));
        gridData = new GridData(16384, 0x1000000, true, false);
        gridData.minimumWidth = 300;
        gridData.horizontalSpan = 2;
        this.scaleSlider.setLayoutData((Object)gridData);
        final Label scaleVal = new Label(composite, 2048);
        scaleVal.setText(String.valueOf(this.scaleSlider.getSelection()));
        gridData = new GridData(768);
        scaleVal.setLayoutData((Object)gridData);
        this.scaleSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Scale s = (Scale)e.widget;
                int n = s.getSelection();
                scaleVal.setText(String.valueOf(n));
                composite.layout();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.SaveAsImageDialog_tiling);
        this.tilingStateLabel = new Label(composite, 0);
        this.tilingOptionsButton = new Button(composite, 8);
        this.tilingOptionsButton.setText(Messages.SaveAsImageDialog_tiling_options_caption);
        gridData = new GridData(131072, 0, false, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        this.tilingOptionsButton.setLayoutData((Object)gridData);
        this.tilingOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TilingDialog tilingDialog = new TilingDialog(SaveAsImageDialog.this.getParentShell(), SaveAsImageDialog.this.tilingInfo);
                tilingDialog.open();
                SaveAsImageDialog.this.tilingInfo = tilingDialog.getTilingInfo();
                SaveAsImageDialog.this.updateTilingOptions();
            }
        });
    }

    private void updateTilingOptions() {
        if (this.descriptors.get((int)this.imageFormatCombo.getSelectionIndex()).supportsTiling) {
            this.tilingOptionsButton.setEnabled(true);
            if (this.tilingInfo.isMaxsize) {
                this.tilingStateLabel.setText(String.valueOf(this.tilingInfo.maxWidth) + " px x " + this.tilingInfo.maxHeight + " px");
            } else {
                this.tilingStateLabel.setText(String.valueOf(this.tilingInfo.rows) + " row(s) x " + this.tilingInfo.cols + " column(s)");
            }
        } else {
            this.tilingOptionsButton.setEnabled(false);
            this.tilingStateLabel.setText("Tiling not supported");
        }
        this.tilingStateLabel.getParent().layout();
    }

    private void createOptionsGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.cameraViewportCheckbox = new Button(composite, 16416);
        this.cameraViewportCheckbox.setText(Messages.SaveAsImageDialog_use_camera_viewport_caption);
        this.cameraViewportCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_CAMERA_VIEWPORT));
        this.cameraZoomLevelCheckbox = new Button(composite, 16416);
        this.cameraZoomLevelCheckbox.setText(Messages.SaveAsImageDialog_apply_camera_zoom_level_caption);
        this.cameraZoomLevelCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_CAMERA_ZOOM_LEVEL));
        this.transparentBackgroundCheckbox = new Button(composite, 16416);
        this.transparentBackgroundCheckbox.setText(Messages.SaveAsImageDialog_transparent_background);
        this.transparentBackgroundCheckbox.setSelection(this.preferenceStore.getBoolean("saveAsImageDialog.embedFonts"));
        this.textAsShapesCheckbox = new Button(composite, 16416);
        this.textAsShapesCheckbox.setText(Messages.SaveAsImageDialog_text_as_shapes);
        this.textAsShapesCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_TEXT_AS_SHAPES));
        this.embedFontsCheckbox = new Button(composite, 16416);
        this.embedFontsCheckbox.setText(Messages.SaveAsImageDialog_embed_fonts);
        this.embedFontsCheckbox.setSelection(this.preferenceStore.getBoolean("saveAsImageDialog.embedFonts"));
        this.setTextLengthsCheckbox = new Button(composite, 16416);
        this.setTextLengthsCheckbox.setText(Messages.SaveAsImageDialog_set_textLength);
        this.setTextLengthsCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_SET_TEXT_LENGTHS));
        this.updateEmbedFontsCheckbox(this.textAsShapesCheckbox.getSelection());
        this.updateSetTextLengthsCheckbox(this.textAsShapesCheckbox.getSelection());
        this.textAsShapesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                SaveAsImageDialog.this.updateEmbedFontsCheckbox(selected);
                SaveAsImageDialog.this.updateSetTextLengthsCheckbox(selected);
            }
        });
    }

    private void updateEmbedFontsCheckbox(boolean disabled) {
        if (disabled) {
            this.embedFontsCheckbox.setEnabled(false);
            this.embedFontsCheckbox.setSelection(false);
        } else {
            this.embedFontsCheckbox.setSelection(this.preferenceStore.getBoolean("saveAsImageDialog.embedFonts"));
            this.embedFontsCheckbox.setEnabled(true);
        }
    }

    private void updateSetTextLengthsCheckbox(boolean disabled) {
        if (disabled) {
            this.setTextLengthsCheckbox.setEnabled(false);
            this.setTextLengthsCheckbox.setSelection(false);
        } else {
            this.setTextLengthsCheckbox.setSelection(this.preferenceStore.getBoolean(PREFERENCE_SET_TEXT_LENGTHS));
            this.setTextLengthsCheckbox.setEnabled(true);
        }
    }

    private void createMessageGroup(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.messageImageLabel = new Label(composite, 0);
        this.messageImageLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        this.messageImageLabel.setVisible(false);
        this.messageLabel = new Label(composite, 0);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.widthHint = 300;
        this.messageLabel.setLayoutData((Object)gridData);
        this.messageLabel.setVisible(false);
    }

    private void validateFileText() {
        if (this.fileText.getText().length() > 0 && Path.ROOT.isValidPath(this.fileText.getText())) {
            Path filePath = new Path(this.fileText.getText());
            IPath containerPath = filePath.removeLastSegments(1);
            if (filePath.hasTrailingSeparator()) {
                this.setErrorStatus(Messages.SaveAsImageDialog_path_is_not_valid_error);
                return;
            }
            if (this.workspacePathCheckbox.getSelection()) {
                if (containerPath.segmentCount() == 0) {
                    this.setErrorStatus(Messages.SaveAsImageDialog_file_outside_project_error);
                    return;
                }
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IResource resource = root.findMember((IPath)filePath);
                if (resource != null && resource.exists() && resource instanceof IContainer) {
                    this.setErrorStatus(Messages.SaveAsImageDialog_path_is_not_valid_error);
                    return;
                }
                resource = root.findMember(containerPath);
                if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
                    this.setErrorStatus(Messages.SaveAsImageDialog_container_not_exist_error);
                    return;
                }
            } else {
                File file = new File(filePath.toString());
                if (file.isDirectory()) {
                    this.setErrorStatus(Messages.SaveAsImageDialog_path_is_not_valid_error);
                    return;
                }
                File container = new File(containerPath.toString());
                if (!container.exists()) {
                    this.setErrorStatus(Messages.SaveAsImageDialog_container_not_exist_error);
                    return;
                }
            }
        } else {
            this.setErrorStatus(Messages.SaveAsImageDialog_path_is_not_valid_error);
            return;
        }
        this.setOKStatus();
    }

    private void handleFileSystemBrowse() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setOverwrite(true);
        KlighdDataManager.ExporterDescriptor descriptor = this.descriptors.get(this.imageFormatCombo.getSelectionIndex());
        String ext = descriptor.fileExtension;
        if (!ext.startsWith("*.")) {
            ext = ext.startsWith(".") ? "*" + ext : "*." + ext;
        }
        String[] extensions = new String[]{ext};
        String[] descriptions = new String[]{descriptor.description};
        fileDialog.setFilterExtensions(extensions);
        fileDialog.setFilterNames(descriptions);
        fileDialog.setText(Messages.SaveAsImageDialog_save_as_caption);
        String selectedFile = fileDialog.open();
        if (selectedFile != null) {
            this.workspacePathCheckbox.setSelection(false);
            this.fileText.setText(selectedFile);
        }
    }

    private void handleWorkspaceBrowse() {
        SaveAsDialog fileDialog = new SaveAsDialog(this.getShell());
        int status = fileDialog.open();
        if (status == 0) {
            IPath filePath = fileDialog.getResult();
            String ext = filePath.getFileExtension();
            this.workspacePathCheckbox.setSelection(true);
            if (ext != null && ext.length() > 0) {
                this.fileText.setText(filePath.toString());
            } else {
                KlighdDataManager.ExporterDescriptor descriptor = this.descriptors.get(this.imageFormatCombo.getSelectionIndex());
                String extDefault = descriptor.fileExtension;
                this.fileText.setText(String.valueOf(filePath.toString()) + "." + extDefault);
            }
        }
    }

    private void updateFileText() {
        if (this.fileText.getText().length() > 0 && Path.ROOT.isValidPath(this.fileText.getText())) {
            Path filePath = new Path(this.fileText.getText());
            KlighdDataManager.ExporterDescriptor descriptor = this.descriptors.get(this.imageFormatCombo.getSelectionIndex());
            String ext = descriptor.fileExtension;
            if (filePath.getFileExtension() != null) {
                if (!filePath.getFileExtension().equals(ext)) {
                    this.fileText.setText(filePath.removeFileExtension().addFileExtension(ext).toString());
                }
            } else {
                this.fileText.setText(filePath.addFileExtension(ext).toString());
            }
        }
    }

    private void setErrorStatus(String message) {
        this.messageLabel.setText(message);
        this.messageImageLabel.setVisible(true);
        this.messageLabel.setVisible(true);
        this.getButton(0).setEnabled(false);
        this.getButton(1).getShell().setDefaultButton(this.getButton(1));
    }

    private void setOKStatus() {
        this.messageImageLabel.setVisible(false);
        this.messageLabel.setVisible(false);
        this.getButton(0).setEnabled(true);
        this.getButton(0).getShell().setDefaultButton(this.getButton(0));
    }

    private Composite createComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData data = new GridData(4, 0, true, false);
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SaveAsImageDialog_title);
    }

    public KlighdDataManager.ExporterDescriptor getCurrentExporter() {
        return this.currentExporter;
    }

    public IDiagramExporter.ExportData getExportData() {
        return this.exportData;
    }

    public boolean close() {
        this.preferenceStore.setValue(PREFERENCE_FILE_PATH, this.fileText.getText());
        this.preferenceStore.setValue(PREFERENCE_WORKSPACE_PATH, this.workspacePathCheckbox.getSelection());
        this.preferenceStore.setValue(PREFERENCE_IMAGE_FORMAT, this.imageFormatCombo.getSelectionIndex());
        this.preferenceStore.setValue(PREFERENCE_CAMERA_VIEWPORT, this.cameraViewportCheckbox.getSelection());
        this.preferenceStore.setValue(PREFERENCE_CAMERA_ZOOM_LEVEL, this.cameraZoomLevelCheckbox.getSelection());
        this.preferenceStore.setValue(PREFERENCE_SCALE_FACTOR, this.scaleSlider.getSelection());
        this.preferenceStore.setValue("saveAsImageDialog.embedFonts", this.transparentBackgroundCheckbox.getSelection());
        this.preferenceStore.setValue(PREFERENCE_TEXT_AS_SHAPES, this.textAsShapesCheckbox.getSelection());
        if (this.embedFontsCheckbox.isEnabled()) {
            this.preferenceStore.setValue("saveAsImageDialog.embedFonts", this.embedFontsCheckbox.getSelection());
        }
        if (this.setTextLengthsCheckbox.isEnabled()) {
            this.preferenceStore.setValue(PREFERENCE_SET_TEXT_LENGTHS, this.setTextLengthsCheckbox.getSelection());
        }
        this.preferenceStore.setValue(PREFERENCE_TILING_IS_MAXSIZE, this.tilingInfo.isMaxsize);
        if (this.tilingInfo.isMaxsize) {
            this.preferenceStore.setValue(PREFERENCE_TILING_X, this.tilingInfo.maxWidth);
            this.preferenceStore.setValue(PREFERENCE_TILING_Y, this.tilingInfo.maxHeight);
        } else {
            this.preferenceStore.setValue(PREFERENCE_TILING_X, this.tilingInfo.rows);
            this.preferenceStore.setValue(PREFERENCE_TILING_Y, this.tilingInfo.cols);
        }
        return super.close();
    }

    protected void okPressed() {
        this.updateFileText();
        this.currentExporter = this.descriptors.get(this.imageFormatCombo.getSelectionIndex());
        IDiagramExporter.ExportDataBuilder builder = new IDiagramExporter.ExportDataBuilder(this.viewContext, this.currentExporter.subFormatId, (IPath)new Path(this.fileText.getText()), this.workspacePathCheckbox.getSelection()).cameraViewport(this.cameraViewportCheckbox.getSelection()).applyCameraZoomLevel(this.cameraZoomLevelCheckbox.getSelection()).scale(this.scaleSlider.getSelection()).transparentBackground(this.transparentBackgroundCheckbox.getSelection()).textAsShapes(this.textAsShapesCheckbox.getSelection()).embedFonts(this.embedFontsCheckbox.getSelection()).setTextLengths(this.setTextLengthsCheckbox.getSelection());
        if (this.currentExporter.supportsTiling && this.tilingInfo.isTiled) {
            builder.tilingInfo(this.tilingInfo);
        }
        this.exportData = builder.build();
        super.okPressed();
    }
}

