/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.handlers;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.klighd.IAction;
import de.cau.cs.kieler.klighd.IKlighdSelection;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ZoomStyle;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.util.Iterables2;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class KlighdActionExecutionHandler
extends AbstractHandler {
    private static final String ACTION_PARAMETER_ID = "de.cau.cs.kieler.klighd.ui.action";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAction action;
        IKlighdSelection selection;
        ISelection s = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (s instanceof IKlighdSelection) {
            selection = (IKlighdSelection)s;
        } else {
            if (s != null) return null;
            s = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (!(s instanceof IKlighdSelection)) return null;
            selection = (IKlighdSelection)s;
        }
        try {
            action = (IAction)event.getObjectParameterForExecution(ACTION_PARAMETER_ID);
        }
        catch (ExecutionException e) {
            return null;
        }
        if (action == null) {
            return null;
        }
        ViewContext viewContext = selection.getViewContext();
        IAction.ActionResult resultOfLastRun = null;
        IAction.ActionResult resultOfLastRunRequiringLayout = null;
        boolean anyResultNeedsNewSynthesis = false;
        viewContext.getLayoutRecorder().startRecording();
        UnmodifiableIterator kges = Iterators.filter((Iterator)selection.diagramElementsIterator(), KGraphElement.class);
        for (KGraphElement kge : Iterables2.toIterable((Iterator)kges)) {
            IAction.ActionContext context = new IAction.ActionContext(viewContext.getViewer(), null, kge, null);
            resultOfLastRun = action.execute(context);
            if (resultOfLastRun != null && resultOfLastRun.getActionPerformed()) {
                resultOfLastRunRequiringLayout = resultOfLastRun;
            }
            anyResultNeedsNewSynthesis |= resultOfLastRun.getNeedsSynthesis();
        }
        if (resultOfLastRunRequiringLayout != null) {
            IAction.ActionResult result = resultOfLastRunRequiringLayout;
            ZoomStyle zoomStyle = ZoomStyle.create(result, (ViewContext)viewContext);
            if (anyResultNeedsNewSynthesis) {
                viewContext.update();
            }
            new LightDiagramLayoutConfig(viewContext).animate(Boolean.valueOf(result.getAnimateLayout())).zoomStyle(zoomStyle).focusElement(result.getFocusElement()).previousPosition(result.getPreviousPosition()).options(result.getLayoutConfigs()).performLayout();
            return null;
        } else if (resultOfLastRun != null) {
            viewContext.getLayoutRecorder().stopRecording(ZoomStyle.create(resultOfLastRun, (ViewContext)viewContext), resultOfLastRun.getFocusElement(), 0);
            return null;
        } else {
            viewContext.getLayoutRecorder().stopRecording(ZoomStyle.NONE, null, 0);
        }
        return null;
    }

    public static class IActionParameterValueConverter
    extends AbstractParameterValueConverter {
        public Object convertToObject(String parameterValue) throws ParameterValueConversionException {
            return KlighdDataManager.getInstance().getActionById(parameterValue);
        }

        public String convertToString(Object parameterValue) throws ParameterValueConversionException {
            if (parameterValue instanceof String) {
                return (String)parameterValue;
            }
            if (parameterValue instanceof IAction) {
                return KlighdDataManager.getInstance().getActionsId((IAction)parameterValue);
            }
            throw new ParameterValueConversionException("");
        }
    }

    public static class IActionParameterValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            return Maps.uniqueIndex((Iterable)KlighdDataManager.getInstance().getActionIds(), (Function)new Function<String, String>(){

                public String apply(String actionId) {
                    int index = actionId.lastIndexOf(46);
                    return index == -1 ? actionId : actionId.substring(index + 1);
                }
            });
        }
    }
}

