/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui.internal.handlers;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.internal.util.KlighdInternalProperties;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KGraphData;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.kgraph.util.KGraphIterators;
import de.cau.cs.kieler.klighd.kgraph.util.KGraphUtil;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KImage;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingLibrary;
import de.cau.cs.kieler.klighd.krendering.KRenderingRef;
import de.cau.cs.kieler.klighd.util.ExpansionAwareLayoutOption;
import de.cau.cs.kieler.klighd.util.KlighdProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class ExportKGraphHelper {
    private ExportKGraphHelper() {
    }

    public static void export(KNode graph, URI fileOutputURI, boolean protectIP, boolean removeChildren) {
        try {
            KNode exportedGraph;
            KNode root = graph;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            KNode copy = (KNode)copier.copy((EObject)root);
            copier.copyReferences();
            if (graph == root) {
                exportedGraph = copy;
            } else {
                KRenderingLibrary[] libs;
                KNode subgraphCopy = (KNode)copier.get((Object)graph);
                subgraphCopy.setPos(0.0f, 0.0f);
                KRenderingLibrary[] kRenderingLibraryArray = libs = (KRenderingLibrary[])Iterators.toArray((Iterator)Iterators.filter((Iterator)copy.eAllContents(), KRenderingLibrary.class), KRenderingLibrary.class);
                int n = libs.length;
                int n2 = 0;
                while (n2 < n) {
                    KRenderingLibrary lib = kRenderingLibraryArray[n2];
                    subgraphCopy.getData().add((Object)lib);
                    ++n2;
                }
                KNode newRoot = KGraphUtil.createInitializedNode();
                newRoot.getChildren().add((Object)subgraphCopy);
                newRoot.setWidth(subgraphCopy.getWidth());
                newRoot.setHeight(subgraphCopy.getHeight());
                newRoot.setProperty(KlighdInternalProperties.POPULATED, (Object)true);
                newRoot.setProperty(KlighdProperties.EXPAND, (Object)true);
                exportedGraph = newRoot;
            }
            try {
                HashSet populatedNodes = Sets.newHashSet();
                EObject copyRoot = (EObject)copier.get((Object)graph);
                Iterator kgeIt = KGraphIterators.getKGraphElementIterator((KGraphElement)((KNode)copyRoot), (boolean)true);
                while (kgeIt.hasNext()) {
                    KGraphElement kge = (KGraphElement)kgeIt.next();
                    if (kge instanceof KNode && kge != exportedGraph) {
                        ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData ealo;
                        KNode kNode = (KNode)kge;
                        boolean isPopulated = (Boolean)kNode.getProperty(KlighdInternalProperties.POPULATED);
                        kNode.setProperty(KlighdProperties.EXPAND, (Object)isPopulated);
                        if (isPopulated) {
                            populatedNodes.add(kNode);
                        }
                        if ((ealo = (ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData)kNode.getProperty(ExpansionAwareLayoutOption.OPTION)) != null) {
                            kNode.copyProperties(ealo.getValues(isPopulated));
                        }
                        if (removeChildren && isPopulated && kNode != copyRoot) {
                            kNode.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
                            Direction dir = (Direction)kNode.getParent().getProperty(CoreOptions.DIRECTION);
                            for (KPort p : kNode.getPorts()) {
                                p.setProperty(CoreOptions.PORT_SIDE, (Object)KGraphUtil.calcPortSide((KPort)p, (Direction)dir));
                            }
                        }
                    }
                    Iterator dataIt = kge.getData().iterator();
                    block9: while (dataIt.hasNext()) {
                        KGraphData d = (KGraphData)dataIt.next();
                        if (protectIP) {
                            dataIt.remove();
                            continue;
                        }
                        if (!(d instanceof KContainerRendering)) continue;
                        for (KRendering ren : ((KContainerRendering)d).getChildren()) {
                            if (ren instanceof KRenderingRef && ((KRenderingRef)ren).getRendering() instanceof KImage) {
                                dataIt.remove();
                                continue block9;
                            }
                            if (!(d instanceof KImage)) continue;
                            dataIt.remove();
                            continue block9;
                        }
                    }
                    if (!protectIP) continue;
                    ExportKGraphHelper.removeNonLayoutProperties(kge);
                    if (!(kge instanceof KLabel)) continue;
                    ExportKGraphHelper.replaceLabelText((KLabel)kge);
                }
                KGraphUtil.persistDataElements((KNode)exportedGraph);
                if (removeChildren) {
                    for (KNode child : ((KNode)copier.get((Object)graph)).getChildren()) {
                        child.getChildren().clear();
                        child.setProperty(KlighdProperties.EXPAND, (Object)false);
                        child.setProperty(KlighdProperties.MINIMAL_NODE_SIZE, null);
                        Iterator dataIt = child.getData().iterator();
                        while (dataIt.hasNext()) {
                            KGraphData d = (KGraphData)dataIt.next();
                            if (d instanceof KRendering && populatedNodes.contains(child)) {
                                if (!((Boolean)d.getProperty(KlighdProperties.COLLAPSED_RENDERING)).booleanValue()) continue;
                                dataIt.remove();
                                continue;
                            }
                            if (!(d instanceof KRendering) || !((Boolean)d.getProperty(KlighdProperties.EXPANDED_RENDERING)).booleanValue()) continue;
                            dataIt.remove();
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource r = rs.createResource(fileOutputURI);
            r.getContents().add((Object)exportedGraph);
            ExportKGraphHelper.recursivelyRemoveInvalidEdges((KNode)copier.get((Object)graph));
            HashMap saveOpts = Maps.newHashMap();
            saveOpts.put("PROCESS_DANGLING_HREF", "DISCARD");
            r.save((Map)saveOpts);
        }
        catch (IOException e) {
            Klighd.show((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", "Could not write the KGraph to selected resource.", (Throwable)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            Klighd.show((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", "Error occurred.", (Throwable)e));
        }
    }

    private static void replaceLabelText(KLabel label) {
        Random r = new Random();
        int l = label.getText().length();
        StringBuilder string = new StringBuilder(l);
        int i = 0;
        while (i < l) {
            string.append((char)(r.nextInt(26) + 97));
            ++i;
        }
        label.setText(string.toString());
    }

    private static void removeNonLayoutProperties(KGraphElement kge) {
        for (Map.Entry entry : kge.getProperties()) {
            if (ExportKGraphHelper.isLayoutProperty((IProperty)entry.getKey())) continue;
            entry.setValue(null);
        }
    }

    private static boolean isLayoutProperty(IProperty<?> prop) {
        HashSet goodProperties = Sets.newHashSet((Object[])new IProperty[]{KlighdProperties.EXPAND, KlighdProperties.MINIMAL_NODE_SIZE});
        HashSet badProperties = Sets.newHashSet((Object[])new IProperty[]{CoreOptions.LABEL_MANAGER, LabelManagementOptions.LABEL_MANAGER});
        return prop.getId().startsWith("org.eclipse.elk") && !badProperties.contains(prop) || goodProperties.contains(prop);
    }

    private static void recursivelyRemoveInvalidEdges(KNode parent) {
        Iterator edgeIt = parent.getOutgoingEdges().iterator();
        while (edgeIt.hasNext()) {
            KEdge edge = (KEdge)edgeIt.next();
            if (edge.getTarget() == null) {
                edgeIt.remove();
                continue;
            }
            if (edge.getSource().eResource().equals(edge.getTarget().eResource())) continue;
            edgeIt.remove();
        }
        for (KNode child : parent.getChildren()) {
            ExportKGraphHelper.recursivelyRemoveInvalidEdges(child);
        }
    }
}

