/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import de.cau.cs.kieler.klighd.IKlighdSelection;
import de.cau.cs.kieler.klighd.IViewer;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.piccolo.IKlighdNode;
import de.cau.cs.kieler.klighd.piccolo.KlighdNode;
import de.cau.cs.kieler.klighd.util.ModelingUtil;
import edu.umd.cs.piccolo.PNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class KlighdTextSelection
implements IKlighdSelection,
IStructuredSelection,
ITextSelection {
    private final KlighdNode.KlighdFigureNode<KText> figureNode;
    private final IViewer viewer;
    private final KText diagramElement;
    private KGraphElement kgraphElement;
    private final String text;
    private final int offset;
    private final boolean completeLine;
    private final boolean completeLabel;

    public KlighdTextSelection(String theText, int theOffset, boolean isCompleteLine, boolean isCompleteLabel, KlighdNode.KlighdFigureNode<KText> figureNode, IViewer theViewer) {
        this.viewer = theViewer;
        this.text = theText;
        this.offset = theOffset;
        this.completeLine = isCompleteLine;
        this.completeLabel = isCompleteLabel;
        this.figureNode = figureNode;
        this.diagramElement = figureNode == null ? null : (KText)figureNode.getViewModelElement();
        this.kgraphElement = null;
    }

    public boolean isCompleteLine() {
        return this.completeLine;
    }

    public boolean isCompleteLabel() {
        return this.completeLabel;
    }

    public IViewer getViewer() {
        return this.viewer;
    }

    public ViewContext getViewContext() {
        return this.viewer.getViewContext();
    }

    public KText getViewElement() {
        return this.diagramElement;
    }

    public KGraphElement getKGraphElement() {
        return this.determineKGraphElement();
    }

    public KLabel getKLabel() {
        return this.determineKGraphElement() instanceof KLabel ? (KLabel)this.kgraphElement : null;
    }

    public KNode getKNode() {
        return (KNode)ModelingUtil.eContainerOfType((EObject)this.determineKGraphElement(), KNode.class);
    }

    public Iterator<EObject> diagramElementsIterator() {
        return Iterators.singletonIterator((Object)this.determineKGraphElement());
    }

    private KGraphElement determineKGraphElement() {
        if (this.kgraphElement == null) {
            PNode node = this.figureNode;
            while (node != null) {
                if (node instanceof IKlighdNode.IKGraphElementNode) {
                    this.kgraphElement = ((IKlighdNode.IKGraphElementNode)node).getViewModelElement();
                    break;
                }
                node = node.getParent();
            }
        }
        return this.kgraphElement;
    }

    public String toString() {
        return "KLighdTextSelection: " + this.text;
    }

    public String getText() {
        return this.text;
    }

    public boolean isEmpty() {
        return Strings.isNullOrEmpty((String)this.text);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.text.length();
    }

    public int getStartLine() {
        return 0;
    }

    public int getEndLine() {
        return 0;
    }

    public Object getFirstElement() {
        return this;
    }

    public Iterator<KlighdTextSelection> iterator() {
        return Iterators.singletonIterator((Object)this);
    }

    public int size() {
        return 1;
    }

    public KlighdTextSelection[] toArray() {
        return new KlighdTextSelection[]{this};
    }

    public List<KlighdTextSelection> toList() {
        return Collections.singletonList(this);
    }
}

