/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.ui;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.IDiagramWorkbenchPart;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.LightDiagramLayoutConfig;
import de.cau.cs.kieler.klighd.ViewContext;
import de.cau.cs.kieler.klighd.ui.parts.DiagramEditorPart;
import de.cau.cs.kieler.klighd.ui.parts.DiagramViewPart;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class DiagramViewManager
implements IPartListener {
    private static final String PRIMARY_VIEW_ID = "de.cau.cs.kieler.klighd.ui.parts.DiagramViewPart";
    private static DiagramViewManager singletonInstance = new DiagramViewManager();
    private boolean registered = false;
    private Map<String, IDiagramWorkbenchPart> idPartMapping = Maps.newHashMap();
    private Map<String, ViewContext> idContextMapping = Maps.newHashMap();

    public static DiagramViewManager getInstance() {
        return singletonInstance;
    }

    private DiagramViewManager() {
        this.registerPartListener();
    }

    public static IDiagramWorkbenchPart getDiagramWorkbenchPart(String id) {
        return DiagramViewManager.getInstance().idPartMapping.get(id);
    }

    public static DiagramViewPart getView(String id) {
        IDiagramWorkbenchPart view = DiagramViewManager.getInstance().idPartMapping.get(id);
        if (view != null && view instanceof DiagramViewPart) {
            if (((DiagramViewPart)view).isDisposed()) {
                DiagramViewManager.getInstance().unregisterView(view);
                return null;
            }
            return (DiagramViewPart)view;
        }
        return null;
    }

    public static DiagramEditorPart getEditor(String id) {
        IDiagramWorkbenchPart part = DiagramViewManager.getInstance().idPartMapping.get(id);
        if (part != null && part instanceof DiagramEditorPart) {
            return (DiagramEditorPart)part;
        }
        return null;
    }

    public static IDiagramWorkbenchPart updateView(String id) {
        return DiagramViewManager.updateView(id, null, null, null);
    }

    public static IDiagramWorkbenchPart updateView(String id, IPropertyHolder properties) {
        return DiagramViewManager.updateView(id, null, null, properties);
    }

    public static IDiagramWorkbenchPart updateView(String id, String name, Object model, IPropertyHolder properties) {
        ViewContext viewContext;
        IDiagramWorkbenchPart diagramView = DiagramViewManager.getDiagramWorkbenchPart(id);
        if (diagramView == null) {
            return null;
        }
        if (name != null && diagramView instanceof DiagramViewPart) {
            ((DiagramViewPart)diagramView).setName(name);
        }
        if ((viewContext = diagramView.getViewContext()) == null) {
            return null;
        }
        if (!new LightDiagramLayoutConfig(viewContext).model(model).properties(properties).performUpdate()) {
            return null;
        }
        return diagramView;
    }

    public static IDiagramWorkbenchPart updateView(ViewContext viewContext) {
        return DiagramViewManager.updateView(viewContext, null);
    }

    public static IDiagramWorkbenchPart updateView(ViewContext viewContext, Object model) {
        boolean res = new LightDiagramLayoutConfig(viewContext).model(model).performUpdate();
        return res ? viewContext.getDiagramWorkbenchPart() : null;
    }

    public static DiagramViewPart createView(String id, String name, Object model) {
        return DiagramViewManager.createView(id, name, model, null);
    }

    public static DiagramViewPart createView(String id, String name, Object model, IPropertyHolder properties) {
        DiagramViewManager.getInstance().registerPartListener();
        if (model == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        DiagramViewPart diagramView = DiagramViewManager.getView(id);
        if (diagramView == null) {
            try {
                IViewPart view = page.showView(PRIMARY_VIEW_ID, id, 2);
                if (!(view instanceof DiagramViewPart)) {
                    throw new PartInitException("KLighD: Creation of a KLighD DiagramViewPart failed.\nThis appears to be a heavy internal error!");
                }
                diagramView = (DiagramViewPart)view;
            }
            catch (PartInitException e) {
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", e.getMessage(), (Throwable)e));
                return null;
            }
            catch (IllegalArgumentException e) {
                Klighd.handle((IStatus)new Status(4, "de.cau.cs.kieler.klighd.ui", "Invalid KLighD view id: must not be empty or contain any colons."));
                return null;
            }
        } else {
            DiagramViewManager.getInstance().unregisterView(diagramView);
        }
        diagramView.initialize(model, name, properties);
        return diagramView;
    }

    public static DiagramViewPart initializeView(DiagramViewPart diagramView, Object model, String name, IPropertyHolder properties) {
        diagramView.initialize(model, name, properties);
        return diagramView;
    }

    public void registerView(IDiagramWorkbenchPart part) {
        String id = part.getPartId();
        this.idPartMapping.put(id, part);
        this.idContextMapping.put(id, part.getViewContext());
    }

    public void unregisterView(IDiagramWorkbenchPart part) {
        String id = part.getPartId();
        this.idPartMapping.remove(id);
        this.idContextMapping.remove(id);
    }

    public static boolean closeView(String id) {
        IWorkbenchWindow window;
        block9: {
            block8: {
                IDiagramWorkbenchPart part;
                block7: {
                    if (id.equals("")) {
                        return false;
                    }
                    part = DiagramViewManager.getInstance().idPartMapping.get(id);
                    if (!(part instanceof DiagramEditorPart)) break block7;
                    return false;
                }
                DiagramViewPart view = part instanceof DiagramViewPart ? (DiagramViewPart)part : null;
                if (view == null) break block8;
                DiagramViewManager.getInstance().unregisterView(view);
                view.getSite().getPage().hideView((IViewPart)view);
                return true;
            }
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) break block9;
            return false;
        }
        try {
            IWorkbenchPage page = window.getActivePage();
            IViewReference viewRef = page.findViewReference(PRIMARY_VIEW_ID, id);
            if (viewRef != null) {
                page.hideView(viewRef);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private void registerPartListener() {
        if (!this.registered) {
            IViewReference[] viewReferences;
            this.registered = true;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return;
            }
            IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                viewReference.getId().equals(PRIMARY_VIEW_ID);
                ++n2;
            }
            page.addPartListener((IPartListener)this);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof DiagramViewPart) {
            DiagramViewPart diagramView = (DiagramViewPart)part;
            this.unregisterView(diagramView);
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }
}

