/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.setup;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import de.cau.cs.kieler.klighd.KlighdDataManager;
import de.cau.cs.kieler.klighd.KlighdOptions;
import de.cau.cs.kieler.klighd.kgraph.KGraphPackage;
import de.cau.cs.kieler.klighd.krendering.KRenderingPackage;
import de.cau.cs.kieler.klighd.util.ExpansionAwareLayoutOption;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.elk.alg.force.options.ForceMetaDataProvider;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizMetaDataProvider;
import org.eclipse.elk.alg.layered.options.LayeredMetaDataProvider;
import org.eclipse.elk.alg.mrtree.options.MrTreeMetaDataProvider;
import org.eclipse.elk.alg.radial.options.RadialMetaDataProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.graph.util.ElkReflect;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class KlighdStandaloneSetup {
    public static void initialize() {
        new KlighdStandaloneSetup().doInitialize();
    }

    public void doInitialize() {
        EPackage.Registry.INSTANCE.put((Object)"http://kieler.cs.cau.de/KlighdGraph", (Object)KGraphPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://kieler.cs.cau.de/KRendering", (Object)KRenderingPackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("kgx", new XMIResourceFactoryImpl());
        this.registerFonts();
        ElkReflect.register(ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData.class, () -> new ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData(), v -> new ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData((ExpansionAwareLayoutOption.ExpansionAwareLayoutOptionData)v));
        ArrayList providers = Lists.newArrayList((Object[])new ILayoutMetaDataProvider[]{new KlighdOptions(), this.getForceMetaDataProvider(), this.getGraphvizMetaDataProvider(), this.getLayeredMetaDataProvider(), this.getMrTreeMetaDataProvider(), this.getRadialMetaDataProvider()});
        LayoutMetaDataService.getInstance().registerLayoutMetaDataProviders(Collections2.filter((Collection)providers, (Predicate)Predicates.notNull()).toArray(new ILayoutMetaDataProvider[0]));
        KlighdDataManager _kdm = KlighdDataManager.getInstance();
    }

    protected ILayoutMetaDataProvider getForceMetaDataProvider() {
        try {
            return new ForceMetaDataProvider();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected ILayoutMetaDataProvider getGraphvizMetaDataProvider() {
        try {
            return new GraphvizMetaDataProvider();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected ILayoutMetaDataProvider getLayeredMetaDataProvider() {
        try {
            return new LayeredMetaDataProvider();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected ILayoutMetaDataProvider getMrTreeMetaDataProvider() {
        try {
            return new MrTreeMetaDataProvider();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected ILayoutMetaDataProvider getRadialMetaDataProvider() {
        try {
            return new RadialMetaDataProvider();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected void registerFonts() {
        String[] filePaths = new String[]{"/fonts/overpass-regular.otf", "/fonts/overpass-mono-regular.otf"};
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int i = 0;
        while (i < filePaths.length) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream fontStream = this.getClass().getResourceAsStream(filePaths[i]);){
                    ge.registerFont(Font.createFont(0, fontStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                System.out.println("could not load font file " + filePaths[i]);
            }
            ++i;
        }
    }
}

