/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.piccolo.draw2d;

import de.cau.cs.kieler.klighd.piccolo.internal.KlighdSWTGraphicsEx;
import de.cau.cs.kieler.klighd.piccolo.internal.util.PolylineUtil;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedList;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;

public class GraphicsAdapter
extends Graphics {
    private AffineTransform awtTransform = new AffineTransform();
    private static final Path2D.Float SINGLETON_PATH = new Path2D.Float();
    private static final Line2D.Float SINGLETON_LINE = new Line2D.Float();
    private static final Arc2D.Float SINGLETON_ARC = new Arc2D.Float();
    private static final Ellipse2D.Float SINGLETON_ELLIPSE = new Ellipse2D.Float();
    private static final Rectangle2D.Float SINGLETON_RECTANGLE = new Rectangle2D.Float();
    private static final RoundRectangle2D.Float SINGLETON_ROUND_RECTANGLE = new RoundRectangle2D.Float();
    private static final String UNSUPPORTED_OPERATION_MSG_ESCAPE = "<<method>>";
    private static final String UNSUPPORTED_OPERATION_MSG = "KLighD Draw2d wrapper: Method " + GraphicsAdapter.class.getSimpleName() + "<<method>>" + " required by one of the employed diagram figures to be displayed is currently" + "not implemented. Please implement or file a bug report to the development team.";
    private KlighdSWTGraphicsEx pg;
    private LinkedList<State> stack = new LinkedList();

    public GraphicsAdapter() {
    }

    public GraphicsAdapter(KlighdSWTGraphicsEx graphics) {
        this.pg = graphics;
    }

    void setKlighdSWTGraphics(KlighdSWTGraphicsEx thePg) {
        this.pg = thePg;
        this.stack.clear();
    }

    public void dispose() {
        this.stack.clear();
    }

    public void pushState() {
        this.stack.push(new State(this.pg));
    }

    public void popState() {
        if (!this.stack.isEmpty()) {
            this.restoreState();
            this.stack.pop();
        }
    }

    public void restoreState() {
        State lastState = this.stack.peek();
        if (lastState != null) {
            this.pg.setTransform(lastState.transform);
            this.pg.setAlpha(lastState.alpha);
            this.pg.setFont(lastState.font);
            float width = lastState.lineAttributes.width;
            this.pg.setLineAttributes(lastState.lineAttributes);
            lastState.lineAttributes.width = width;
            this.pg.setStrokeColor(lastState.foreground);
            this.pg.setFillColor(lastState.background);
            GC gc = this.pg.getGC();
            if (gc != null) {
                if (lastState.foregroundPattern != null) {
                    gc.setForegroundPattern(lastState.foregroundPattern);
                }
                if (lastState.backgroundPattern != null) {
                    gc.setBackgroundPattern(lastState.backgroundPattern);
                }
            }
        }
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        SINGLETON_ARC.setArc(x, y, w, h, offset, length, 0);
        this.pg.draw((Shape)SINGLETON_ARC);
    }

    public void drawImage(Image srcImage, int x, int y) {
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        this.pg.transform(transform);
        org.eclipse.swt.graphics.Rectangle bounds = srcImage.getBounds();
        this.pg.drawImage(srcImage, (double)bounds.width, (double)bounds.height);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#drawImage(final Image srcImage, final int x1, final int y1, final int w1, final int h1, final int x2, final int y2, final int w2, final int h2)'"));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        SINGLETON_LINE.setLine(x1, y1, x2, y2);
        this.pg.draw((Shape)SINGLETON_LINE);
    }

    public void drawOval(int x, int y, int w, int h) {
        SINGLETON_ELLIPSE.setFrame(x, y, w, h);
        this.pg.draw((Shape)SINGLETON_ELLIPSE);
    }

    public void drawPath(Path path) {
        this.pg.draw(path);
    }

    public void drawPolygon(PointList points) {
        this.pg.draw((Shape)PolylineUtil.createPolygonPath((Path2D)SINGLETON_PATH, (int[])points.toIntArray()));
    }

    public void drawPolyline(PointList points) {
        this.pg.draw((Shape)PolylineUtil.createPolylinePath((Path2D)SINGLETON_PATH, (int[])points.toIntArray()));
    }

    public void drawRectangle(int x, int y, int width, int height) {
        SINGLETON_RECTANGLE.setRect(x, y, width, height);
        this.pg.draw((Shape)SINGLETON_RECTANGLE);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        SINGLETON_ROUND_RECTANGLE.setRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
        this.pg.draw((Shape)SINGLETON_ROUND_RECTANGLE);
    }

    public void drawString(String s, int x, int y) {
        this.translate(x, y);
        this.pg.drawText(s);
        this.translate(-x, -y);
    }

    public void drawText(String s, int x, int y) {
        this.translate(x, y);
        this.pg.drawText(s);
        this.translate(-x, -y);
    }

    public void drawText(String s, int x, int y, int style) {
        this.translate(x, y);
        this.pg.drawText(s);
        this.translate(-x, -y);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        SINGLETON_ARC.setArc(x, y, w, h, offset, length, 0);
        this.pg.fill((Shape)SINGLETON_ARC);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#fillGradient(final int x,final int y, final int w, final int h, final boolean vertical)"));
    }

    public void fillOval(int x, int y, int w, int h) {
        SINGLETON_ELLIPSE.setFrame(x, y, w, h);
        this.pg.fill((Shape)SINGLETON_ELLIPSE);
    }

    public void fillPath(Path path) {
        this.pg.fill(path);
    }

    public void fillPolygon(PointList points) {
        this.pg.fill((Shape)PolylineUtil.createPolygonPath((Path2D)SINGLETON_PATH, (int[])points.toIntArray()));
    }

    public void fillRectangle(int x, int y, int width, int height) {
        SINGLETON_RECTANGLE.setRect(x, y, width, height);
        this.pg.fill((Shape)SINGLETON_RECTANGLE);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        SINGLETON_ROUND_RECTANGLE.setRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
        this.pg.fill((Shape)SINGLETON_ROUND_RECTANGLE);
    }

    public void fillString(String s, int x, int y) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#fillString(final String s, final int x, final int y)"));
    }

    public void fillText(String s, int x, int y) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#fillText(final String s, final int x, final int y)"));
    }

    public Rectangle getClip(Rectangle rect) {
        Shape clip = this.pg.getClip();
        if (clip == null) {
            rect.setBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        } else {
            java.awt.Rectangle bounds = clip.getBounds();
            rect.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        return rect;
    }

    public int getLineWidth() {
        return Math.round(this.getLineWidthFloat());
    }

    public float getLineWidthFloat() {
        return this.pg.getLineAttributes().width;
    }

    public Font getFont() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#getFont()"));
    }

    public FontMetrics getFontMetrics() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#getFontMetrics()"));
    }

    public Color getForegroundColor() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#getForegroundColor()"));
    }

    public void setForegroundColor(Color rgb) {
        this.pg.setStrokeColor(rgb.getRGB());
    }

    public void setForegroundPattern(Pattern pattern) {
        GC gc = this.pg.getGC();
        if (gc != null) {
            gc.setForegroundPattern(pattern);
        }
    }

    public Color getBackgroundColor() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#getBackgroundColor()"));
    }

    public void setBackgroundColor(Color rgb) {
        this.pg.setFillColor(rgb.getRGB());
    }

    public void setBackgroundPattern(Pattern pattern) {
        GC gc = this.pg.getGC();
        if (gc != null) {
            gc.setBackgroundPattern(pattern);
        }
    }

    public void rotate(float degrees) {
        this.awtTransform.setToIdentity();
        this.awtTransform.rotate(degrees);
        this.pg.transform(this.awtTransform);
    }

    public void scale(double amount) {
        this.awtTransform.setToIdentity();
        this.awtTransform.scale(amount, amount);
        this.pg.transform(this.awtTransform);
    }

    public void setClip(Rectangle r) {
    }

    public void clipRect(Rectangle r) {
    }

    public void setFont(Font f) {
        this.pg.setFont(f.getFontData()[0]);
    }

    public void setLineAttributes(LineAttributes attributes) {
        float width = attributes.width;
        this.pg.setLineAttributes(attributes);
        this.updateClip(attributes.width);
        attributes.width = width;
    }

    public void setLineWidth(int width) {
        this.setLineWidthFloat(width);
    }

    public void setLineWidthFloat(float width) {
        LineAttributes la = this.pg.getLineAttributes();
        la.width = width;
        this.pg.setLineAttributes(la);
        this.updateClip(width);
    }

    public void translate(int dx, int dy) {
        this.awtTransform.setToIdentity();
        this.awtTransform.translate(dx, dy);
        this.pg.transform(this.awtTransform);
    }

    public void drawFocus(int x, int y, int w, int h) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG.replace(UNSUPPORTED_OPERATION_MSG_ESCAPE, "'#drawFocus(final int x, final int y, final int w, final int h)'"));
    }

    public void setAdvanced(boolean advanced) {
    }

    public void setAlpha(int alpha) {
        this.pg.setAlpha(alpha);
    }

    public int getAntialias() {
        return 1;
    }

    public void setAntialias(int value) {
    }

    public boolean getXORMode() {
        return false;
    }

    public void setXORMode(boolean b) {
    }

    public int getLineStyle() {
        return this.pg.getLineAttributes().style;
    }

    public void setLineStyle(int style) {
        LineAttributes la = this.pg.getLineAttributes();
        la.style = style;
        this.pg.setLineAttributes(la);
    }

    public LineAttributes getLineAttributes() {
        return this.pg.getLineAttributes();
    }

    public int getLineCap() {
        return this.pg.getLineAttributes().cap;
    }

    public void setLineCap(int cap) {
        LineAttributes la = this.pg.getLineAttributes();
        la.cap = cap;
        this.pg.setLineAttributes(la);
    }

    public void setLineDash(int[] dash) {
        float[] fdash = new float[dash.length];
        int i = 0;
        while (i < dash.length) {
            fdash[i] = dash[i];
            ++i;
        }
        LineAttributes la = this.pg.getLineAttributes();
        la.dash = fdash;
        this.pg.setLineAttributes(la);
    }

    public void setLineDash(float[] dash) {
        LineAttributes la = this.pg.getLineAttributes();
        la.dash = dash;
        this.pg.setLineAttributes(la);
    }

    public void setLineDashOffset(float dashOffset) {
        LineAttributes la = this.pg.getLineAttributes();
        la.dashOffset = dashOffset;
        this.pg.setLineAttributes(la);
    }

    public int getLineJoin() {
        return this.pg.getLineAttributes().join;
    }

    public void setLineJoin(int join) {
        LineAttributes la = this.pg.getLineAttributes();
        la.join = join;
        this.pg.setLineAttributes(la);
    }

    public float getLineMiterLimit() {
        return this.pg.getLineAttributes().miterLimit;
    }

    public void setLineMiterLimit(float miterLimit) {
        LineAttributes la = this.pg.getLineAttributes();
        la.miterLimit = miterLimit;
        this.pg.setLineAttributes(la);
    }

    public void updateClip(float lineWidth) {
    }

    private class State {
        private AffineTransform transform;
        private int alpha;
        private RGB foreground;
        private RGB background;
        private Pattern foregroundPattern;
        private Pattern backgroundPattern;
        private FontData font;
        private LineAttributes lineAttributes;

        State(KlighdSWTGraphicsEx g) {
            this.transform = g.getTransform();
            this.alpha = g.getAlpha();
            this.font = g.getFontData();
            this.lineAttributes = g.getLineAttributes();
            this.lineAttributes.width = g.getLineWidth();
            this.foreground = g.getStrokeColor();
            this.background = g.getFillColor();
            GC gc = g.getGC();
            if (gc != null) {
                this.foregroundPattern = gc.getForegroundPattern();
                this.backgroundPattern = gc.getBackgroundPattern();
            }
        }
    }
}

