/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.piccolo.draw2d;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.piccolo.draw2d.Draw2DNode;
import de.cau.cs.kieler.klighd.piccolo.draw2d.GraphicsAdapter;
import de.cau.cs.kieler.klighd.piccolo.internal.KlighdSWTGraphicsEx;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KCustomConnectionFigureNode;
import de.cau.cs.kieler.klighd.piccolo.internal.util.KlighdPaintContext;
import de.cau.cs.kieler.klighd.piccolo.internal.util.Styles;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Point2D;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.PointList;

public class Draw2DConnectionNode
extends KCustomConnectionFigureNode {
    private static final long serialVersionUID = -2181523653415457063L;
    private Connection figure;
    private UpdateManager updateManager;
    private GraphicsAdapter graphics = new GraphicsAdapter();

    public Draw2DConnectionNode(Connection theFigure) {
        this.updateManager = new Draw2DNode.WrappingUpdateManager((PNode)this);
        this.figure = new PolylineConnection(){
            {
                this.setOutline(false);
                this.setFill(false);
            }

            public void setPoints(PointList pts) {
                List children = this.getChildren();
                for (Connection child : Iterables.filter((Iterable)children, Connection.class)) {
                    child.setPoints(pts);
                }
            }

            public UpdateManager getUpdateManager() {
                return Draw2DConnectionNode.this.updateManager;
            }
        };
        this.figure.add((IFigure)theFigure);
    }

    public void setPoints(Point2D[] points) {
        int[] iPoints = new int[2 * points.length];
        int i = 0;
        Point2D[] point2DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            iPoints[2 * i++] = (int)(point.getX() + 0.5);
            iPoints[2 * i++] = (int)(point.getY() + 0.5);
            ++n2;
        }
        this.figure.setPoints(new PointList(iPoints));
    }

    public void applyStyles(Styles styles) {
    }

    protected void paint(KlighdPaintContext kpc) {
        this.graphics.setKlighdSWTGraphics((KlighdSWTGraphicsEx)kpc.getKlighdGraphics());
        try {
            this.figure.paint((Graphics)this.graphics);
        }
        catch (Throwable throwable) {
            String msg = "KLighD: Error occurred while drawing the custom connection figure " + this.figure.getClass().getName();
            Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd.piccolo", msg, throwable));
        }
    }
}

