/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.piccolo.draw2d;

import de.cau.cs.kieler.klighd.Klighd;
import de.cau.cs.kieler.klighd.krendering.KColor;
import de.cau.cs.kieler.klighd.piccolo.draw2d.GraphicsAdapter;
import de.cau.cs.kieler.klighd.piccolo.internal.KlighdSWTGraphicsEx;
import de.cau.cs.kieler.klighd.piccolo.internal.nodes.KCustomFigureNode;
import de.cau.cs.kieler.klighd.piccolo.internal.util.KlighdPaintContext;
import de.cau.cs.kieler.klighd.piccolo.internal.util.Styles;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class Draw2DNode
extends KCustomFigureNode {
    private static final long serialVersionUID = -1948310925725969628L;
    private Figure figure;
    private UpdateManager updateManager;
    private GraphicsAdapter graphics;
    private Color initialForeground = null;
    private Color initialBackground = null;
    private Float initialLineWidth = null;
    private Integer initialLineStyle = null;
    private final Rectangle2D singletonRectDouble = new Rectangle2D.Double();
    private final Rectangle singletonRectDraw2d = new Rectangle();

    public Draw2DNode(Figure theFigure) {
        if (theFigure == null) {
            String msg = "KLighD draw2d binding: Constructor of Draw2DNode has been called with argument of null. This is not allowed!";
            throw new IllegalArgumentException("KLighD draw2d binding: Constructor of Draw2DNode has been called with argument of null. This is not allowed!");
        }
        this.graphics = new GraphicsAdapter();
        this.updateManager = new WrappingUpdateManager((PNode)this);
        this.figure = new Figure(){

            public UpdateManager getUpdateManager() {
                return Draw2DNode.this.updateManager;
            }

            public boolean useLocalCoordinates() {
                return true;
            }

            public void paintFigure(Graphics theGraphics) {
                super.paintFigure(theGraphics);
            }
        };
        this.figure.add((IFigure)theFigure);
        this.figure.setLayoutManager((LayoutManager)new StackLayout());
        this.initialBackground = theFigure.getBackgroundColor();
        this.initialForeground = theFigure.getForegroundColor();
        if (theFigure instanceof Shape) {
            this.initialLineWidth = Float.valueOf(((Shape)theFigure).getLineWidthFloat());
            this.initialLineStyle = ((Shape)theFigure).getLineStyle();
        }
    }

    public boolean setBounds(double x, double y, double width, double height) {
        this.singletonRectDouble.setRect(x, y, width, height);
        java.awt.Rectangle intRect = this.singletonRectDouble.getBounds();
        this.singletonRectDraw2d.setBounds(intRect.x, intRect.y, intRect.width, intRect.height);
        this.figure.setBounds(this.singletonRectDraw2d);
        this.figure.validate();
        return super.setBounds(x, y, width, height);
    }

    public void applyStyles(Styles styles) {
        IFigure drawnFigure = (IFigure)this.figure.getChildren().get(0);
        if (styles.background != null) {
            KColor bgColor = styles.background.getColor();
            drawnFigure.setBackgroundColor(new Color(null, bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()));
        } else {
            drawnFigure.setBackgroundColor(this.initialBackground);
        }
        if (styles.foreground != null) {
            KColor fgColor = styles.foreground.getColor();
            drawnFigure.setForegroundColor(new Color(null, fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue()));
        } else {
            drawnFigure.setForegroundColor(this.initialForeground);
        }
        if (drawnFigure instanceof Shape) {
            Shape drawnShape = (Shape)drawnFigure;
            if (styles.lineWidth != null) {
                if (this.initialLineWidth == null) {
                    this.initialLineWidth = Float.valueOf(drawnShape.getLineWidthFloat());
                }
                drawnShape.setLineWidthFloat(styles.lineWidth.getLineWidth());
            } else if (this.initialLineWidth != null && this.initialLineWidth.floatValue() != drawnShape.getLineWidthFloat()) {
                drawnShape.setLineWidthFloat(this.initialLineWidth.floatValue());
            }
            if (styles.lineStyle != null) {
                if (this.initialLineStyle == null) {
                    this.initialLineStyle = drawnShape.getLineStyle();
                }
                drawnShape.setLineStyle(styles.lineStyle.getLineStyle().getValue());
            } else if (this.initialLineStyle != null && this.initialLineStyle.intValue() != drawnShape.getLineStyle()) {
                drawnShape.setLineStyle(this.initialLineStyle.intValue());
            }
        }
        this.invalidatePaint();
    }

    public void repaintFrom(PBounds localBounds, PNode childOrThis) {
        if (childOrThis == this) {
            int inset = -2;
            localBounds.inset(-2.0, -2.0);
        }
        super.repaintFrom(localBounds, childOrThis);
    }

    protected void paint(KlighdPaintContext kpc) {
        this.graphics.setKlighdSWTGraphics((KlighdSWTGraphicsEx)kpc.getKlighdGraphics());
        this.addSemanticData(kpc);
        try {
            this.figure.paint((Graphics)this.graphics);
        }
        catch (Throwable throwable) {
            String msg = "KLighD: Error occurred while drawing the diagram figure " + ((IFigure)this.figure.getChildren().get(0)).getClass().getName();
            Klighd.log((IStatus)new Status(4, "de.cau.cs.kieler.klighd.piccolo", msg, throwable));
        }
    }

    static final class WrappingUpdateManager
    extends DeferredUpdateManager {
        private PNode wrappingPNode;

        WrappingUpdateManager(PNode wrapper) {
            this.wrappingPNode = wrapper;
        }

        public void queueWork() {
        }

        protected Graphics getGraphics(Rectangle region) {
            return null;
        }
    }
}

