/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.krendering.extensions;

import com.google.common.base.Objects;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KRenderingLibrary;
import de.cau.cs.kieler.klighd.krendering.KRenderingRef;
import de.cau.cs.kieler.klighd.krendering.KStyleHolder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class KLibraryExtensions {
    @Extension
    private KRenderingFactory _kRenderingFactory = KRenderingFactory.eINSTANCE;

    public KRenderingLibrary getLibrary(KNode node) {
        KNode parent = node;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        KRenderingLibrary library = (KRenderingLibrary)parent.getData(KRenderingLibrary.class);
        if (library == null) {
            library = this._kRenderingFactory.createKRenderingLibrary();
            parent.getData().add((Object)library);
        }
        return library;
    }

    public KRenderingRef getFromLibrary(KRenderingLibrary library, String id) {
        Functions.Function1 _function = r -> {
            String _id = r.getId();
            return Objects.equal((Object)_id, (Object)id);
        };
        KStyleHolder _findFirst = (KStyleHolder)IterableExtensions.findFirst((Iterable)library.getRenderings(), (Functions.Function1)_function);
        KRendering rendering = (KRendering)_findFirst;
        if (rendering != null) {
            KRenderingRef ref = this._kRenderingFactory.createKRenderingRef();
            ref.setRendering(rendering);
            return ref;
        }
        return null;
    }

    public KRenderingRef getFromLibrary(KNode node, String id) {
        KRenderingLibrary library = this.getLibrary(node);
        return this.getFromLibrary(library, id);
    }

    public KRenderingRef addToLibrary(KRenderingLibrary library, String id, KRendering rendering) {
        rendering.setId(id);
        library.getRenderings().add((Object)rendering);
        KRenderingRef ref = this._kRenderingFactory.createKRenderingRef();
        ref.setRendering(rendering);
        return ref;
    }

    public KRenderingRef addToLibrary(KNode node, String id, KRendering rendering) {
        KRenderingLibrary library = this.getLibrary(node);
        return this.addToLibrary(library, id, rendering);
    }

    public KRenderingRef addRenderingRef(KGraphElement kge, KRendering rendering) {
        KRenderingRef _createKRenderingRef = this._kRenderingFactory.createKRenderingRef();
        Procedures.Procedure1 _function = ref -> {
            ref.setRendering(rendering);
            EList _data = kge.getData();
            _data.add(ref);
        };
        return (KRenderingRef)ObjectExtensions.operator_doubleArrow((Object)_createKRenderingRef, (Procedures.Procedure1)_function);
    }
}

