/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.krendering.extensions;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.klighd.krendering.KArc;
import de.cau.cs.kieler.klighd.krendering.KBackground;
import de.cau.cs.kieler.klighd.krendering.KChildArea;
import de.cau.cs.kieler.klighd.krendering.KColoring;
import de.cau.cs.kieler.klighd.krendering.KContainerRendering;
import de.cau.cs.kieler.klighd.krendering.KCustomRendering;
import de.cau.cs.kieler.klighd.krendering.KEllipse;
import de.cau.cs.kieler.klighd.krendering.KForeground;
import de.cau.cs.kieler.klighd.krendering.KGridPlacement;
import de.cau.cs.kieler.klighd.krendering.KGridPlacementData;
import de.cau.cs.kieler.klighd.krendering.KImage;
import de.cau.cs.kieler.klighd.krendering.KPlacement;
import de.cau.cs.kieler.klighd.krendering.KPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPolygon;
import de.cau.cs.kieler.klighd.krendering.KPolyline;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRectangle;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KRoundedRectangle;
import de.cau.cs.kieler.klighd.krendering.KStyle;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.krendering.LineJoin;
import de.cau.cs.kieler.klighd.krendering.extensions.KColorExtensions;
import de.cau.cs.kieler.klighd.krendering.extensions.KRenderingExtensions;
import de.cau.cs.kieler.klighd.krendering.extensions.PositionReferenceX;
import de.cau.cs.kieler.klighd.krendering.extensions.PositionReferenceY;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class KContainerRenderingExtensions {
    @Extension
    private KRenderingFactory _kRenderingFactory = KRenderingFactory.eINSTANCE;
    @Extension
    private KRenderingExtensions _kRenderingExtensions = new KRenderingExtensions();
    @Extension
    private KColorExtensions _kColorExtensions = new KColorExtensions();

    public <T extends KRendering> T addChild(KContainerRendering parent, T child) {
        Procedures.Procedure1 _function = it -> parent.getChildren().add(it);
        return (T)((KRendering)ObjectExtensions.operator_doubleArrow(child, (Procedures.Procedure1)_function));
    }

    public KChildArea addChildArea(KContainerRendering cr) {
        KChildArea _createKChildArea = this._kRenderingFactory.createKChildArea();
        Procedures.Procedure1 _function = it -> {
            cr.getChildren().removeAll((Collection)IterableExtensions.toList((Iterable)Iterables.filter((Iterable)cr.getChildren(), KChildArea.class)));
            cr.getChildren().add(it);
        };
        return (KChildArea)ObjectExtensions.operator_doubleArrow((Object)_createKChildArea, (Procedures.Procedure1)_function);
    }

    public KArc addArc(KContainerRendering cr) {
        KArc _createKArc = this._kRenderingFactory.createKArc();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
        };
        return (KArc)ObjectExtensions.operator_doubleArrow((Object)_createKArc, (Procedures.Procedure1)_function);
    }

    public KEllipse addEllipse(KContainerRendering cr) {
        KEllipse _createKEllipse = this._kRenderingFactory.createKEllipse();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
        };
        return (KEllipse)ObjectExtensions.operator_doubleArrow((Object)_createKEllipse, (Procedures.Procedure1)_function);
    }

    public KPolygon addPolygon(KContainerRendering cr) {
        KPolygon _createKPolygon = this._kRenderingFactory.createKPolygon();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
        };
        return (KPolygon)ObjectExtensions.operator_doubleArrow((Object)_createKPolygon, (Procedures.Procedure1)_function);
    }

    public KRectangle addRectangle(KContainerRendering cr) {
        KRectangle _createKRectangle = this._kRenderingFactory.createKRectangle();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
        };
        return (KRectangle)ObjectExtensions.operator_doubleArrow((Object)_createKRectangle, (Procedures.Procedure1)_function);
    }

    public KRoundedRectangle addRoundedRectangle(KContainerRendering cr, float cWidth, float cHeight) {
        KRoundedRectangle _createKRoundedRectangle = this._kRenderingFactory.createKRoundedRectangle();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
            it.setCornerWidth(cWidth);
            it.setCornerHeight(cHeight);
        };
        return (KRoundedRectangle)ObjectExtensions.operator_doubleArrow((Object)_createKRoundedRectangle, (Procedures.Procedure1)_function);
    }

    public KRoundedRectangle addRoundedRectangle(KContainerRendering cr, float cWidth, float cHeight, float lineWidth) {
        KRoundedRectangle _createKRoundedRectangle = this._kRenderingFactory.createKRoundedRectangle();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
            it.setCornerWidth(cWidth);
            it.setCornerHeight(cHeight);
            this._kRenderingExtensions.setLineWidth(it, lineWidth);
        };
        return (KRoundedRectangle)ObjectExtensions.operator_doubleArrow((Object)_createKRoundedRectangle, (Procedures.Procedure1)_function);
    }

    public KText addText(KContainerRendering cr, String text) {
        KText _createKText = this._kRenderingFactory.createKText();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
            it.setText(text);
        };
        return (KText)ObjectExtensions.operator_doubleArrow((Object)_createKText, (Procedures.Procedure1)_function);
    }

    public KImage addImage(KContainerRendering cr, String bundleId, String imagePath) {
        KImage _createKImage = this._kRenderingFactory.createKImage();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
            it.setBundleName(bundleId);
            it.setImagePath(imagePath);
        };
        return (KImage)ObjectExtensions.operator_doubleArrow((Object)_createKImage, (Procedures.Procedure1)_function);
    }

    public KImage addImage(KContainerRendering cr, Object imageObj) {
        KImage _createKImage = this._kRenderingFactory.createKImage();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
            it.setImageObject(imageObj);
        };
        return (KImage)ObjectExtensions.operator_doubleArrow((Object)_createKImage, (Procedures.Procedure1)_function);
    }

    public KRectangle addRectangularClip(KImage image) {
        KRectangle rect = this._kRenderingFactory.createKRectangle();
        image.setClipShape((KRendering)rect);
        return rect;
    }

    public KEllipse addEllipticalClip(KImage image) {
        KEllipse ellipse = this._kRenderingFactory.createKEllipse();
        image.setClipShape((KRendering)ellipse);
        return ellipse;
    }

    public KPolygon addPolygonClip(KImage image) {
        KPolygon polygon = this._kRenderingFactory.createKPolygon();
        image.setClipShape((KRendering)polygon);
        return polygon;
    }

    public KCustomRendering addCustomRendering(KContainerRendering cr) {
        KCustomRendering _createKCustomRendering = this._kRenderingFactory.createKCustomRendering();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
        };
        return (KCustomRendering)ObjectExtensions.operator_doubleArrow((Object)_createKCustomRendering, (Procedures.Procedure1)_function);
    }

    public KCustomRendering addCustomRendering(KContainerRendering cr, Object figureObject) {
        KCustomRendering _createKCustomRendering = this._kRenderingFactory.createKCustomRendering();
        Procedures.Procedure1 _function = it -> {
            EList _children = cr.getChildren();
            _children.add(it);
            it.setFigureObject(figureObject);
        };
        return (KCustomRendering)ObjectExtensions.operator_doubleArrow((Object)_createKCustomRendering, (Procedures.Procedure1)_function);
    }

    public KGridPlacement setGridPlacement(KContainerRendering cr, int cols) {
        KGridPlacement _createKGridPlacement = this._kRenderingFactory.createKGridPlacement();
        Procedures.Procedure1 _function = it -> {
            cr.setChildPlacement((KPlacement)it);
            it.setNumColumns(cols);
        };
        return (KGridPlacement)ObjectExtensions.operator_doubleArrow((Object)_createKGridPlacement, (Procedures.Procedure1)_function);
    }

    public KRectangle addGridBox(KContainerRendering cr, float widthHint, float heightHint, KPosition topLeft, KPosition bottomRight) {
        KRectangle _createKRectangle = this._kRenderingFactory.createKRectangle();
        Procedures.Procedure1 _function = it -> {
            cr.getChildren().add(it);
            KBackground _createKBackground = this._kRenderingFactory.createKBackground();
            Procedures.Procedure1 _function_1 = it_1 -> it_1.setAlpha(0);
            KBackground _doubleArrow = (KBackground)ObjectExtensions.operator_doubleArrow((Object)_createKBackground, (Procedures.Procedure1)_function_1);
            this._kRenderingExtensions.setBackground(it, (KColoring<?>)_doubleArrow);
            KForeground _createKForeground = this._kRenderingFactory.createKForeground();
            Procedures.Procedure1 _function_2 = it_1 -> it_1.setAlpha(0);
            KForeground _doubleArrow_1 = (KForeground)ObjectExtensions.operator_doubleArrow((Object)_createKForeground, (Procedures.Procedure1)_function_2);
            this._kRenderingExtensions.setForeground(it, (KColoring<?>)_doubleArrow_1);
            this._kRenderingExtensions.setGridPlacementData(it, widthHint, heightHint, topLeft, bottomRight);
        };
        return (KRectangle)ObjectExtensions.operator_doubleArrow((Object)_createKRectangle, (Procedures.Procedure1)_function);
    }

    public KPolyline addPolyline(KContainerRendering cr) {
        KPolyline _createKPolyline = this._kRenderingFactory.createKPolyline();
        Procedures.Procedure1 _function = it -> this.addChild(cr, it);
        return (KPolyline)ObjectExtensions.operator_doubleArrow((Object)_createKPolyline, (Procedures.Procedure1)_function);
    }

    public KPolyline addPolyline(KContainerRendering cr, float lineWidth) {
        KPolyline _createKPolyline = this._kRenderingFactory.createKPolyline();
        Procedures.Procedure1 _function = it -> {
            this.addChild(cr, it);
            this._kRenderingExtensions.setLineWidth(it, lineWidth);
        };
        return (KPolyline)ObjectExtensions.operator_doubleArrow((Object)_createKPolyline, (Procedures.Procedure1)_function);
    }

    public KPolyline addPolyline(KContainerRendering cr, float lineWidth, List<KPosition> points) {
        KPolyline _createKPolyline = this._kRenderingFactory.createKPolyline();
        Procedures.Procedure1 _function = it -> {
            this.addChild(cr, it);
            this._kRenderingExtensions.setLineWidth(it, lineWidth);
            EList _points = it.getPoints();
            Iterables.addAll((Collection)_points, (Iterable)points);
        };
        return (KPolyline)ObjectExtensions.operator_doubleArrow((Object)_createKPolyline, (Procedures.Procedure1)_function);
    }

    public KPolyline addHorizontalLine(KContainerRendering cr, float leftRightAbsIndent) {
        KPolyline _addChild = this.addChild(cr, this._kRenderingFactory.createKPolyline());
        Procedures.Procedure1 _function = it -> {
            this._kRenderingExtensions.setLineWidth(it, 1.0f);
            EList _points = it.getPoints();
            KPosition _createKPosition = this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, leftRightAbsIndent, 0.0f, this._kRenderingExtensions.TOP, 0.0f, 0.5f);
            _points.add((Object)_createKPosition);
            EList _points_1 = it.getPoints();
            KPosition _createKPosition_1 = this._kRenderingExtensions.createKPosition(PositionReferenceX.RIGHT, leftRightAbsIndent, 0.0f, this._kRenderingExtensions.TOP, 0.0f, 0.5f);
            _points_1.add((Object)_createKPosition_1);
        };
        return (KPolyline)ObjectExtensions.operator_doubleArrow((Object)_addChild, (Procedures.Procedure1)_function);
    }

    public KPolyline addHorizontalLine(KContainerRendering cr, float leftRightAbsIndent, float lineWidth) {
        KPolyline _addHorizontalLine = this.addHorizontalLine(cr, leftRightAbsIndent);
        return this._kRenderingExtensions.setLineWidth(_addHorizontalLine, lineWidth);
    }

    public KPolyline addHorizontalLine(KContainerRendering cr, PositionReferenceY y, float absIndent) {
        KPolyline _addChild = this.addChild(cr, this._kRenderingFactory.createKPolyline());
        Procedures.Procedure1 _function = it -> {
            this._kRenderingExtensions.setLineWidth(it, 1.0f);
            EList _points = it.getPoints();
            KPosition _createKPosition = this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, absIndent, 0.0f, y, 0.0f, 0.0f);
            _points.add((Object)_createKPosition);
            EList _points_1 = it.getPoints();
            KPosition _createKPosition_1 = this._kRenderingExtensions.createKPosition(PositionReferenceX.RIGHT, absIndent, 0.0f, y, 0.0f, 0.0f);
            _points_1.add((Object)_createKPosition_1);
        };
        return (KPolyline)ObjectExtensions.operator_doubleArrow((Object)_addChild, (Procedures.Procedure1)_function);
    }

    public KPolyline addHorizontalLine(KContainerRendering cr, PositionReferenceY y, float absIndent, float lineWidth) {
        KPolyline _addHorizontalLine = this.addHorizontalLine(cr, y, absIndent);
        return this._kRenderingExtensions.setLineWidth(_addHorizontalLine, lineWidth);
    }

    public KPolyline addVerticalLine(KContainerRendering cr, PositionReferenceX x, float absIndent) {
        KPolyline _addChild = this.addChild(cr, this._kRenderingFactory.createKPolyline());
        Procedures.Procedure1 _function = it -> {
            this._kRenderingExtensions.setLineWidth(it, 1.0f);
            EList _points = it.getPoints();
            KPosition _createKPosition = this._kRenderingExtensions.createKPosition(x, 0.0f, 0.0f, this._kRenderingExtensions.TOP, absIndent, 0.0f);
            _points.add((Object)_createKPosition);
            EList _points_1 = it.getPoints();
            KPosition _createKPosition_1 = this._kRenderingExtensions.createKPosition(x, 0.0f, 0.0f, this._kRenderingExtensions.BOTTOM, absIndent, 0.0f);
            _points_1.add((Object)_createKPosition_1);
        };
        return (KPolyline)ObjectExtensions.operator_doubleArrow((Object)_addChild, (Procedures.Procedure1)_function);
    }

    public KPolyline addVerticalLine(KContainerRendering cr, PositionReferenceX x, float absIndent, float lineWidth) {
        KPolyline _addVerticalLine = this.addVerticalLine(cr, x, absIndent);
        return this._kRenderingExtensions.setLineWidth(_addVerticalLine, lineWidth);
    }

    public KPolyline addHorizontalSeperatorLine(KContainerRendering cr, float lineWidth, int spacing) {
        KPolyline _createKPolyline = this._kRenderingFactory.createKPolyline();
        Procedures.Procedure1 _function = it -> {
            this.addChild(cr, it);
            this._kRenderingExtensions.setLineWidth(it, lineWidth);
            it.getPoints().add((Object)this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, 0.0f, 0.0f, PositionReferenceY.TOP, 0.0f, 0.5f));
            it.getPoints().add((Object)this._kRenderingExtensions.createKPosition(PositionReferenceX.RIGHT, 0.0f, 0.0f, PositionReferenceY.TOP, 0.0f, 0.5f));
            KGridPlacementData _createKGridPlacementData = this._kRenderingFactory.createKGridPlacementData();
            Procedures.Procedure1 _function_1 = it_1 -> it_1.setMinCellHeight(lineWidth + (float)spacing);
            KGridPlacementData _doubleArrow = (KGridPlacementData)ObjectExtensions.operator_doubleArrow((Object)_createKGridPlacementData, (Procedures.Procedure1)_function_1);
            it.setPlacementData((KPlacementData)_doubleArrow);
        };
        return (KPolyline)ObjectExtensions.operator_doubleArrow((Object)_createKPolyline, (Procedures.Procedure1)_function);
    }

    public KPolygon drawArrow(KContainerRendering cr) {
        KPolygon _createKPolygon = this._kRenderingFactory.createKPolygon();
        Procedures.Procedure1 _function = it -> {
            this._kRenderingExtensions.setLineJoin(this._kRenderingExtensions.setBackground(this._kRenderingExtensions.withCopyOf(this._kRenderingExtensions.withCopyOf(this.addChild(cr, it), (KStyle)this._kRenderingExtensions.getLineWidth((KRendering)cr)), (KStyle)this._kRenderingExtensions.getForeground((KRendering)cr)), (KColoring<?>)this._kRenderingExtensions.getForeground((KRendering)cr)), LineJoin.JOIN_ROUND);
            EList _points = it.getPoints();
            KPosition _createKPosition = this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, 0.0f, 0.0f, PositionReferenceY.TOP, 0.0f, 0.0f);
            _points.add((Object)_createKPosition);
            EList _points_1 = it.getPoints();
            KPosition _createKPosition_1 = this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, 0.0f, 0.4f, PositionReferenceY.TOP, 0.0f, 0.5f);
            _points_1.add((Object)_createKPosition_1);
            EList _points_2 = it.getPoints();
            KPosition _createKPosition_2 = this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, 0.0f, 0.0f, PositionReferenceY.BOTTOM, 0.0f, 0.0f);
            _points_2.add((Object)_createKPosition_2);
            EList _points_3 = it.getPoints();
            KPosition _createKPosition_3 = this._kRenderingExtensions.createKPosition(PositionReferenceX.RIGHT, 0.0f, 0.0f, PositionReferenceY.BOTTOM, 0.0f, 0.5f);
            _points_3.add((Object)_createKPosition_3);
        };
        return (KPolygon)ObjectExtensions.operator_doubleArrow((Object)_createKPolygon, (Procedures.Procedure1)_function);
    }

    public KPolygon drawTriangle(KContainerRendering cr) {
        KPolygon _createKPolygon = this._kRenderingFactory.createKPolygon();
        Procedures.Procedure1 _function = it -> {
            this._kRenderingExtensions.setBackground(this._kRenderingExtensions.withCopyOf(this._kRenderingExtensions.withCopyOf(this.addChild(cr, it), (KStyle)this._kRenderingExtensions.getLineWidth((KRendering)cr)), (KStyle)this._kRenderingExtensions.getForeground((KRendering)cr)), this._kColorExtensions.getColor("white"));
            EList _points = it.getPoints();
            KPosition _createKPosition = this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, 0.0f, 0.0f, PositionReferenceY.TOP, 0.0f, 0.0f);
            _points.add((Object)_createKPosition);
            EList _points_1 = it.getPoints();
            KPosition _createKPosition_1 = this._kRenderingExtensions.createKPosition(PositionReferenceX.LEFT, 0.0f, 0.0f, PositionReferenceY.BOTTOM, 0.0f, 0.0f);
            _points_1.add((Object)_createKPosition_1);
            EList _points_2 = it.getPoints();
            KPosition _createKPosition_2 = this._kRenderingExtensions.createKPosition(PositionReferenceX.RIGHT, 0.0f, 0.0f, PositionReferenceY.BOTTOM, 0.0f, 0.5f);
            _points_2.add((Object)_createKPosition_2);
        };
        return (KPolygon)ObjectExtensions.operator_doubleArrow((Object)_createKPolygon, (Procedures.Procedure1)_function);
    }
}

