/**
 * KIELER - Kiel Integrated Environment for Layout Eclipse RichClient
 * 
 * http://www.informatik.uni-kiel.de/rtsys/kieler/
 * 
 * Copyright 2012 by
 * + Kiel University
 *   + Department of Computer Science
 *     + Real-Time and Embedded Systems Group
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package de.cau.cs.kieler.klighd.krendering.extensions;

import com.google.inject.Inject;
import de.cau.cs.kieler.klighd.krendering.HorizontalAlignment;
import de.cau.cs.kieler.klighd.krendering.KDecoratorPlacementData;
import de.cau.cs.kieler.klighd.krendering.KEllipse;
import de.cau.cs.kieler.klighd.krendering.KPointPlacementData;
import de.cau.cs.kieler.klighd.krendering.KPolygon;
import de.cau.cs.kieler.klighd.krendering.KPolyline;
import de.cau.cs.kieler.klighd.krendering.KPosition;
import de.cau.cs.kieler.klighd.krendering.KRectangle;
import de.cau.cs.kieler.klighd.krendering.KRendering;
import de.cau.cs.kieler.klighd.krendering.KRenderingFactory;
import de.cau.cs.kieler.klighd.krendering.KText;
import de.cau.cs.kieler.klighd.krendering.KXPosition;
import de.cau.cs.kieler.klighd.krendering.KYPosition;
import de.cau.cs.kieler.klighd.krendering.LineCap;
import de.cau.cs.kieler.klighd.krendering.VerticalAlignment;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author chsch, alb
 * 
 * @containsExtensions
 */
@SuppressWarnings("all")
public class KPolylineExtensions {
  @Extension
  private KRenderingFactory _kRenderingFactory = KRenderingFactory.eINSTANCE;

  @Inject
  @Extension
  private KRenderingExtensions _kRenderingExtensions;

  @Inject
  @Extension
  private KContainerRenderingExtensions _kContainerRenderingExtensions;

  @Inject
  @Extension
  private KColorExtensions _kColorExtensions;

  private KRendering internalAddArrowDecorator(final KPolyline pl, final boolean head) {
    this._kRenderingExtensions.setLineCap(pl, LineCap.CAP_FLAT);
    KPolygon _drawArrow = this._kContainerRenderingExtensions.drawArrow(pl);
    final Procedure1<KPolygon> _function = (KPolygon it) -> {
      KDecoratorPlacementData _createKDecoratorPlacementData = this._kRenderingFactory.createKDecoratorPlacementData();
      final Procedure1<KDecoratorPlacementData> _function_1 = (KDecoratorPlacementData it_1) -> {
        it_1.setRotateWithLine(true);
        float _xifexpression = (float) 0;
        if (head) {
          _xifexpression = 1f;
        } else {
          _xifexpression = 0f;
        }
        it_1.setRelative(_xifexpression);
        float _xifexpression_1 = (float) 0;
        if (head) {
          _xifexpression_1 = (-2f);
        } else {
          _xifexpression_1 = 2f;
        }
        it_1.setAbsolute(_xifexpression_1);
        it_1.setWidth(8);
        it_1.setHeight(6);
        float _xifexpression_2 = (float) 0;
        if (head) {
          _xifexpression_2 = (-6f);
        } else {
          _xifexpression_2 = (-3f);
        }
        it_1.setXOffset(_xifexpression_2);
        float _xifexpression_3 = (float) 0;
        if (head) {
          _xifexpression_3 = (-3f);
        } else {
          _xifexpression_3 = (-4f);
        }
        it_1.setYOffset(_xifexpression_3);
      };
      KDecoratorPlacementData _doubleArrow = ObjectExtensions.<KDecoratorPlacementData>operator_doubleArrow(_createKDecoratorPlacementData, _function_1);
      it.setPlacementData(_doubleArrow);
      if ((!head)) {
        this._kRenderingExtensions.setRotation(it, Float.valueOf(180f));
      }
    };
    return ObjectExtensions.<KPolygon>operator_doubleArrow(_drawArrow, _function);
  }

  /**
   * @deprecated use {@link #addHeadArrowDecorator(KPolyline)} instead.
   */
  public KRendering addArrowDecorator(final KPolyline pl) {
    return this.internalAddArrowDecorator(pl, true);
  }

  public KRendering addHeadArrowDecorator(final KPolyline pl) {
    return this.internalAddArrowDecorator(pl, true);
  }

  public KRendering addTailArrowDecorator(final KPolyline pl) {
    return this.internalAddArrowDecorator(pl, false);
  }

  public KRendering addJunctionPointDecorator(final KPolyline pl) {
    KEllipse _createKEllipse = this._kRenderingFactory.createKEllipse();
    final Procedure1<KEllipse> _function = (KEllipse it) -> {
      this._kRenderingExtensions.setBackground(it, this._kColorExtensions.getColor("black"));
      KPointPlacementData _createKPointPlacementData = this._kRenderingFactory.createKPointPlacementData();
      final Procedure1<KPointPlacementData> _function_1 = (KPointPlacementData it_1) -> {
        it_1.setHorizontalAlignment(HorizontalAlignment.CENTER);
        it_1.setVerticalAlignment(VerticalAlignment.CENTER);
        it_1.setMinWidth(4);
        it_1.setMinHeight(4);
      };
      KPointPlacementData _doubleArrow = ObjectExtensions.<KPointPlacementData>operator_doubleArrow(_createKPointPlacementData, _function_1);
      it.setPlacementData(_doubleArrow);
    };
    KEllipse _doubleArrow = ObjectExtensions.<KEllipse>operator_doubleArrow(_createKEllipse, _function);
    pl.setJunctionPointRendering(_doubleArrow);
    return pl.getJunctionPointRendering();
  }

  public KRendering setJunctionPointDecorator(final KPolyline pl, final KRendering decorator, final float width, final float height) {
    final Procedure1<KRendering> _function = (KRendering it) -> {
      this._kRenderingExtensions.setBackground(it, this._kColorExtensions.getColor("black"));
      KPointPlacementData _createKPointPlacementData = this._kRenderingFactory.createKPointPlacementData();
      final Procedure1<KPointPlacementData> _function_1 = (KPointPlacementData it_1) -> {
        it_1.setHorizontalAlignment(HorizontalAlignment.CENTER);
        it_1.setVerticalAlignment(VerticalAlignment.CENTER);
        it_1.setMinWidth(width);
        it_1.setMinHeight(height);
      };
      KPointPlacementData _doubleArrow = ObjectExtensions.<KPointPlacementData>operator_doubleArrow(_createKPointPlacementData, _function_1);
      it.setPlacementData(_doubleArrow);
    };
    KRendering _doubleArrow = ObjectExtensions.<KRendering>operator_doubleArrow(decorator, _function);
    pl.setJunctionPointRendering(_doubleArrow);
    return decorator;
  }

  public KRendering addInheritanceTriangleArrowDecorator(final KPolyline pl) {
    KPolygon _drawTriangle = this._kContainerRenderingExtensions.drawTriangle(pl);
    final Procedure1<KPolygon> _function = (KPolygon it) -> {
      KDecoratorPlacementData _createKDecoratorPlacementData = this._kRenderingFactory.createKDecoratorPlacementData();
      final Procedure1<KDecoratorPlacementData> _function_1 = (KDecoratorPlacementData it_1) -> {
        final float scale = this._kRenderingExtensions.getLineWidth(pl).getLineWidth();
        final float modifiedScale = Double.valueOf(Math.sqrt((3 * scale))).floatValue();
        it_1.setRotateWithLine(true);
        it_1.setRelative(1f);
        it_1.setAbsolute(((-5f) * modifiedScale));
        it_1.setWidth((10 * modifiedScale));
        it_1.setHeight((10 * modifiedScale));
        it_1.setXOffset(((-5f) * modifiedScale));
        float _height = it_1.getHeight();
        float _minus = (-_height);
        float _divide = (_minus / 2);
        it_1.setYOffset(_divide);
      };
      KDecoratorPlacementData _doubleArrow = ObjectExtensions.<KDecoratorPlacementData>operator_doubleArrow(_createKDecoratorPlacementData, _function_1);
      it.setPlacementData(_doubleArrow);
    };
    return ObjectExtensions.<KPolygon>operator_doubleArrow(_drawTriangle, _function);
  }

  public KPolyline addKPosition(final KPolyline pl, final PositionReferenceX px, final float absoluteLR, final float relativeLR, final PositionReferenceY py, final float absoluteTB, final float relativeTB) {
    final Procedure1<KPolyline> _function = (KPolyline it) -> {
      EList<KPosition> _points = pl.getPoints();
      KPosition _createKPosition = this._kRenderingExtensions.createKPosition(px, absoluteLR, relativeLR, py, absoluteTB, relativeTB);
      _points.add(_createKPosition);
    };
    return ObjectExtensions.<KPolyline>operator_doubleArrow(pl, _function);
  }

  public KPosition addKPosition(final KPolyline pl, final KXPosition<?> xPos, final KYPosition<?> yPos) {
    KPosition _createKPosition = this._kRenderingFactory.createKPosition();
    final Procedure1<KPosition> _function = (KPosition it) -> {
      it.setX(xPos);
      it.setY(yPos);
      EList<KPosition> _points = pl.getPoints();
      _points.add(it);
    };
    return ObjectExtensions.<KPosition>operator_doubleArrow(_createKPosition, _function);
  }

  /**
   * Experimental!
   * 
   * This way only works if the polyline leaves to the right side.
   */
  public KRendering addBoxedTextDecorator(final KPolyline pl, final KText text, final float textWidth, final float textHeight) {
    KRectangle _addRectangle = this._kContainerRenderingExtensions.addRectangle(pl);
    final Procedure1<KRectangle> _function = (KRectangle rect) -> {
      this._kRenderingExtensions.setBackground(rect, this._kColorExtensions.getColor("white"));
      text.setParent(rect);
      KDecoratorPlacementData _createKDecoratorPlacementData = this._kRenderingFactory.createKDecoratorPlacementData();
      final Procedure1<KDecoratorPlacementData> _function_1 = (KDecoratorPlacementData it) -> {
        it.setRelative(0f);
        it.setAbsolute(0f);
        it.setWidth(textWidth);
        it.setHeight(textHeight);
        it.setYOffset(((-textHeight) / 2));
      };
      KDecoratorPlacementData _doubleArrow = ObjectExtensions.<KDecoratorPlacementData>operator_doubleArrow(_createKDecoratorPlacementData, _function_1);
      rect.setPlacementData(_doubleArrow);
    };
    return ObjectExtensions.<KRectangle>operator_doubleArrow(_addRectangle, _function);
  }
}
