/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.kgraph.util;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.klighd.kgraph.EMapPropertyHolder;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KGraphFactory;
import de.cau.cs.kieler.klighd.kgraph.KIdentifier;
import de.cau.cs.kieler.klighd.kgraph.KInsets;
import de.cau.cs.kieler.klighd.kgraph.KLabel;
import de.cau.cs.kieler.klighd.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.kgraph.KShapeLayout;
import de.cau.cs.kieler.klighd.kgraph.util.DefaultSelectionIterator;
import de.cau.cs.kieler.klighd.kgraph.util.SelectionIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;

public final class KGraphUtil {
    private static final KGraphFactory FACTORY = KGraphFactory.eINSTANCE;
    public static final float DEFAULT_MIN_WIDTH = 20.0f;
    public static final float DEFAULT_MIN_HEIGHT = 20.0f;

    private KGraphUtil() {
        throw new IllegalAccessError();
    }

    public static KNode createInitializedNode() {
        KNode node = FACTORY.createKNode();
        node.setInsets(FACTORY.createKInsets());
        return node;
    }

    public static KPort createInitializedPort() {
        KPort port = FACTORY.createKPort();
        port.setInsets(FACTORY.createKInsets());
        return port;
    }

    public static KLabel createInitializedLabel(KLabeledGraphElement element) {
        KLabel label = FACTORY.createKLabel();
        label.setInsets(FACTORY.createKInsets());
        label.setText("");
        label.setParent(element);
        return label;
    }

    public static KEdge createInitializedEdge() {
        KEdge edge = FACTORY.createKEdge();
        edge.setSourcePoint(FACTORY.createKPoint());
        edge.setTargetPoint(FACTORY.createKPoint());
        return edge;
    }

    public static void validate(KNode graph) {
        Iterator contentIter = Iterators.concat(Lists.newArrayList((Object[])new KNode[]{graph}).iterator(), (Iterator)Iterators.filter((Iterator)graph.eAllContents(), KGraphElement.class));
        while (contentIter.hasNext()) {
            KPort targetPort;
            KPort sourcePort;
            EObject element = (EObject)contentIter.next();
            if (element instanceof KNode) {
                KNode node = (KNode)element;
                if (node.getInsets() != null) continue;
                node.setInsets(FACTORY.createKInsets());
                continue;
            }
            if (!(element instanceof KEdge)) continue;
            KEdge edge = (KEdge)element;
            if (edge.getSourcePoint() == null) {
                edge.setSourcePoint(FACTORY.createKPoint());
            }
            if (edge.getTargetPoint() == null) {
                edge.setTargetPoint(FACTORY.createKPoint());
            }
            if ((sourcePort = edge.getSourcePort()) != null && !sourcePort.getEdges().contains((Object)edge)) {
                sourcePort.getEdges().add((Object)edge);
            }
            if ((targetPort = edge.getTargetPort()) == null || targetPort.getEdges().contains((Object)edge)) continue;
            targetPort.getEdges().add((Object)edge);
        }
    }

    public static void configureWithDefaultLabel(KLabeledGraphElement ele) {
        KGraphUtil.ensureLabel(ele);
        if (ele instanceof KNode && !ele.getProperties().containsKey((Object)CoreOptions.NODE_LABELS_PLACEMENT)) {
            if (((KNode)ele).getChildren().isEmpty()) {
                ele.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, NodeLabelPlacement.insideCenter());
            } else {
                ele.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, NodeLabelPlacement.insideTopCenter());
            }
        }
    }

    public static void configurWithDefaultSize(KShapeLayout ele) {
        KPort port;
        if (ele instanceof KNode) {
            KNode node = (KNode)ele;
            Set sc = (Set)node.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
            if (sc.equals(SizeConstraint.fixed()) && node.getWidth() == 0.0f && node.getHeight() == 0.0f) {
                node.setWidth(40.0f);
                node.setHeight(40.0f);
            }
        } else if (ele instanceof KPort && (port = (KPort)ele) != null && port.getWidth() == 0.0f && port.getHeight() == 0.0f) {
            port.setWidth(5.0f);
            port.setHeight(5.0f);
        }
    }

    public static void configureWithDefaultValues(KNode node) {
        Set sc = (Set)node.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        if (sc.equals(SizeConstraint.fixed()) && node.getWidth() == 0.0f && node.getHeight() == 0.0f) {
            node.setWidth(80.0f);
            node.setHeight(80.0f);
        }
        KGraphUtil.ensureLabel(node);
        if (!node.getProperties().containsKey((Object)CoreOptions.NODE_LABELS_PLACEMENT)) {
            if (node.getChildren().isEmpty()) {
                node.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, NodeLabelPlacement.insideCenter());
            } else {
                node.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, NodeLabelPlacement.insideTopCenter());
            }
        }
    }

    public static void configureWithDefaultValues(KPort port) {
        if (port != null && port.getWidth() == 0.0f && port.getHeight() == 0.0f) {
            port.setWidth(5.0f);
            port.setHeight(5.0f);
        }
        KGraphUtil.ensureLabel(port);
    }

    private static void ensureLabel(KLabeledGraphElement element) {
        KIdentifier id;
        if (element.getLabels().isEmpty() && (id = element.getData(KIdentifier.class)) != null && !Strings.isNullOrEmpty((String)id.getId())) {
            KLabel label = KGraphUtil.createInitializedLabel(element);
            label.setText(id.getId());
        }
    }

    public static void persistDataElements(KNode graph) {
        PersistentEntriesSkippingTreeIterator iterator = new PersistentEntriesSkippingTreeIterator(graph, true);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof EMapPropertyHolder)) continue;
            ((EMapPropertyHolder)eObject).makePersistent();
        }
    }

    public static KVector toAbsolute(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KInsets insets = node.getInsets();
            point.add((double)(node.getXpos() + insets.getLeft()), (double)(node.getYpos() + insets.getTop()));
            node = node.getParent();
        }
        return point;
    }

    public static KVector toRelative(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KInsets insets = node.getInsets();
            point.add((double)(-node.getXpos() - insets.getLeft()), (double)(-node.getYpos() - insets.getTop()));
            node = node.getParent();
        }
        return point;
    }

    /*
     * Unable to fully structure code
     */
    public static KVector getAbsolute(KGraphElement element) {
        parent = element;
        while (!(element instanceof KShapeLayout) && parent != null) {
            parent = parent.eContainer();
        }
        if (parent == null) {
            return null;
        }
        absolutePosition = new KVector((double)((KShapeLayout)parent).getXpos(), (double)((KShapeLayout)parent).getYpos());
        parent = parent.eContainer();
        ** GOTO lbl20
        {
            parent = parent.eContainer();
            do {
                if (!(parent instanceof KShapeLayout) && parent != null) continue block1;
                if (parent == null) continue;
                insets = ((KShapeLayout)parent).getInsets();
                absolutePosition.add((double)insets.getLeft(), (double)insets.getTop());
                absolutePosition.add((double)((KShapeLayout)parent).getXpos(), (double)((KShapeLayout)parent).getYpos());
                parent = parent.eContainer();
lbl20:
                // 3 sources

            } while (parent != null);
        }
        return absolutePosition;
    }

    public static PortSide calcPortSide(KPort port, Direction direction) {
        KNode node = port.getNode();
        if (node == null) {
            throw new IllegalArgumentException("port must be assigned to a node");
        }
        float nodeWidth = node.getWidth();
        float nodeHeight = node.getHeight();
        if (nodeWidth <= 0.0f && nodeHeight <= 0.0f) {
            return PortSide.UNDEFINED;
        }
        float xpos = port.getXpos();
        float ypos = port.getYpos();
        switch (direction) {
            case RIGHT: 
            case LEFT: {
                if (xpos < 0.0f) {
                    return PortSide.WEST;
                }
                if (!(xpos + port.getWidth() > nodeWidth)) break;
                return PortSide.EAST;
            }
            case DOWN: 
            case UP: {
                if (ypos < 0.0f) {
                    return PortSide.NORTH;
                }
                if (!(ypos + port.getHeight() > nodeHeight)) break;
                return PortSide.SOUTH;
            }
        }
        float widthPercent = (xpos + port.getWidth() / 2.0f) / nodeWidth;
        float heightPercent = (ypos + port.getHeight() / 2.0f) / nodeHeight;
        if (widthPercent + heightPercent <= 1.0f && widthPercent - heightPercent <= 0.0f) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0f && widthPercent - heightPercent >= 0.0f) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5f) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    public static void toKGraphCoordinateSystem(ElkEdge elkedge, KInsets insets) {
        if (elkedge.getSources().size() != 1 || elkedge.getTargets().size() != 1) {
            throw new IllegalArgumentException("Edge must have exactly one source and one target");
        }
        ElkNode source = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getSources().get(0)));
        ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getTargets().get(0)));
        ElkNode coordinateOrigin = ElkGraphUtil.isDescendant((ElkNode)target, (ElkNode)source) ? source : source.getParent();
        KVector offset = new KVector();
        if (coordinateOrigin != elkedge.getContainingNode()) {
            ElkUtil.toAbsolute((KVector)offset, (ElkNode)elkedge.getContainingNode());
            ElkUtil.toRelative((KVector)offset, (ElkNode)coordinateOrigin);
        }
        if (insets != null) {
            offset.sub((double)insets.getLeft(), (double)insets.getTop());
        }
        ElkUtil.translate((ElkEdge)elkedge, (double)offset.x, (double)offset.y);
    }

    public static void toELKGraphCoordinateSystem(ElkEdge elkedge, KInsets insets) {
        if (elkedge.getSources().size() != 1 || elkedge.getTargets().size() != 1) {
            throw new IllegalArgumentException("Edge must have exactly one source and one target");
        }
        ElkNode source = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getSources().get(0)));
        ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getTargets().get(0)));
        ElkNode coordinateOrigin = ElkGraphUtil.isDescendant((ElkNode)target, (ElkNode)source) ? source : source.getParent();
        KVector offset = new KVector();
        if (coordinateOrigin != elkedge.getContainingNode()) {
            ElkUtil.toAbsolute((KVector)offset, (ElkNode)coordinateOrigin);
            ElkUtil.toRelative((KVector)offset, (ElkNode)elkedge.getContainingNode());
        }
        if (insets != null) {
            offset.add((double)insets.getLeft(), (double)insets.getTop());
        }
        ElkUtil.translate((ElkEdge)elkedge, (double)offset.x, (double)offset.y);
    }

    public static Iterator<KEdge> getConnectedEdges(Iterable<KEdge> edges) {
        return Iterators.concat((Iterator)Iterators.transform(edges.iterator(), (Function)new Function<KEdge, Iterator<KEdge>>(){

            public Iterator<KEdge> apply(KEdge kedge) {
                return KGraphUtil.getConnectedEdges(kedge);
            }
        }));
    }

    public static Iterator<KEdge> getConnectedEdges(KEdge edge) {
        return Iterators.filter(KGraphUtil.getConnectedElements(edge, false), KEdge.class);
    }

    public static Iterator<KGraphElement> getConnectedElements(KEdge edge, boolean addPorts) {
        DefaultSelectionIterator sourceSideIt = new DefaultSelectionIterator(edge, addPorts, false);
        DefaultSelectionIterator targetSideIt = new DefaultSelectionIterator(edge, addPorts, true);
        return KGraphUtil.getConnectedElements(edge, sourceSideIt, targetSideIt);
    }

    public static Iterator<KGraphElement> getConnectedElements(KEdge kedge, SelectionIterator sourceIterator, SelectionIterator targetIterator) {
        SelectionIterator targetSideIt;
        SelectionIterator sourceSideIt;
        UnmodifiableIterator kedgeIt = Iterators.singletonIterator((Object)kedge);
        HashSet visited = Sets.newHashSet();
        SelectionIterator selectionIterator = sourceSideIt = kedge.getSourcePort() == null ? null : sourceIterator;
        if (sourceSideIt != null) {
            sourceSideIt.attachVisitedSet(visited);
        }
        SelectionIterator selectionIterator2 = targetSideIt = kedge.getTargetPort() == null ? null : targetIterator;
        if (targetSideIt != null) {
            targetSideIt.attachVisitedSet(visited);
        }
        SelectionIterator connectedEdges = sourceSideIt == null ? targetSideIt : (targetSideIt == null ? sourceSideIt : Iterators.concat((Iterator)((Object)sourceSideIt), (Iterator)((Object)targetSideIt)));
        return connectedEdges == null ? kedgeIt : Iterators.concat((Iterator)kedgeIt, (Iterator)((Object)connectedEdges));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isDescendant(KNode child, KNode parent) {
        current = child;
        if (current != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if ((current = current.getParent()) != parent) continue;
            return true;
lbl6:
            // 2 sources

            ** while (current.getParent() != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public static boolean isDescendant(KGraphElement child, KNode parent) {
        KGraphElement current = child;
        while (current.eContainer() != null) {
            if ((current = current.eContainer()) != parent) continue;
            return true;
        }
        return false;
    }

    public static KNode containedGraph(KEdge edge) {
        return KGraphUtil.isDescendant(edge.getTarget(), edge.getSource()) ? edge.getSource() : edge.getSource().getParent();
    }

    public static boolean isSibling(KNode node1, KNode node2) {
        return node1.getParent() == node2.getParent() && node1.getParent() != null;
    }

    public static KNode getRootNodeOf(KNode node) {
        KNode parent = node;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static List<KNode> getAdjacentNodes(KNode node) {
        EList<KEdge> inEdges = node.getIncomingEdges();
        EList<KEdge> outEdges = node.getOutgoingEdges();
        ArrayList<KNode> adjacentNodes = new ArrayList<KNode>();
        for (KEdge e : inEdges) {
            adjacentNodes.add(e.getSource());
        }
        for (KEdge e : outEdges) {
            adjacentNodes.add(e.getTarget());
        }
        return adjacentNodes;
    }

    public static class PersistentEntriesSkippingTreeIterator
    extends AbstractTreeIterator<EObject> {
        private static final long serialVersionUID = 1L;

        public PersistentEntriesSkippingTreeIterator(Object object, boolean includeRoot) {
            super(object, includeRoot);
        }

        protected Iterator<? extends EObject> getChildren(Object object) {
            Iterator iterator = ((EObject)object).eContents().iterator();
            if (iterator instanceof EContentsEList.FeatureIteratorImpl) {
                ((EContentsEList.FeatureIteratorImpl)iterator).filter(new EContentsEList.FeatureFilter(){

                    public boolean isIncluded(EStructuralFeature eStructuralFeature) {
                        if (eStructuralFeature.getContainerClass().equals(EMapPropertyHolder.class)) {
                            return eStructuralFeature.getFeatureID() != 1;
                        }
                        return true;
                    }
                });
            }
            return iterator;
        }
    }
}

