/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.kgraph.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.klighd.kgraph.EMapPropertyHolder;
import de.cau.cs.kieler.klighd.kgraph.KLayoutData;
import de.cau.cs.kieler.klighd.kgraph.KNode;
import de.cau.cs.kieler.klighd.kgraph.PersistentEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.internal.LayoutOptionProxy;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;

public final class KGraphDataUtil {
    public static final Predicate<EMapPropertyHolder> PREDICATE_IS_KLAYOUTDATA = new Predicate<EMapPropertyHolder>(){

        public boolean apply(EMapPropertyHolder input) {
            return input instanceof KLayoutData;
        }
    };

    private KGraphDataUtil() {
    }

    public static void setOption(IPropertyHolder propertyHolder, String id, String value) {
        Object obj;
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(id);
        if (optionData != null && (obj = optionData.parseValue(value)) != null) {
            propertyHolder.setProperty((IProperty)optionData, obj);
        }
    }

    public static void loadDataElements(KNode graph, IProperty<?> ... knownProps) {
        KGraphDataUtil.loadDataElements(graph, PREDICATE_IS_KLAYOUTDATA, false, knownProps);
    }

    public static void loadDataElements(KNode graph, boolean clearProperties, IProperty<?> ... knownProps) {
        KGraphDataUtil.loadDataElements(graph, PREDICATE_IS_KLAYOUTDATA, clearProperties, knownProps);
    }

    public static KNode loadDataElements(KNode graph, Predicate<EMapPropertyHolder> handledTypes, IProperty<?> ... knownProps) {
        return KGraphDataUtil.loadDataElements(graph, handledTypes, false, knownProps);
    }

    public static KNode loadDataElements(KNode graph, Predicate<EMapPropertyHolder> handledTypes, boolean clearProperties, IProperty<?> ... knownProps) {
        HashMap knowPropsMap = Maps.newHashMap();
        IProperty<?>[] iPropertyArray = knownProps;
        int n = knownProps.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty<?> p = iPropertyArray[n2];
            knowPropsMap.put(p.getId(), p);
            ++n2;
        }
        LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
        PropertiesSkippingTreeIterator iterator = new PropertiesSkippingTreeIterator(graph, true);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof EMapPropertyHolder) || !handledTypes.apply((Object)((EMapPropertyHolder)eObject))) continue;
            EMapPropertyHolder holder = (EMapPropertyHolder)eObject;
            if (clearProperties && holder.getProperties() != null) {
                holder.getProperties().clear();
            }
            for (PersistentEntry persistentEntry : holder.getPersistentEntries()) {
                KGraphDataUtil.loadDataElement(dataService, holder, persistentEntry.getKey(), persistentEntry.getValue(), knowPropsMap);
            }
        }
        return graph;
    }

    public static void loadDataElement(LayoutMetaDataService dataService, IPropertyHolder propertyHolder, String id, String value) {
        Map empty = Collections.emptyMap();
        KGraphDataUtil.loadDataElement(dataService, propertyHolder, id, value, empty);
    }

    public static void loadDataElement(LayoutMetaDataService dataService, IPropertyHolder propertyHolder, String id, String value, Map<String, ? extends IProperty<?>> knownProps) {
        if (id != null && value != null) {
            LayoutOptionData layoutOptionData = dataService.getOptionDataBySuffix(id);
            if (layoutOptionData != null) {
                Object layoutOptionValue = layoutOptionData.parseValue(value);
                if (layoutOptionValue != null) {
                    propertyHolder.setProperty((IProperty)layoutOptionData, layoutOptionValue);
                }
            } else if (knownProps.containsKey(id)) {
                Object parsed = KGraphDataUtil.parseSimpleDatatypes(value);
                IProperty<?> unchecked = knownProps.get(id);
                propertyHolder.setProperty(unchecked, parsed);
            } else {
                LayoutOptionProxy.setProxyValue((IPropertyHolder)propertyHolder, (String)id, (String)value);
            }
        }
    }

    private static Object parseSimpleDatatypes(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException2) {
                if (value.toLowerCase().equals(Boolean.FALSE.toString())) {
                    return false;
                }
                if (value.toLowerCase().equals(Boolean.TRUE.toString())) {
                    return true;
                }
                return value;
            }
        }
    }

    public static class PropertiesSkippingTreeIterator
    extends AbstractTreeIterator<EObject> {
        private static final long serialVersionUID = 1L;

        public PropertiesSkippingTreeIterator(Object object, boolean includeRoot) {
            super(object, includeRoot);
        }

        protected Iterator<? extends EObject> getChildren(Object object) {
            Iterator iterator = ((EObject)object).eContents().iterator();
            if (iterator instanceof EContentsEList.FeatureIteratorImpl) {
                ((EContentsEList.FeatureIteratorImpl)iterator).filter(new EContentsEList.FeatureFilter(){

                    public boolean isIncluded(EStructuralFeature eStructuralFeature) {
                        if (eStructuralFeature.getContainerClass().equals(EMapPropertyHolder.class)) {
                            return eStructuralFeature.getFeatureID() != 0;
                        }
                        return true;
                    }
                });
            }
            return iterator;
        }
    }
}

