/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klighd.kgraph.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.klighd.kgraph.KEdge;
import de.cau.cs.kieler.klighd.kgraph.KGraphElement;
import de.cau.cs.kieler.klighd.kgraph.KPort;
import de.cau.cs.kieler.klighd.kgraph.util.SelectionIterator;
import java.util.Collections;
import java.util.Iterator;

public class DefaultSelectionIterator
extends SelectionIterator {
    private static final long serialVersionUID = 2945508835051993888L;
    private boolean addPorts;
    private boolean followEdgeDirection;

    public DefaultSelectionIterator(KEdge edge, boolean addPorts, boolean followEdgeDirection) {
        super(edge);
        this.addPorts = addPorts;
        this.followEdgeDirection = followEdgeDirection;
    }

    protected Iterator<? extends KGraphElement> getChildren(Object object) {
        if (this.visited == null) {
            this.visited = Sets.newHashSet();
        }
        if (object instanceof KEdge) {
            KPort port;
            KEdge edge = (KEdge)object;
            KPort kPort = port = this.followEdgeDirection ? edge.getTargetPort() : edge.getSourcePort();
            if (port == null || this.visited.contains(port)) {
                return Collections.emptyIterator();
            }
            this.visited.add(port);
            UnmodifiableIterator resultEdges = Iterators.filter((Iterator)port.getEdges().iterator(), (Predicate)new Predicate<KEdge>(){

                public boolean apply(KEdge input) {
                    return DefaultSelectionIterator.this.followEdgeDirection ? port == input.getSourcePort() : port == input.getTargetPort();
                }
            });
            if (this.addPorts) {
                UnmodifiableIterator portIterator = Iterators.singletonIterator((Object)port);
                return Iterators.concat((Iterator)portIterator, (Iterator)resultEdges);
            }
            return resultEdges;
        }
        return Collections.emptyIterator();
    }
}

