/*
 * I18N resource strings
 *
 * Generated on 11.01.2017 21:12:14
 */
package de.carne.jfx.scene.control;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * Package localization resources.
 */
public final class AlertsI18N {

	/**
	 * The BUNDLE represented by this class.
	 */
	public static final ResourceBundle BUNDLE = ResourceBundle.getBundle(AlertsI18N.class.getName());

	/**
	 * Format a resource string.
	 * @param key The resource key.
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String format(String key, Object... arguments) {
		String pattern = BUNDLE.getString(key);

		return (arguments.length > 0 ? MessageFormat.format(pattern, arguments) : pattern);
	}

	/**
	 * Resource key {@code STR_MESSAGE_APPLICATION_ERROR}
	 * <p>
	 * Application error 
	 */
	public static final String STR_MESSAGE_APPLICATION_ERROR = "STR_MESSAGE_APPLICATION_ERROR";

	/**
	 * Resource string {@code STR_MESSAGE_APPLICATION_ERROR}
	 * <p>
	 * Application error 
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_MESSAGE_APPLICATION_ERROR(Object... arguments) {
		return format(STR_MESSAGE_APPLICATION_ERROR, arguments);
	}

	/**
	 * Resource key {@code STR_MESSAGE_UNEXPECTED_ERROR}
	 * <p>
	 * An unexpected error occurred. 
	 */
	public static final String STR_MESSAGE_UNEXPECTED_ERROR = "STR_MESSAGE_UNEXPECTED_ERROR";

	/**
	 * Resource string {@code STR_MESSAGE_UNEXPECTED_ERROR}
	 * <p>
	 * An unexpected error occurred. 
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_MESSAGE_UNEXPECTED_ERROR(Object... arguments) {
		return format(STR_MESSAGE_UNEXPECTED_ERROR, arguments);
	}

}
