/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.constant;

import de.carne.mcd.jvmdecoder.classfile.ClassContext;
import de.carne.mcd.jvmdecoder.classfile.ClassInfo;
import de.carne.mcd.jvmdecoder.classfile.ClassPrinter;
import de.carne.mcd.jvmdecoder.classfile.constant.Constant;
import de.carne.mcd.jvmdecoder.classfile.constant.Utf8Constant;
import de.carne.util.Strings;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class StringConstant
extends Constant {
    public static final int TAG = 8;
    private int stringIndex;

    public StringConstant(ClassInfo classInfo, int stringIndex) {
        super(classInfo);
        this.stringIndex = stringIndex;
    }

    public String getValue() throws IOException {
        return this.classInfo.resolveConstant(this.stringIndex, Utf8Constant.class).getValue();
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        this.classInfo.resolveConstant(this.stringIndex, Utf8Constant.class).print(out, context);
    }

    @Override
    public @NonNull String resolveSymbol() throws IOException {
        return "\"" + Strings.encode((CharSequence)this.getValue()) + "\"";
    }

    public String toString() {
        return "#" + this.stringIndex;
    }
}

