/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.constant;

import de.carne.mcd.jvmdecoder.classfile.ClassContext;
import de.carne.mcd.jvmdecoder.classfile.ClassInfo;
import de.carne.mcd.jvmdecoder.classfile.ClassPrinter;
import de.carne.mcd.jvmdecoder.classfile.PrintBuffer;
import de.carne.mcd.jvmdecoder.classfile.PrintSeparator;
import de.carne.mcd.jvmdecoder.classfile.constant.Constant;
import de.carne.mcd.jvmdecoder.classfile.constant.Utf8Constant;
import de.carne.mcd.jvmdecoder.classfile.decl.DeclDecoder;
import de.carne.mcd.jvmdecoder.classfile.decl.DecodedMethodDescriptor;
import de.carne.util.Check;
import java.io.IOException;

public class MethodTypeConstant
extends Constant {
    public static final int TAG = 16;
    private final int descriptorIndex;

    public MethodTypeConstant(ClassInfo classInfo, int descriptorIndex) {
        super(classInfo);
        this.descriptorIndex = descriptorIndex;
    }

    @Override
    public void print(ClassPrinter out, ClassContext context) throws IOException {
        Check.fail();
    }

    @Override
    public String resolveSymbol() throws IOException {
        String descriptor = this.classInfo.resolveConstant(this.descriptorIndex, Utf8Constant.class).getValue();
        DecodedMethodDescriptor method = DeclDecoder.decodeMethodDescriptor(descriptor, this.classInfo.thisClass().getPackageName());
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.returnType()).append(' ').append("::").append('(');
        PrintSeparator separator = new PrintSeparator();
        for (PrintBuffer parameter : method.parameterTypes()) {
            buffer.append(separator.next());
            buffer.append(parameter);
        }
        buffer.append(')');
        return buffer.toString();
    }

    public String toString() {
        return "#" + this.descriptorIndex;
    }
}

