/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap;

import de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap.BytecodeInstructionReferenceEntry;
import de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap.InstructionForm;
import de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap.InstructionFormat;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

final class BytecodeInstructionReferenceScraper
implements Closeable {
    private static final Log LOG = new Log();
    private final BufferedReader in;
    private final Deque<BytecodeInstructionReferenceEntry> entries = new LinkedList<BytecodeInstructionReferenceEntry>();
    private static final Set<String> IGNORED_INSTRUCTIONS = new HashSet<String>();
    private static final Pattern INSTRUCTION_ENTRY_PATTERN;
    private static final Pattern SECTION_PATTERN;
    private static final Pattern FORMAT_PATTERN;
    private static final Pattern FORM1_PATTERN;
    private static final Pattern FORM2_PATTERN;
    private static final Pattern PENDING_END_PARAGRAPH_PATTERN;
    private static final Pattern OPERAND_STACK_IN1_PATTERN;
    private static final Pattern OPERAND_STACK_IN2_PATTERN;
    private static final Pattern OPERAND_STACK_OUT1_PATTERN;
    private static final Pattern OPERAND_STACK_OUT2_PATTERN;
    private static final Pattern OPERAND_STACK_OUT3_PATTERN;
    private static final String NO_OPERAND_STACK_CHANGE = "No change";
    private static final String[][] DECODE_OPERAND_STACK_TABLE;
    private static final String[][] DECODE_HTML_TABLE;

    BytecodeInstructionReferenceScraper(InputStream referenceStream, Charset cs) {
        this.in = new BufferedReader(new InputStreamReader(referenceStream, cs));
    }

    public @Nullable BytecodeInstructionReferenceEntry scrapeNext() throws IOException {
        return !this.entries.isEmpty() || this.scrapNextReference() ? this.entries.pop() : null;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private boolean scrapNextReference() throws IOException {
        String line;
        LOG.debug("Scraping next reference...", new Object[0]);
        while (this.entries.isEmpty() && (line = this.readLine()) != null) {
            Matcher instructionEntryMatcher = INSTRUCTION_ENTRY_PATTERN.matcher(line);
            if (!instructionEntryMatcher.matches()) continue;
            String instruction = this.decodeHtml(Objects.requireNonNull(instructionEntryMatcher.group(1)));
            if (IGNORED_INSTRUCTIONS.contains(instruction)) {
                LOG.notice("Ignoring instruction reference: {0}", new Object[]{instruction});
                continue;
            }
            LOG.notice("Processing instruction reference: {0}", new Object[]{instruction});
            InstructionFormat format = null;
            List<InstructionForm> forms = null;
            String operandStackIn = null;
            String operandStackOut = null;
            while (true) {
                Matcher sectionMatcher;
                if (!(sectionMatcher = SECTION_PATTERN.matcher(this.safeReadLine())).matches()) {
                    continue;
                }
                String section = this.decodeHtml(Objects.requireNonNull(sectionMatcher.group(1)));
                LOG.debug("Scraping section ''{0}''", new Object[]{section});
                if ("Operation".equals(section)) continue;
                if ("Format".equals(section)) {
                    format = this.scrapeFormat();
                    continue;
                }
                if ("Forms".equals(section)) {
                    forms = this.scrapForms();
                    continue;
                }
                if ("Operand Stack".equals(section)) break;
            }
            operandStackIn = this.scrapeOperandStackIn();
            if (NO_OPERAND_STACK_CHANGE.equals(operandStackIn)) {
                operandStackIn = "";
                operandStackOut = "";
            } else {
                operandStackOut = this.scrapeOperandStackOut();
            }
            if (format == null || forms == null || operandStackIn == null || operandStackOut == null) {
                throw new IOException("Scrape failure");
            }
            LOG.info(" format: {0}", new Object[]{format});
            LOG.info(" forms: {0}", new Object[]{Strings.join(forms, (String)"|")});
            for (InstructionForm form : forms) {
                this.entries.add(new BytecodeInstructionReferenceEntry(form.opcode(), form.mnemonic(), new String[0]));
            }
        }
        return !this.entries.isEmpty();
    }

    private InstructionFormat scrapeFormat() throws IOException {
        Matcher formatMatcher;
        LOG.debug("Scraping format...", new Object[0]);
        while (!(formatMatcher = FORMAT_PATTERN.matcher(this.safeReadLine())).matches()) {
        }
        String instruction = this.decodeHtml(Objects.requireNonNull(formatMatcher.group(1)));
        ArrayList<String> arguments = new ArrayList<String>();
        formatMatcher = FORMAT_PATTERN.matcher(this.safeReadLine());
        while (formatMatcher.matches()) {
            arguments.add(this.decodeHtml(Objects.requireNonNull(formatMatcher.group(1))));
            formatMatcher = FORMAT_PATTERN.matcher(this.safeReadLine());
        }
        return new InstructionFormat(instruction, arguments);
    }

    private List<InstructionForm> scrapForms() throws IOException {
        Matcher formMatcher;
        LOG.debug("Scraping forms...", new Object[0]);
        ArrayList<InstructionForm> forms = new ArrayList<InstructionForm>();
        while (!(formMatcher = this.anyMatcher(this.safeReadLine(), FORM1_PATTERN, FORM2_PATTERN)).matches()) {
        }
        do {
            if (formMatcher.groupCount() == 0) continue;
            String mnemonic = Objects.requireNonNull(formMatcher.group(1));
            byte[] opcodes = new byte[]{this.decodeByte(Objects.requireNonNull(formMatcher.group(2)))};
            forms.add(new InstructionForm(mnemonic, opcodes));
        } while ((formMatcher = this.anyMatcher(this.safeReadLine(), FORM1_PATTERN, FORM2_PATTERN, PENDING_END_PARAGRAPH_PATTERN)).matches());
        return forms;
    }

    private String scrapeOperandStackIn() throws IOException {
        Matcher operandStackInMatcher;
        LOG.debug("Scraping operand stack in...", new Object[0]);
        while (!(operandStackInMatcher = this.anyMatcher(this.safeReadLine(), OPERAND_STACK_IN1_PATTERN, OPERAND_STACK_IN2_PATTERN)).matches()) {
        }
        return this.decodeText(Objects.requireNonNull(operandStackInMatcher.group(1)), DECODE_OPERAND_STACK_TABLE).trim();
    }

    private String scrapeOperandStackOut() throws IOException {
        Matcher operandStackOutMatcher;
        LOG.debug("Scraping operand stack out...", new Object[0]);
        while ((operandStackOutMatcher = this.anyMatcher(this.safeReadLine(), OPERAND_STACK_OUT1_PATTERN, OPERAND_STACK_OUT2_PATTERN, OPERAND_STACK_OUT3_PATTERN, PENDING_END_PARAGRAPH_PATTERN)).matches() && operandStackOutMatcher.groupCount() == 0) {
        }
        if (!operandStackOutMatcher.matches()) {
            throw new IOException("Failed to match operand stack out argument(s)");
        }
        String out = operandStackOutMatcher.groupCount() != 0 ? this.decodeText(Objects.requireNonNull(operandStackOutMatcher.group(1)), DECODE_OPERAND_STACK_TABLE).trim() : "";
        return out;
    }

    private Matcher anyMatcher(String input, Pattern pattern, Pattern ... extraPatterns) {
        Matcher matcher = pattern.matcher(input);
        for (Pattern extraPattern : extraPatterns) {
            if (matcher.matches()) break;
            matcher = extraPattern.matcher(input);
        }
        return matcher;
    }

    private @Nullable String readLine() throws IOException {
        String line = this.in.readLine();
        if (line != null) {
            LOG.trace("Processing line: {0}", new Object[]{line});
        }
        return line;
    }

    private String safeReadLine() throws IOException {
        String line = this.readLine();
        if (line == null) {
            throw new EOFException("Unexpected EOF");
        }
        return line;
    }

    private String decodeHtml(String html) {
        return this.decodeText(html, DECODE_HTML_TABLE);
    }

    private String decodeText(String text, String[][] decodeTable) {
        String decoded = text;
        for (String[] mapping : decodeTable) {
            decoded = decoded.replace(mapping[0], mapping[1]);
        }
        return decoded;
    }

    private byte decodeByte(String text) throws IOException {
        int byteValue;
        try {
            byteValue = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new IOException("Failed to decode byte value: '" + text + "'", e);
        }
        if (byteValue < 0 || 255 < byteValue) {
            throw new IOException("Byte value out of range: " + text);
        }
        return (byte)(byteValue & 0xFF);
    }

    static {
        IGNORED_INSTRUCTIONS.add("dup2_x1");
        IGNORED_INSTRUCTIONS.add("dup2_x2");
        IGNORED_INSTRUCTIONS.add("pop2");
        IGNORED_INSTRUCTIONS.add("wide");
        INSTRUCTION_ENTRY_PATTERN = Pattern.compile(".*<h3 class=\"title\"><a name=\"jvms-6\\.5\\..+\"></a><span class=\"emphasis\"><em>(.*)</em></span></h3>.*");
        SECTION_PATTERN = Pattern.compile(".*<div class=\"section\" title=\"(.+)\">.*");
        FORMAT_PATTERN = Pattern.compile(".*<span class=\"emphasis\"><em>(.+)</em></span>.*");
        FORM1_PATTERN = Pattern.compile(".*<p class=\"norm\"><span class=\"emphasis\"><em>(.+)</em></span> = (\\d+) .*");
        FORM2_PATTERN = Pattern.compile(".*<p class=\"norm\">(.+) = (\\d+) .*");
        PENDING_END_PARAGRAPH_PATTERN = Pattern.compile(".*</p>.*");
        OPERAND_STACK_IN1_PATTERN = Pattern.compile(".*<p class=\"norm\">\\.\\.\\.[,]?(.*)<span class=\"symbol\">&#8594;</span>.*");
        OPERAND_STACK_IN2_PATTERN = Pattern.compile(".*<p class=\"norm\">(No change)</p>.*");
        OPERAND_STACK_OUT1_PATTERN = Pattern.compile(".*<p class=\"norm\">(\\[empty\\])</p>.*");
        OPERAND_STACK_OUT2_PATTERN = Pattern.compile(".*<p class=\"norm\">[\\\\.]{0,3}[,]?(.*)</p>");
        OPERAND_STACK_OUT3_PATTERN = Pattern.compile(".*<p class=\"norm\">[\\.]{0,3}[,]?[ ]?(&lt;.*&gt;)");
        DECODE_OPERAND_STACK_TABLE = new String[][]{{"<span class=\"emphasis\"><em>", ""}, {"</em></span>", ""}, {"<code class=\"literal\">", ""}, {"</code>", ""}, {"&lt;", "<"}, {"&gt;", ">"}, {"[empty]", ""}};
        DECODE_HTML_TABLE = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&nbsp;", " "}};
    }
}

