/*
 * Decompiled with CFR 0.152.
 */
package de.carne.mcd.jvmdecoder.classfile.bytecode.bootstrap;

import de.carne.mcd.bootstrap.InstructionReferenceEntry;
import de.carne.mcd.instruction.Instruction;
import de.carne.mcd.instruction.InstructionOpcode;
import de.carne.mcd.jvmdecoder.classfile.bytecode.ByteOperandType;
import de.carne.mcd.jvmdecoder.classfile.bytecode.BytecodeInstruction;
import de.carne.mcd.jvmdecoder.classfile.bytecode.IntOperandType;
import de.carne.mcd.jvmdecoder.classfile.bytecode.LookupswitchOperandDecoder;
import de.carne.mcd.jvmdecoder.classfile.bytecode.OperandType;
import de.carne.mcd.jvmdecoder.classfile.bytecode.ShortOperandType;
import de.carne.mcd.jvmdecoder.classfile.bytecode.TableswitchOperandDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

class BytecodeInstructionReferenceEntry
extends InstructionReferenceEntry {
    BytecodeInstructionReferenceEntry(InstructionReferenceEntry entryData) {
        super(entryData);
    }

    BytecodeInstructionReferenceEntry(InstructionOpcode opcode, String mnemonic, String ... extraFields) {
        super(opcode, mnemonic, Arrays.asList(extraFields));
    }

    public Instruction toInstruction() throws IOException {
        ArrayList<OperandType> operands = new ArrayList<OperandType>();
        for (String extraField : this.extraFields()) {
            if (extraField.equals("t")) {
                operands.add(new TableswitchOperandDecoder());
                continue;
            }
            if (extraField.equals("l")) {
                operands.add(new LookupswitchOperandDecoder());
                continue;
            }
            if (extraField.startsWith("B:")) {
                operands.add(ByteOperandType.valueOf(extraField.substring(2)));
                continue;
            }
            if (extraField.startsWith("S:")) {
                operands.add(ShortOperandType.valueOf(extraField.substring(2)));
                continue;
            }
            if (extraField.startsWith("I:")) {
                operands.add(IntOperandType.valueOf(extraField.substring(2)));
                continue;
            }
            throw new IOException("Unrecognized operand: " + extraField);
        }
        return new BytecodeInstruction(this.mnemonic(), operands.toArray(new OperandType[operands.size()]));
    }
}

